// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package data

import (
	"fmt"
	"io"
	"math"
	"sort"

	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

func (t *GenericRecord) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.Type (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if len(t.Type) > 1000000 {
		return xerrors.Errorf("Value in field t.Type was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Type))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Type)); err != nil {
		return err
	}
	return nil
}

func (t *GenericRecord) UnmarshalCBOR(r io.Reader) (err error) {
	*t = GenericRecord{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("GenericRecord: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Type (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Type = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *LegacyBlobSchema) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Cid (string) (string)
	if len("cid") > 1000000 {
		return xerrors.Errorf("Value in field \"cid\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("cid"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("cid")); err != nil {
		return err
	}

	if len(t.Cid) > 1000000 {
		return xerrors.Errorf("Value in field t.Cid was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Cid))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Cid)); err != nil {
		return err
	}

	// t.MimeType (string) (string)
	if len("mimeType") > 1000000 {
		return xerrors.Errorf("Value in field \"mimeType\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("mimeType"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("mimeType")); err != nil {
		return err
	}

	if len(t.MimeType) > 1000000 {
		return xerrors.Errorf("Value in field t.MimeType was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.MimeType))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.MimeType)); err != nil {
		return err
	}
	return nil
}

func (t *LegacyBlobSchema) UnmarshalCBOR(r io.Reader) (err error) {
	*t = LegacyBlobSchema{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("LegacyBlobSchema: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Cid (string) (string)
		case "cid":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.Cid = string(sval)
			}
			// t.MimeType (string) (string)
		case "mimeType":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.MimeType = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *BlobSchema) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{164}); err != nil {
		return err
	}

	// t.Ref (data.CIDLink) (struct)
	if len("ref") > 1000000 {
		return xerrors.Errorf("Value in field \"ref\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("ref"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("ref")); err != nil {
		return err
	}

	if err := t.Ref.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Size (int64) (int64)
	if len("size") > 1000000 {
		return xerrors.Errorf("Value in field \"size\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("size"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("size")); err != nil {
		return err
	}

	if t.Size >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Size)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Size-1)); err != nil {
			return err
		}
	}

	// t.LexiconTypeID (string) (string)
	if len("$type") > 1000000 {
		return xerrors.Errorf("Value in field \"$type\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("$type"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("$type")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("blob"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("blob")); err != nil {
		return err
	}

	// t.MimeType (string) (string)
	if len("mimeType") > 1000000 {
		return xerrors.Errorf("Value in field \"mimeType\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("mimeType"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("mimeType")); err != nil {
		return err
	}

	if len(t.MimeType) > 1000000 {
		return xerrors.Errorf("Value in field t.MimeType was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.MimeType))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.MimeType)); err != nil {
		return err
	}
	return nil
}

func (t *BlobSchema) UnmarshalCBOR(r io.Reader) (err error) {
	*t = BlobSchema{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("BlobSchema: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 1000000)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Ref (data.CIDLink) (struct)
		case "ref":

			{

				if err := t.Ref.UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.Ref: %w", err)
				}

			}
			// t.Size (int64) (int64)
		case "size":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Size = int64(extraI)
			}
			// t.LexiconTypeID (string) (string)
		case "$type":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.LexiconTypeID = string(sval)
			}
			// t.MimeType (string) (string)
		case "mimeType":

			{
				sval, err := cbg.ReadStringWithMax(cr, 1000000)
				if err != nil {
					return err
				}

				t.MimeType = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
