// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanagerusersubscriptions

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opAssociateUser = "AssociateUser"

// AssociateUserRequest generates a "aws/request.Request" representing the
// client's request for the AssociateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateUser for more information on using the AssociateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateUserRequest method.
//	req, resp := client.AssociateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/AssociateUser
func (c *LicenseManagerUserSubscriptions) AssociateUserRequest(input *AssociateUserInput) (req *request.Request, output *AssociateUserOutput) {
	op := &request.Operation{
		Name:       opAssociateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/user/AssociateUser",
	}

	if input == nil {
		input = &AssociateUserInput{}
	}

	output = &AssociateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateUser API operation for AWS License Manager User Subscriptions.
//
// Associates the user to an EC2 instance to utilize user-based subscriptions.
//
// Your estimated bill for charges on the number of users and related costs
// will take 48 hours to appear for billing periods that haven't closed (marked
// as Pending billing status) in Amazon Web Services Billing. For more information,
// see Viewing your monthly charges (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html)
// in the Amazon Web Services Billing User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation AssociateUser for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/AssociateUser
func (c *LicenseManagerUserSubscriptions) AssociateUser(input *AssociateUserInput) (*AssociateUserOutput, error) {
	req, out := c.AssociateUserRequest(input)
	return out, req.Send()
}

// AssociateUserWithContext is the same as AssociateUser with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) AssociateUserWithContext(ctx aws.Context, input *AssociateUserInput, opts ...request.Option) (*AssociateUserOutput, error) {
	req, out := c.AssociateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterIdentityProvider = "DeregisterIdentityProvider"

// DeregisterIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterIdentityProvider for more information on using the DeregisterIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterIdentityProviderRequest method.
//	req, resp := client.DeregisterIdentityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DeregisterIdentityProvider
func (c *LicenseManagerUserSubscriptions) DeregisterIdentityProviderRequest(input *DeregisterIdentityProviderInput) (req *request.Request, output *DeregisterIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opDeregisterIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/identity-provider/DeregisterIdentityProvider",
	}

	if input == nil {
		input = &DeregisterIdentityProviderInput{}
	}

	output = &DeregisterIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterIdentityProvider API operation for AWS License Manager User Subscriptions.
//
// Deregisters the identity provider from providing user-based subscriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation DeregisterIdentityProvider for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DeregisterIdentityProvider
func (c *LicenseManagerUserSubscriptions) DeregisterIdentityProvider(input *DeregisterIdentityProviderInput) (*DeregisterIdentityProviderOutput, error) {
	req, out := c.DeregisterIdentityProviderRequest(input)
	return out, req.Send()
}

// DeregisterIdentityProviderWithContext is the same as DeregisterIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) DeregisterIdentityProviderWithContext(ctx aws.Context, input *DeregisterIdentityProviderInput, opts ...request.Option) (*DeregisterIdentityProviderOutput, error) {
	req, out := c.DeregisterIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateUser = "DisassociateUser"

// DisassociateUserRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateUser for more information on using the DisassociateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateUserRequest method.
//	req, resp := client.DisassociateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DisassociateUser
func (c *LicenseManagerUserSubscriptions) DisassociateUserRequest(input *DisassociateUserInput) (req *request.Request, output *DisassociateUserOutput) {
	op := &request.Operation{
		Name:       opDisassociateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/user/DisassociateUser",
	}

	if input == nil {
		input = &DisassociateUserInput{}
	}

	output = &DisassociateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateUser API operation for AWS License Manager User Subscriptions.
//
// Disassociates the user from an EC2 instance providing user-based subscriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation DisassociateUser for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/DisassociateUser
func (c *LicenseManagerUserSubscriptions) DisassociateUser(input *DisassociateUserInput) (*DisassociateUserOutput, error) {
	req, out := c.DisassociateUserRequest(input)
	return out, req.Send()
}

// DisassociateUserWithContext is the same as DisassociateUser with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) DisassociateUserWithContext(ctx aws.Context, input *DisassociateUserInput, opts ...request.Option) (*DisassociateUserOutput, error) {
	req, out := c.DisassociateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIdentityProviders = "ListIdentityProviders"

// ListIdentityProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityProviders for more information on using the ListIdentityProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentityProvidersRequest method.
//	req, resp := client.ListIdentityProvidersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders
func (c *LicenseManagerUserSubscriptions) ListIdentityProvidersRequest(input *ListIdentityProvidersInput) (req *request.Request, output *ListIdentityProvidersOutput) {
	op := &request.Operation{
		Name:       opListIdentityProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/identity-provider/ListIdentityProviders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentityProvidersInput{}
	}

	output = &ListIdentityProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityProviders API operation for AWS License Manager User Subscriptions.
//
// Lists the identity providers for user-based subscriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation ListIdentityProviders for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListIdentityProviders
func (c *LicenseManagerUserSubscriptions) ListIdentityProviders(input *ListIdentityProvidersInput) (*ListIdentityProvidersOutput, error) {
	req, out := c.ListIdentityProvidersRequest(input)
	return out, req.Send()
}

// ListIdentityProvidersWithContext is the same as ListIdentityProviders with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) ListIdentityProvidersWithContext(ctx aws.Context, input *ListIdentityProvidersInput, opts ...request.Option) (*ListIdentityProvidersOutput, error) {
	req, out := c.ListIdentityProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdentityProvidersPages iterates over the pages of a ListIdentityProviders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdentityProviders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdentityProviders operation.
//	pageNum := 0
//	err := client.ListIdentityProvidersPages(params,
//	    func(page *licensemanagerusersubscriptions.ListIdentityProvidersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LicenseManagerUserSubscriptions) ListIdentityProvidersPages(input *ListIdentityProvidersInput, fn func(*ListIdentityProvidersOutput, bool) bool) error {
	return c.ListIdentityProvidersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdentityProvidersPagesWithContext same as ListIdentityProvidersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) ListIdentityProvidersPagesWithContext(ctx aws.Context, input *ListIdentityProvidersInput, fn func(*ListIdentityProvidersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdentityProvidersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdentityProvidersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdentityProvidersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstances for more information on using the ListInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInstancesRequest method.
//	req, resp := client.ListInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances
func (c *LicenseManagerUserSubscriptions) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/instance/ListInstances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	output = &ListInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstances API operation for AWS License Manager User Subscriptions.
//
// Lists the EC2 instances providing user-based subscriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation ListInstances for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListInstances
func (c *LicenseManagerUserSubscriptions) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	return out, req.Send()
}

// ListInstancesWithContext is the same as ListInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) ListInstancesWithContext(ctx aws.Context, input *ListInstancesInput, opts ...request.Option) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstancesPages iterates over the pages of a ListInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInstances operation.
//	pageNum := 0
//	err := client.ListInstancesPages(params,
//	    func(page *licensemanagerusersubscriptions.ListInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LicenseManagerUserSubscriptions) ListInstancesPages(input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool) error {
	return c.ListInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstancesPagesWithContext same as ListInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) ListInstancesPagesWithContext(ctx aws.Context, input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProductSubscriptions = "ListProductSubscriptions"

// ListProductSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListProductSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProductSubscriptions for more information on using the ListProductSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProductSubscriptionsRequest method.
//	req, resp := client.ListProductSubscriptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions
func (c *LicenseManagerUserSubscriptions) ListProductSubscriptionsRequest(input *ListProductSubscriptionsInput) (req *request.Request, output *ListProductSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListProductSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/user/ListProductSubscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProductSubscriptionsInput{}
	}

	output = &ListProductSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProductSubscriptions API operation for AWS License Manager User Subscriptions.
//
// Lists the user-based subscription products available from an identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation ListProductSubscriptions for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListProductSubscriptions
func (c *LicenseManagerUserSubscriptions) ListProductSubscriptions(input *ListProductSubscriptionsInput) (*ListProductSubscriptionsOutput, error) {
	req, out := c.ListProductSubscriptionsRequest(input)
	return out, req.Send()
}

// ListProductSubscriptionsWithContext is the same as ListProductSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListProductSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) ListProductSubscriptionsWithContext(ctx aws.Context, input *ListProductSubscriptionsInput, opts ...request.Option) (*ListProductSubscriptionsOutput, error) {
	req, out := c.ListProductSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProductSubscriptionsPages iterates over the pages of a ListProductSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProductSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProductSubscriptions operation.
//	pageNum := 0
//	err := client.ListProductSubscriptionsPages(params,
//	    func(page *licensemanagerusersubscriptions.ListProductSubscriptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LicenseManagerUserSubscriptions) ListProductSubscriptionsPages(input *ListProductSubscriptionsInput, fn func(*ListProductSubscriptionsOutput, bool) bool) error {
	return c.ListProductSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProductSubscriptionsPagesWithContext same as ListProductSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) ListProductSubscriptionsPagesWithContext(ctx aws.Context, input *ListProductSubscriptionsInput, fn func(*ListProductSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProductSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProductSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProductSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserAssociations = "ListUserAssociations"

// ListUserAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserAssociations for more information on using the ListUserAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUserAssociationsRequest method.
//	req, resp := client.ListUserAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations
func (c *LicenseManagerUserSubscriptions) ListUserAssociationsRequest(input *ListUserAssociationsInput) (req *request.Request, output *ListUserAssociationsOutput) {
	op := &request.Operation{
		Name:       opListUserAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/user/ListUserAssociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserAssociationsInput{}
	}

	output = &ListUserAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserAssociations API operation for AWS License Manager User Subscriptions.
//
// Lists user associations for an identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation ListUserAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/ListUserAssociations
func (c *LicenseManagerUserSubscriptions) ListUserAssociations(input *ListUserAssociationsInput) (*ListUserAssociationsOutput, error) {
	req, out := c.ListUserAssociationsRequest(input)
	return out, req.Send()
}

// ListUserAssociationsWithContext is the same as ListUserAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) ListUserAssociationsWithContext(ctx aws.Context, input *ListUserAssociationsInput, opts ...request.Option) (*ListUserAssociationsOutput, error) {
	req, out := c.ListUserAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserAssociationsPages iterates over the pages of a ListUserAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUserAssociations operation.
//	pageNum := 0
//	err := client.ListUserAssociationsPages(params,
//	    func(page *licensemanagerusersubscriptions.ListUserAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LicenseManagerUserSubscriptions) ListUserAssociationsPages(input *ListUserAssociationsInput, fn func(*ListUserAssociationsOutput, bool) bool) error {
	return c.ListUserAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserAssociationsPagesWithContext same as ListUserAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) ListUserAssociationsPagesWithContext(ctx aws.Context, input *ListUserAssociationsInput, fn func(*ListUserAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRegisterIdentityProvider = "RegisterIdentityProvider"

// RegisterIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the RegisterIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterIdentityProvider for more information on using the RegisterIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterIdentityProviderRequest method.
//	req, resp := client.RegisterIdentityProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/RegisterIdentityProvider
func (c *LicenseManagerUserSubscriptions) RegisterIdentityProviderRequest(input *RegisterIdentityProviderInput) (req *request.Request, output *RegisterIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opRegisterIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/identity-provider/RegisterIdentityProvider",
	}

	if input == nil {
		input = &RegisterIdentityProviderInput{}
	}

	output = &RegisterIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterIdentityProvider API operation for AWS License Manager User Subscriptions.
//
// Registers an identity provider for user-based subscriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation RegisterIdentityProvider for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/RegisterIdentityProvider
func (c *LicenseManagerUserSubscriptions) RegisterIdentityProvider(input *RegisterIdentityProviderInput) (*RegisterIdentityProviderOutput, error) {
	req, out := c.RegisterIdentityProviderRequest(input)
	return out, req.Send()
}

// RegisterIdentityProviderWithContext is the same as RegisterIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) RegisterIdentityProviderWithContext(ctx aws.Context, input *RegisterIdentityProviderInput, opts ...request.Option) (*RegisterIdentityProviderOutput, error) {
	req, out := c.RegisterIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartProductSubscription = "StartProductSubscription"

// StartProductSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StartProductSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartProductSubscription for more information on using the StartProductSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartProductSubscriptionRequest method.
//	req, resp := client.StartProductSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StartProductSubscription
func (c *LicenseManagerUserSubscriptions) StartProductSubscriptionRequest(input *StartProductSubscriptionInput) (req *request.Request, output *StartProductSubscriptionOutput) {
	op := &request.Operation{
		Name:       opStartProductSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/user/StartProductSubscription",
	}

	if input == nil {
		input = &StartProductSubscriptionInput{}
	}

	output = &StartProductSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartProductSubscription API operation for AWS License Manager User Subscriptions.
//
// Starts a product subscription for a user with the specified identity provider.
//
// Your estimated bill for charges on the number of users and related costs
// will take 48 hours to appear for billing periods that haven't closed (marked
// as Pending billing status) in Amazon Web Services Billing. For more information,
// see Viewing your monthly charges (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/invoice.html)
// in the Amazon Web Services Billing User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation StartProductSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StartProductSubscription
func (c *LicenseManagerUserSubscriptions) StartProductSubscription(input *StartProductSubscriptionInput) (*StartProductSubscriptionOutput, error) {
	req, out := c.StartProductSubscriptionRequest(input)
	return out, req.Send()
}

// StartProductSubscriptionWithContext is the same as StartProductSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See StartProductSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) StartProductSubscriptionWithContext(ctx aws.Context, input *StartProductSubscriptionInput, opts ...request.Option) (*StartProductSubscriptionOutput, error) {
	req, out := c.StartProductSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopProductSubscription = "StopProductSubscription"

// StopProductSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StopProductSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopProductSubscription for more information on using the StopProductSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopProductSubscriptionRequest method.
//	req, resp := client.StopProductSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StopProductSubscription
func (c *LicenseManagerUserSubscriptions) StopProductSubscriptionRequest(input *StopProductSubscriptionInput) (req *request.Request, output *StopProductSubscriptionOutput) {
	op := &request.Operation{
		Name:       opStopProductSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/user/StopProductSubscription",
	}

	if input == nil {
		input = &StopProductSubscriptionInput{}
	}

	output = &StopProductSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopProductSubscription API operation for AWS License Manager User Subscriptions.
//
// Stops a product subscription for a user with the specified identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation StopProductSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request failed because a service quota is exceeded.
//
//   - ConflictException
//     The request couldn't be completed because it conflicted with the current
//     state of the resource.
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - ResourceNotFoundException
//     The resource couldn't be found.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/StopProductSubscription
func (c *LicenseManagerUserSubscriptions) StopProductSubscription(input *StopProductSubscriptionInput) (*StopProductSubscriptionOutput, error) {
	req, out := c.StopProductSubscriptionRequest(input)
	return out, req.Send()
}

// StopProductSubscriptionWithContext is the same as StopProductSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See StopProductSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) StopProductSubscriptionWithContext(ctx aws.Context, input *StopProductSubscriptionInput, opts ...request.Option) (*StopProductSubscriptionOutput, error) {
	req, out := c.StopProductSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdentityProviderSettings = "UpdateIdentityProviderSettings"

// UpdateIdentityProviderSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdentityProviderSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdentityProviderSettings for more information on using the UpdateIdentityProviderSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIdentityProviderSettingsRequest method.
//	req, resp := client.UpdateIdentityProviderSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/UpdateIdentityProviderSettings
func (c *LicenseManagerUserSubscriptions) UpdateIdentityProviderSettingsRequest(input *UpdateIdentityProviderSettingsInput) (req *request.Request, output *UpdateIdentityProviderSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateIdentityProviderSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/identity-provider/UpdateIdentityProviderSettings",
	}

	if input == nil {
		input = &UpdateIdentityProviderSettingsInput{}
	}

	output = &UpdateIdentityProviderSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdentityProviderSettings API operation for AWS License Manager User Subscriptions.
//
// Updates additional product configuration settings for the registered identity
// provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager User Subscriptions's
// API operation UpdateIdentityProviderSettings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     A parameter is not valid.
//
//   - ThrottlingException
//     The request was denied because of request throttling. Retry the request.
//
//   - InternalServerException
//     An exception occurred with the service.
//
//   - AccessDeniedException
//     You don't have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-user-subscriptions-2018-05-10/UpdateIdentityProviderSettings
func (c *LicenseManagerUserSubscriptions) UpdateIdentityProviderSettings(input *UpdateIdentityProviderSettingsInput) (*UpdateIdentityProviderSettingsOutput, error) {
	req, out := c.UpdateIdentityProviderSettingsRequest(input)
	return out, req.Send()
}

// UpdateIdentityProviderSettingsWithContext is the same as UpdateIdentityProviderSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdentityProviderSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManagerUserSubscriptions) UpdateIdentityProviderSettingsWithContext(ctx aws.Context, input *UpdateIdentityProviderSettingsInput, opts ...request.Option) (*UpdateIdentityProviderSettingsOutput, error) {
	req, out := c.UpdateIdentityProviderSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about an Active Directory identity provider.
type ActiveDirectoryIdentityProvider struct {
	_ struct{} `type:"structure"`

	// The directory ID for an Active Directory identity provider.
	DirectoryId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveDirectoryIdentityProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveDirectoryIdentityProvider) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ActiveDirectoryIdentityProvider) SetDirectoryId(v string) *ActiveDirectoryIdentityProvider {
	s.DirectoryId = &v
	return s
}

type AssociateUserInput struct {
	_ struct{} `type:"structure"`

	// The domain name of the user.
	Domain *string `type:"string"`

	// The identity provider of the user.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The ID of the EC2 instance, which provides user-based subscriptions.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The user name from the identity provider for the user.
	//
	// Username is a required field
	Username *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateUserInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AssociateUserInput) SetDomain(v string) *AssociateUserInput {
	s.Domain = &v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *AssociateUserInput) SetIdentityProvider(v *IdentityProvider) *AssociateUserInput {
	s.IdentityProvider = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateUserInput) SetInstanceId(v string) *AssociateUserInput {
	s.InstanceId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AssociateUserInput) SetUsername(v string) *AssociateUserInput {
	s.Username = &v
	return s
}

type AssociateUserOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the associate user operation.
	//
	// InstanceUserSummary is a required field
	InstanceUserSummary *InstanceUserSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateUserOutput) GoString() string {
	return s.String()
}

// SetInstanceUserSummary sets the InstanceUserSummary field's value.
func (s *AssociateUserOutput) SetInstanceUserSummary(v *InstanceUserSummary) *AssociateUserOutput {
	s.InstanceUserSummary = v
	return s
}

// The request couldn't be completed because it conflicted with the current
// state of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeregisterIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The name of the user-based subscription product.
	//
	// Product is a required field
	Product *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterIdentityProviderInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.Product == nil {
		invalidParams.Add(request.NewErrParamRequired("Product"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *DeregisterIdentityProviderInput) SetIdentityProvider(v *IdentityProvider) *DeregisterIdentityProviderInput {
	s.IdentityProvider = v
	return s
}

// SetProduct sets the Product field's value.
func (s *DeregisterIdentityProviderInput) SetProduct(v string) *DeregisterIdentityProviderInput {
	s.Product = &v
	return s
}

type DeregisterIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the results of an identity provider operation.
	//
	// IdentityProviderSummary is a required field
	IdentityProviderSummary *IdentityProviderSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderSummary sets the IdentityProviderSummary field's value.
func (s *DeregisterIdentityProviderOutput) SetIdentityProviderSummary(v *IdentityProviderSummary) *DeregisterIdentityProviderOutput {
	s.IdentityProviderSummary = v
	return s
}

type DisassociateUserInput struct {
	_ struct{} `type:"structure"`

	// The domain name of the user.
	Domain *string `type:"string"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The ID of the EC2 instance, which provides user-based subscriptions.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The user name from the identity provider for the user.
	//
	// Username is a required field
	Username *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateUserInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DisassociateUserInput) SetDomain(v string) *DisassociateUserInput {
	s.Domain = &v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *DisassociateUserInput) SetIdentityProvider(v *IdentityProvider) *DisassociateUserInput {
	s.IdentityProvider = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DisassociateUserInput) SetInstanceId(v string) *DisassociateUserInput {
	s.InstanceId = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *DisassociateUserInput) SetUsername(v string) *DisassociateUserInput {
	s.Username = &v
	return s
}

type DisassociateUserOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the associate user operation.
	//
	// InstanceUserSummary is a required field
	InstanceUserSummary *InstanceUserSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateUserOutput) GoString() string {
	return s.String()
}

// SetInstanceUserSummary sets the InstanceUserSummary field's value.
func (s *DisassociateUserOutput) SetInstanceUserSummary(v *InstanceUserSummary) *DisassociateUserOutput {
	s.InstanceUserSummary = v
	return s
}

// A filter name and value pair that is used to return more specific results
// from a describe operation. Filters can be used to match a set of resources
// by specific criteria, such as tags, attributes, or IDs.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of an attribute to use as a filter.
	Attribute *string `type:"string"`

	// The type of search (For example, eq, geq, leq)
	Operation *string `type:"string"`

	// Value of the filter.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *Filter) SetAttribute(v string) *Filter {
	s.Attribute = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *Filter) SetOperation(v string) *Filter {
	s.Operation = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Filter) SetValue(v string) *Filter {
	s.Value = &v
	return s
}

// Details about an identity provider.
type IdentityProvider struct {
	_ struct{} `type:"structure"`

	// An object that details an Active Directory identity provider.
	ActiveDirectoryIdentityProvider *ActiveDirectoryIdentityProvider `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProvider) GoString() string {
	return s.String()
}

// SetActiveDirectoryIdentityProvider sets the ActiveDirectoryIdentityProvider field's value.
func (s *IdentityProvider) SetActiveDirectoryIdentityProvider(v *ActiveDirectoryIdentityProvider) *IdentityProvider {
	s.ActiveDirectoryIdentityProvider = v
	return s
}

// Describes an identity provider.
type IdentityProviderSummary struct {
	_ struct{} `type:"structure"`

	// The failure message associated with an identity provider.
	FailureMessage *string `type:"string"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The name of the user-based subscription product.
	//
	// Product is a required field
	Product *string `type:"string" required:"true"`

	// An object that details the registered identity provider’s product related
	// configuration settings such as the subnets to provision VPC endpoints.
	//
	// Settings is a required field
	Settings *Settings `type:"structure" required:"true"`

	// The status of an identity provider.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderSummary) GoString() string {
	return s.String()
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *IdentityProviderSummary) SetFailureMessage(v string) *IdentityProviderSummary {
	s.FailureMessage = &v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *IdentityProviderSummary) SetIdentityProvider(v *IdentityProvider) *IdentityProviderSummary {
	s.IdentityProvider = v
	return s
}

// SetProduct sets the Product field's value.
func (s *IdentityProviderSummary) SetProduct(v string) *IdentityProviderSummary {
	s.Product = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *IdentityProviderSummary) SetSettings(v *Settings) *IdentityProviderSummary {
	s.Settings = v
	return s
}

// SetStatus sets the Status field's value.
func (s *IdentityProviderSummary) SetStatus(v string) *IdentityProviderSummary {
	s.Status = &v
	return s
}

// Describes an EC2 instance providing user-based subscriptions.
type InstanceSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the EC2 instance, which provides user-based subscriptions.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The date of the last status check.
	LastStatusCheckDate *string `type:"string"`

	// A list of provided user-based subscription products.
	//
	// Products is a required field
	Products []*string `type:"list" required:"true"`

	// The status of an EC2 instance resource.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The status message for an EC2 instance.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceSummary) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceSummary) SetInstanceId(v string) *InstanceSummary {
	s.InstanceId = &v
	return s
}

// SetLastStatusCheckDate sets the LastStatusCheckDate field's value.
func (s *InstanceSummary) SetLastStatusCheckDate(v string) *InstanceSummary {
	s.LastStatusCheckDate = &v
	return s
}

// SetProducts sets the Products field's value.
func (s *InstanceSummary) SetProducts(v []*string) *InstanceSummary {
	s.Products = v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceSummary) SetStatus(v string) *InstanceSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *InstanceSummary) SetStatusMessage(v string) *InstanceSummary {
	s.StatusMessage = &v
	return s
}

// Describes users of an EC2 instance providing user-based subscriptions.
type InstanceUserSummary struct {
	_ struct{} `type:"structure"`

	// The date a user was associated with an EC2 instance.
	AssociationDate *string `type:"string"`

	// The date a user was disassociated from an EC2 instance.
	DisassociationDate *string `type:"string"`

	// The domain name of the user.
	Domain *string `type:"string"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The ID of the EC2 instance, which provides user-based subscriptions.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The status of a user associated with an EC2 instance.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The status message for users of an EC2 instance.
	StatusMessage *string `type:"string"`

	// The user name from the identity provider for the user.
	//
	// Username is a required field
	Username *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceUserSummary) GoString() string {
	return s.String()
}

// SetAssociationDate sets the AssociationDate field's value.
func (s *InstanceUserSummary) SetAssociationDate(v string) *InstanceUserSummary {
	s.AssociationDate = &v
	return s
}

// SetDisassociationDate sets the DisassociationDate field's value.
func (s *InstanceUserSummary) SetDisassociationDate(v string) *InstanceUserSummary {
	s.DisassociationDate = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *InstanceUserSummary) SetDomain(v string) *InstanceUserSummary {
	s.Domain = &v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *InstanceUserSummary) SetIdentityProvider(v *IdentityProvider) *InstanceUserSummary {
	s.IdentityProvider = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceUserSummary) SetInstanceId(v string) *InstanceUserSummary {
	s.InstanceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceUserSummary) SetStatus(v string) *InstanceUserSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *InstanceUserSummary) SetStatusMessage(v string) *InstanceUserSummary {
	s.StatusMessage = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InstanceUserSummary) SetUsername(v string) *InstanceUserSummary {
	s.Username = &v
	return s
}

// An exception occurred with the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListIdentityProvidersInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityProvidersInput) SetMaxResults(v int64) *ListIdentityProvidersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProvidersInput) SetNextToken(v string) *ListIdentityProvidersInput {
	s.NextToken = &v
	return s
}

type ListIdentityProvidersOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the list identity providers operation.
	//
	// IdentityProviderSummaries is a required field
	IdentityProviderSummaries []*IdentityProviderSummary `type:"list" required:"true"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProvidersOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderSummaries sets the IdentityProviderSummaries field's value.
func (s *ListIdentityProvidersOutput) SetIdentityProviderSummaries(v []*IdentityProviderSummary) *ListIdentityProvidersOutput {
	s.IdentityProviderSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProvidersOutput) SetNextToken(v string) *ListIdentityProvidersOutput {
	s.NextToken = &v
	return s
}

type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that you can use to filter the results to those that
	// match one or more sets of key-value pairs that you specify.
	Filters []*Filter `type:"list"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstancesInput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ListInstancesInput) SetFilters(v []*Filter) *ListInstancesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstancesInput) SetMaxResults(v int64) *ListInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesInput) SetNextToken(v string) *ListInstancesInput {
	s.NextToken = &v
	return s
}

type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the list instances operation.
	InstanceSummaries []*InstanceSummary `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstancesOutput) GoString() string {
	return s.String()
}

// SetInstanceSummaries sets the InstanceSummaries field's value.
func (s *ListInstancesOutput) SetInstanceSummaries(v []*InstanceSummary) *ListInstancesOutput {
	s.InstanceSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesOutput) SetNextToken(v string) *ListInstancesOutput {
	s.NextToken = &v
	return s
}

type ListProductSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that you can use to filter the results to those that
	// match one or more sets of key-value pairs that you specify.
	Filters []*Filter `type:"list"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`

	// The name of the user-based subscription product.
	//
	// Product is a required field
	Product *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProductSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProductSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProductSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProductSubscriptionsInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.Product == nil {
		invalidParams.Add(request.NewErrParamRequired("Product"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListProductSubscriptionsInput) SetFilters(v []*Filter) *ListProductSubscriptionsInput {
	s.Filters = v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *ListProductSubscriptionsInput) SetIdentityProvider(v *IdentityProvider) *ListProductSubscriptionsInput {
	s.IdentityProvider = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProductSubscriptionsInput) SetMaxResults(v int64) *ListProductSubscriptionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProductSubscriptionsInput) SetNextToken(v string) *ListProductSubscriptionsInput {
	s.NextToken = &v
	return s
}

// SetProduct sets the Product field's value.
func (s *ListProductSubscriptionsInput) SetProduct(v string) *ListProductSubscriptionsInput {
	s.Product = &v
	return s
}

type ListProductSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results.
	NextToken *string `type:"string"`

	// Metadata that describes the list product subscriptions operation.
	ProductUserSummaries []*ProductUserSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProductSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProductSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProductSubscriptionsOutput) SetNextToken(v string) *ListProductSubscriptionsOutput {
	s.NextToken = &v
	return s
}

// SetProductUserSummaries sets the ProductUserSummaries field's value.
func (s *ListProductSubscriptionsOutput) SetProductUserSummaries(v []*ProductUserSummary) *ListProductSubscriptionsOutput {
	s.ProductUserSummaries = v
	return s
}

type ListUserAssociationsInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that you can use to filter the results to those that
	// match one or more sets of key-value pairs that you specify.
	Filters []*Filter `type:"list"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The ID of the EC2 instance, which provides user-based subscriptions.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserAssociationsInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListUserAssociationsInput) SetFilters(v []*Filter) *ListUserAssociationsInput {
	s.Filters = v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *ListUserAssociationsInput) SetIdentityProvider(v *IdentityProvider) *ListUserAssociationsInput {
	s.IdentityProvider = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListUserAssociationsInput) SetInstanceId(v string) *ListUserAssociationsInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserAssociationsInput) SetMaxResults(v int64) *ListUserAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserAssociationsInput) SetNextToken(v string) *ListUserAssociationsInput {
	s.NextToken = &v
	return s
}

type ListUserAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the list user association operation.
	InstanceUserSummaries []*InstanceUserSummary `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUserAssociationsOutput) GoString() string {
	return s.String()
}

// SetInstanceUserSummaries sets the InstanceUserSummaries field's value.
func (s *ListUserAssociationsOutput) SetInstanceUserSummaries(v []*InstanceUserSummary) *ListUserAssociationsOutput {
	s.InstanceUserSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserAssociationsOutput) SetNextToken(v string) *ListUserAssociationsOutput {
	s.NextToken = &v
	return s
}

// The summary of the user-based subscription products for a user.
type ProductUserSummary struct {
	_ struct{} `type:"structure"`

	// The domain name of the user.
	Domain *string `type:"string"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The name of the user-based subscription product.
	//
	// Product is a required field
	Product *string `type:"string" required:"true"`

	// The status of a product for a user.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The status message for a product for a user.
	StatusMessage *string `type:"string"`

	// The end date of a subscription.
	SubscriptionEndDate *string `type:"string"`

	// The start date of a subscription.
	SubscriptionStartDate *string `type:"string"`

	// The user name from the identity provider of the user.
	//
	// Username is a required field
	Username *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProductUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProductUserSummary) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *ProductUserSummary) SetDomain(v string) *ProductUserSummary {
	s.Domain = &v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *ProductUserSummary) SetIdentityProvider(v *IdentityProvider) *ProductUserSummary {
	s.IdentityProvider = v
	return s
}

// SetProduct sets the Product field's value.
func (s *ProductUserSummary) SetProduct(v string) *ProductUserSummary {
	s.Product = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProductUserSummary) SetStatus(v string) *ProductUserSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ProductUserSummary) SetStatusMessage(v string) *ProductUserSummary {
	s.StatusMessage = &v
	return s
}

// SetSubscriptionEndDate sets the SubscriptionEndDate field's value.
func (s *ProductUserSummary) SetSubscriptionEndDate(v string) *ProductUserSummary {
	s.SubscriptionEndDate = &v
	return s
}

// SetSubscriptionStartDate sets the SubscriptionStartDate field's value.
func (s *ProductUserSummary) SetSubscriptionStartDate(v string) *ProductUserSummary {
	s.SubscriptionStartDate = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *ProductUserSummary) SetUsername(v string) *ProductUserSummary {
	s.Username = &v
	return s
}

type RegisterIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The name of the user-based subscription product.
	//
	// Product is a required field
	Product *string `type:"string" required:"true"`

	// The registered identity provider’s product related configuration settings
	// such as the subnets to provision VPC endpoints.
	Settings *Settings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterIdentityProviderInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.Product == nil {
		invalidParams.Add(request.NewErrParamRequired("Product"))
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *RegisterIdentityProviderInput) SetIdentityProvider(v *IdentityProvider) *RegisterIdentityProviderInput {
	s.IdentityProvider = v
	return s
}

// SetProduct sets the Product field's value.
func (s *RegisterIdentityProviderInput) SetProduct(v string) *RegisterIdentityProviderInput {
	s.Product = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *RegisterIdentityProviderInput) SetSettings(v *Settings) *RegisterIdentityProviderInput {
	s.Settings = v
	return s
}

type RegisterIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the results of an identity provider operation.
	//
	// IdentityProviderSummary is a required field
	IdentityProviderSummary *IdentityProviderSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderSummary sets the IdentityProviderSummary field's value.
func (s *RegisterIdentityProviderOutput) SetIdentityProviderSummary(v *IdentityProviderSummary) *RegisterIdentityProviderOutput {
	s.IdentityProviderSummary = v
	return s
}

// The resource couldn't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request failed because a service quota is exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The registered identity provider’s product related configuration settings
// such as the subnets to provision VPC endpoints, and the security group ID
// that is associated with the VPC endpoints. The security group should permit
// inbound TCP port 1688 communication from resources in the VPC.
type Settings struct {
	_ struct{} `type:"structure"`

	// A security group ID that allows inbound TCP port 1688 communication between
	// resources in your VPC and the VPC endpoint for activation servers.
	//
	// SecurityGroupId is a required field
	SecurityGroupId *string `min:"5" type:"string" required:"true"`

	// The subnets defined for the registered identity provider.
	//
	// Subnets is a required field
	Subnets []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Settings"}
	if s.SecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupId"))
	}
	if s.SecurityGroupId != nil && len(*s.SecurityGroupId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupId", 5))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *Settings) SetSecurityGroupId(v string) *Settings {
	s.SecurityGroupId = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *Settings) SetSubnets(v []*string) *Settings {
	s.Subnets = v
	return s
}

type StartProductSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The domain name of the user.
	Domain *string `type:"string"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The name of the user-based subscription product.
	//
	// Product is a required field
	Product *string `type:"string" required:"true"`

	// The user name from the identity provider of the user.
	//
	// Username is a required field
	Username *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProductSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProductSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartProductSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartProductSubscriptionInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.Product == nil {
		invalidParams.Add(request.NewErrParamRequired("Product"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *StartProductSubscriptionInput) SetDomain(v string) *StartProductSubscriptionInput {
	s.Domain = &v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *StartProductSubscriptionInput) SetIdentityProvider(v *IdentityProvider) *StartProductSubscriptionInput {
	s.IdentityProvider = v
	return s
}

// SetProduct sets the Product field's value.
func (s *StartProductSubscriptionInput) SetProduct(v string) *StartProductSubscriptionInput {
	s.Product = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *StartProductSubscriptionInput) SetUsername(v string) *StartProductSubscriptionInput {
	s.Username = &v
	return s
}

type StartProductSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the start product subscription operation.
	//
	// ProductUserSummary is a required field
	ProductUserSummary *ProductUserSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProductSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProductSubscriptionOutput) GoString() string {
	return s.String()
}

// SetProductUserSummary sets the ProductUserSummary field's value.
func (s *StartProductSubscriptionOutput) SetProductUserSummary(v *ProductUserSummary) *StartProductSubscriptionOutput {
	s.ProductUserSummary = v
	return s
}

type StopProductSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The domain name of the user.
	Domain *string `type:"string"`

	// An object that specifies details for the identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The name of the user-based subscription product.
	//
	// Product is a required field
	Product *string `type:"string" required:"true"`

	// The user name from the identity provider for the user.
	//
	// Username is a required field
	Username *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopProductSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopProductSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopProductSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopProductSubscriptionInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.Product == nil {
		invalidParams.Add(request.NewErrParamRequired("Product"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *StopProductSubscriptionInput) SetDomain(v string) *StopProductSubscriptionInput {
	s.Domain = &v
	return s
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *StopProductSubscriptionInput) SetIdentityProvider(v *IdentityProvider) *StopProductSubscriptionInput {
	s.IdentityProvider = v
	return s
}

// SetProduct sets the Product field's value.
func (s *StopProductSubscriptionInput) SetProduct(v string) *StopProductSubscriptionInput {
	s.Product = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *StopProductSubscriptionInput) SetUsername(v string) *StopProductSubscriptionInput {
	s.Username = &v
	return s
}

type StopProductSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Metadata that describes the start product subscription operation.
	//
	// ProductUserSummary is a required field
	ProductUserSummary *ProductUserSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopProductSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopProductSubscriptionOutput) GoString() string {
	return s.String()
}

// SetProductUserSummary sets the ProductUserSummary field's value.
func (s *StopProductSubscriptionOutput) SetProductUserSummary(v *ProductUserSummary) *StopProductSubscriptionOutput {
	s.ProductUserSummary = v
	return s
}

// The request was denied because of request throttling. Retry the request.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateIdentityProviderSettingsInput struct {
	_ struct{} `type:"structure"`

	// Details about an identity provider.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProvider `type:"structure" required:"true"`

	// The name of the user-based subscription product.
	//
	// Product is a required field
	Product *string `type:"string" required:"true"`

	// Updates the registered identity provider’s product related configuration
	// settings. You can update any combination of settings in a single operation
	// such as the:
	//
	//    * Subnets which you want to add to provision VPC endpoints.
	//
	//    * Subnets which you want to remove the VPC endpoints from.
	//
	//    * Security group ID which permits traffic to the VPC endpoints.
	//
	// UpdateSettings is a required field
	UpdateSettings *UpdateSettings `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentityProviderSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentityProviderSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdentityProviderSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIdentityProviderSettingsInput"}
	if s.IdentityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProvider"))
	}
	if s.Product == nil {
		invalidParams.Add(request.NewErrParamRequired("Product"))
	}
	if s.UpdateSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateSettings"))
	}
	if s.UpdateSettings != nil {
		if err := s.UpdateSettings.Validate(); err != nil {
			invalidParams.AddNested("UpdateSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityProvider sets the IdentityProvider field's value.
func (s *UpdateIdentityProviderSettingsInput) SetIdentityProvider(v *IdentityProvider) *UpdateIdentityProviderSettingsInput {
	s.IdentityProvider = v
	return s
}

// SetProduct sets the Product field's value.
func (s *UpdateIdentityProviderSettingsInput) SetProduct(v string) *UpdateIdentityProviderSettingsInput {
	s.Product = &v
	return s
}

// SetUpdateSettings sets the UpdateSettings field's value.
func (s *UpdateIdentityProviderSettingsInput) SetUpdateSettings(v *UpdateSettings) *UpdateIdentityProviderSettingsInput {
	s.UpdateSettings = v
	return s
}

type UpdateIdentityProviderSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Describes an identity provider.
	//
	// IdentityProviderSummary is a required field
	IdentityProviderSummary *IdentityProviderSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentityProviderSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdentityProviderSettingsOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderSummary sets the IdentityProviderSummary field's value.
func (s *UpdateIdentityProviderSettingsOutput) SetIdentityProviderSummary(v *IdentityProviderSummary) *UpdateIdentityProviderSettingsOutput {
	s.IdentityProviderSummary = v
	return s
}

// Updates the registered identity provider’s product related configuration
// settings such as the subnets to provision VPC endpoints.
type UpdateSettings struct {
	_ struct{} `type:"structure"`

	// The ID of one or more subnets in which License Manager will create a VPC
	// endpoint for products that require connectivity to activation servers.
	//
	// AddSubnets is a required field
	AddSubnets []*string `type:"list" required:"true"`

	// The ID of one or more subnets to remove.
	//
	// RemoveSubnets is a required field
	RemoveSubnets []*string `type:"list" required:"true"`

	// A security group ID that allows inbound TCP port 1688 communication between
	// resources in your VPC and the VPC endpoints for activation servers.
	SecurityGroupId *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSettings"}
	if s.AddSubnets == nil {
		invalidParams.Add(request.NewErrParamRequired("AddSubnets"))
	}
	if s.RemoveSubnets == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoveSubnets"))
	}
	if s.SecurityGroupId != nil && len(*s.SecurityGroupId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddSubnets sets the AddSubnets field's value.
func (s *UpdateSettings) SetAddSubnets(v []*string) *UpdateSettings {
	s.AddSubnets = v
	return s
}

// SetRemoveSubnets sets the RemoveSubnets field's value.
func (s *UpdateSettings) SetRemoveSubnets(v []*string) *UpdateSettings {
	s.RemoveSubnets = v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *UpdateSettings) SetSecurityGroupId(v string) *UpdateSettings {
	s.SecurityGroupId = &v
	return s
}

// A parameter is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}
