// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package m2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelBatchJobExecution = "CancelBatchJobExecution"

// CancelBatchJobExecutionRequest generates a "aws/request.Request" representing the
// client's request for the CancelBatchJobExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelBatchJobExecution for more information on using the CancelBatchJobExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelBatchJobExecutionRequest method.
//	req, resp := client.CancelBatchJobExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CancelBatchJobExecution
func (c *M2) CancelBatchJobExecutionRequest(input *CancelBatchJobExecutionInput) (req *request.Request, output *CancelBatchJobExecutionOutput) {
	op := &request.Operation{
		Name:       opCancelBatchJobExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/batch-job-executions/{executionId}/cancel",
	}

	if input == nil {
		input = &CancelBatchJobExecutionInput{}
	}

	output = &CancelBatchJobExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelBatchJobExecution API operation for AWSMainframeModernization.
//
// Cancels the running of a specific batch job execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation CancelBatchJobExecution for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CancelBatchJobExecution
func (c *M2) CancelBatchJobExecution(input *CancelBatchJobExecutionInput) (*CancelBatchJobExecutionOutput, error) {
	req, out := c.CancelBatchJobExecutionRequest(input)
	return out, req.Send()
}

// CancelBatchJobExecutionWithContext is the same as CancelBatchJobExecution with the addition of
// the ability to pass a context and additional request options.
//
// See CancelBatchJobExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) CancelBatchJobExecutionWithContext(ctx aws.Context, input *CancelBatchJobExecutionInput, opts ...request.Option) (*CancelBatchJobExecutionOutput, error) {
	req, out := c.CancelBatchJobExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateApplicationRequest method.
//	req, resp := client.CreateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateApplication
func (c *M2) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWSMainframeModernization.
//
// Creates a new application with given parameters. Requires an existing environment
// and application definition file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ServiceQuotaExceededException
//     One or more quotas for Amazon Web Services Mainframe Modernization exceeds
//     the limit.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateApplication
func (c *M2) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSetImportTask = "CreateDataSetImportTask"

// CreateDataSetImportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSetImportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSetImportTask for more information on using the CreateDataSetImportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataSetImportTaskRequest method.
//	req, resp := client.CreateDataSetImportTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateDataSetImportTask
func (c *M2) CreateDataSetImportTaskRequest(input *CreateDataSetImportTaskInput) (req *request.Request, output *CreateDataSetImportTaskOutput) {
	op := &request.Operation{
		Name:       opCreateDataSetImportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/dataset-import-task",
	}

	if input == nil {
		input = &CreateDataSetImportTaskInput{}
	}

	output = &CreateDataSetImportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSetImportTask API operation for AWSMainframeModernization.
//
// Starts a data set import task for a specific application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation CreateDataSetImportTask for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ServiceQuotaExceededException
//     One or more quotas for Amazon Web Services Mainframe Modernization exceeds
//     the limit.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateDataSetImportTask
func (c *M2) CreateDataSetImportTask(input *CreateDataSetImportTaskInput) (*CreateDataSetImportTaskOutput, error) {
	req, out := c.CreateDataSetImportTaskRequest(input)
	return out, req.Send()
}

// CreateDataSetImportTaskWithContext is the same as CreateDataSetImportTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSetImportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) CreateDataSetImportTaskWithContext(ctx aws.Context, input *CreateDataSetImportTaskInput, opts ...request.Option) (*CreateDataSetImportTaskOutput, error) {
	req, out := c.CreateDataSetImportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDeploymentRequest method.
//	req, resp := client.CreateDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateDeployment
func (c *M2) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/deployments",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for AWSMainframeModernization.
//
// Creates and starts a deployment to deploy an application into an environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ServiceQuotaExceededException
//     One or more quotas for Amazon Web Services Mainframe Modernization exceeds
//     the limit.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateDeployment
func (c *M2) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentRequest method.
//	req, resp := client.CreateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateEnvironment
func (c *M2) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *CreateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/environments",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &CreateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironment API operation for AWSMainframeModernization.
//
// Creates a runtime environment for a given runtime engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ServiceQuotaExceededException
//     One or more quotas for Amazon Web Services Mainframe Modernization exceeds
//     the limit.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateEnvironment
func (c *M2) CreateEnvironment(input *CreateEnvironmentInput) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationRequest method.
//	req, resp := client.DeleteApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteApplication
func (c *M2) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for AWSMainframeModernization.
//
// Deletes a specific application. You cannot delete a running application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteApplication
func (c *M2) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationFromEnvironment = "DeleteApplicationFromEnvironment"

// DeleteApplicationFromEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationFromEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationFromEnvironment for more information on using the DeleteApplicationFromEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationFromEnvironmentRequest method.
//	req, resp := client.DeleteApplicationFromEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteApplicationFromEnvironment
func (c *M2) DeleteApplicationFromEnvironmentRequest(input *DeleteApplicationFromEnvironmentInput) (req *request.Request, output *DeleteApplicationFromEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationFromEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/environment/{environmentId}",
	}

	if input == nil {
		input = &DeleteApplicationFromEnvironmentInput{}
	}

	output = &DeleteApplicationFromEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationFromEnvironment API operation for AWSMainframeModernization.
//
// Deletes a specific application from a specified environment where it has
// been previously deployed. You cannot delete an environment using DeleteEnvironment,
// if any application has ever been deployed to it. This API removes the association
// of the application with the environment so you can delete the environment
// smoothly.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation DeleteApplicationFromEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteApplicationFromEnvironment
func (c *M2) DeleteApplicationFromEnvironment(input *DeleteApplicationFromEnvironmentInput) (*DeleteApplicationFromEnvironmentOutput, error) {
	req, out := c.DeleteApplicationFromEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteApplicationFromEnvironmentWithContext is the same as DeleteApplicationFromEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationFromEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) DeleteApplicationFromEnvironmentWithContext(ctx aws.Context, input *DeleteApplicationFromEnvironmentInput, opts ...request.Option) (*DeleteApplicationFromEnvironmentOutput, error) {
	req, out := c.DeleteApplicationFromEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentRequest method.
//	req, resp := client.DeleteEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteEnvironment
func (c *M2) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/environments/{environmentId}",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEnvironment API operation for AWSMainframeModernization.
//
// Deletes a specific environment. The environment cannot contain deployed applications.
// If it does, you must delete those applications before you delete the environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteEnvironment
func (c *M2) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationRequest method.
//	req, resp := client.GetApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetApplication
func (c *M2) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for AWSMainframeModernization.
//
// Describes the details of a specific application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation GetApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetApplication
func (c *M2) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationVersion = "GetApplicationVersion"

// GetApplicationVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationVersion for more information on using the GetApplicationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationVersionRequest method.
//	req, resp := client.GetApplicationVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetApplicationVersion
func (c *M2) GetApplicationVersionRequest(input *GetApplicationVersionInput) (req *request.Request, output *GetApplicationVersionOutput) {
	op := &request.Operation{
		Name:       opGetApplicationVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/versions/{applicationVersion}",
	}

	if input == nil {
		input = &GetApplicationVersionInput{}
	}

	output = &GetApplicationVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationVersion API operation for AWSMainframeModernization.
//
// Returns details about a specific version of a specific application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation GetApplicationVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetApplicationVersion
func (c *M2) GetApplicationVersion(input *GetApplicationVersionInput) (*GetApplicationVersionOutput, error) {
	req, out := c.GetApplicationVersionRequest(input)
	return out, req.Send()
}

// GetApplicationVersionWithContext is the same as GetApplicationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) GetApplicationVersionWithContext(ctx aws.Context, input *GetApplicationVersionInput, opts ...request.Option) (*GetApplicationVersionOutput, error) {
	req, out := c.GetApplicationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBatchJobExecution = "GetBatchJobExecution"

// GetBatchJobExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetBatchJobExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBatchJobExecution for more information on using the GetBatchJobExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBatchJobExecutionRequest method.
//	req, resp := client.GetBatchJobExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetBatchJobExecution
func (c *M2) GetBatchJobExecutionRequest(input *GetBatchJobExecutionInput) (req *request.Request, output *GetBatchJobExecutionOutput) {
	op := &request.Operation{
		Name:       opGetBatchJobExecution,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/batch-job-executions/{executionId}",
	}

	if input == nil {
		input = &GetBatchJobExecutionInput{}
	}

	output = &GetBatchJobExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBatchJobExecution API operation for AWSMainframeModernization.
//
// Gets the details of a specific batch job execution for a specific application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation GetBatchJobExecution for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetBatchJobExecution
func (c *M2) GetBatchJobExecution(input *GetBatchJobExecutionInput) (*GetBatchJobExecutionOutput, error) {
	req, out := c.GetBatchJobExecutionRequest(input)
	return out, req.Send()
}

// GetBatchJobExecutionWithContext is the same as GetBatchJobExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetBatchJobExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) GetBatchJobExecutionWithContext(ctx aws.Context, input *GetBatchJobExecutionInput, opts ...request.Option) (*GetBatchJobExecutionOutput, error) {
	req, out := c.GetBatchJobExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSetDetails = "GetDataSetDetails"

// GetDataSetDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSetDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSetDetails for more information on using the GetDataSetDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataSetDetailsRequest method.
//	req, resp := client.GetDataSetDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDataSetDetails
func (c *M2) GetDataSetDetailsRequest(input *GetDataSetDetailsInput) (req *request.Request, output *GetDataSetDetailsOutput) {
	op := &request.Operation{
		Name:       opGetDataSetDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/datasets/{dataSetName}",
	}

	if input == nil {
		input = &GetDataSetDetailsInput{}
	}

	output = &GetDataSetDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSetDetails API operation for AWSMainframeModernization.
//
// Gets the details of a specific data set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation GetDataSetDetails for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDataSetDetails
func (c *M2) GetDataSetDetails(input *GetDataSetDetailsInput) (*GetDataSetDetailsOutput, error) {
	req, out := c.GetDataSetDetailsRequest(input)
	return out, req.Send()
}

// GetDataSetDetailsWithContext is the same as GetDataSetDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSetDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) GetDataSetDetailsWithContext(ctx aws.Context, input *GetDataSetDetailsInput, opts ...request.Option) (*GetDataSetDetailsOutput, error) {
	req, out := c.GetDataSetDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSetImportTask = "GetDataSetImportTask"

// GetDataSetImportTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSetImportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSetImportTask for more information on using the GetDataSetImportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataSetImportTaskRequest method.
//	req, resp := client.GetDataSetImportTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDataSetImportTask
func (c *M2) GetDataSetImportTaskRequest(input *GetDataSetImportTaskInput) (req *request.Request, output *GetDataSetImportTaskOutput) {
	op := &request.Operation{
		Name:       opGetDataSetImportTask,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/dataset-import-tasks/{taskId}",
	}

	if input == nil {
		input = &GetDataSetImportTaskInput{}
	}

	output = &GetDataSetImportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSetImportTask API operation for AWSMainframeModernization.
//
// Gets the status of a data set import task initiated with the CreateDataSetImportTask
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation GetDataSetImportTask for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDataSetImportTask
func (c *M2) GetDataSetImportTask(input *GetDataSetImportTaskInput) (*GetDataSetImportTaskOutput, error) {
	req, out := c.GetDataSetImportTaskRequest(input)
	return out, req.Send()
}

// GetDataSetImportTaskWithContext is the same as GetDataSetImportTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSetImportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) GetDataSetImportTaskWithContext(ctx aws.Context, input *GetDataSetImportTaskInput, opts ...request.Option) (*GetDataSetImportTaskOutput, error) {
	req, out := c.GetDataSetImportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeploymentRequest method.
//	req, resp := client.GetDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDeployment
func (c *M2) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/deployments/{deploymentId}",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &GetDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployment API operation for AWSMainframeModernization.
//
// Gets details of a specific deployment with a given deployment identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation GetDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDeployment
func (c *M2) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) GetDeploymentWithContext(ctx aws.Context, input *GetDeploymentInput, opts ...request.Option) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironment = "GetEnvironment"

// GetEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironment for more information on using the GetEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentRequest method.
//	req, resp := client.GetEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetEnvironment
func (c *M2) GetEnvironmentRequest(input *GetEnvironmentInput) (req *request.Request, output *GetEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{environmentId}",
	}

	if input == nil {
		input = &GetEnvironmentInput{}
	}

	output = &GetEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironment API operation for AWSMainframeModernization.
//
// Describes a specific runtime environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation GetEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetEnvironment
func (c *M2) GetEnvironment(input *GetEnvironmentInput) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	return out, req.Send()
}

// GetEnvironmentWithContext is the same as GetEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) GetEnvironmentWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.Option) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplicationVersions = "ListApplicationVersions"

// ListApplicationVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationVersions for more information on using the ListApplicationVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationVersionsRequest method.
//	req, resp := client.ListApplicationVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplicationVersions
func (c *M2) ListApplicationVersionsRequest(input *ListApplicationVersionsInput) (req *request.Request, output *ListApplicationVersionsOutput) {
	op := &request.Operation{
		Name:       opListApplicationVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationVersionsInput{}
	}

	output = &ListApplicationVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationVersions API operation for AWSMainframeModernization.
//
// Returns a list of the application versions for a specific application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListApplicationVersions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplicationVersions
func (c *M2) ListApplicationVersions(input *ListApplicationVersionsInput) (*ListApplicationVersionsOutput, error) {
	req, out := c.ListApplicationVersionsRequest(input)
	return out, req.Send()
}

// ListApplicationVersionsWithContext is the same as ListApplicationVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListApplicationVersionsWithContext(ctx aws.Context, input *ListApplicationVersionsInput, opts ...request.Option) (*ListApplicationVersionsOutput, error) {
	req, out := c.ListApplicationVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationVersionsPages iterates over the pages of a ListApplicationVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplicationVersions operation.
//	pageNum := 0
//	err := client.ListApplicationVersionsPages(params,
//	    func(page *m2.ListApplicationVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListApplicationVersionsPages(input *ListApplicationVersionsInput, fn func(*ListApplicationVersionsOutput, bool) bool) error {
	return c.ListApplicationVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationVersionsPagesWithContext same as ListApplicationVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListApplicationVersionsPagesWithContext(ctx aws.Context, input *ListApplicationVersionsInput, fn func(*ListApplicationVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationsRequest method.
//	req, resp := client.ListApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplications
func (c *M2) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for AWSMainframeModernization.
//
// Lists the applications associated with a specific Amazon Web Services account.
// You can provide the unique identifier of a specific environment in a query
// parameter to see all applications associated with that environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplications
func (c *M2) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplications operation.
//	pageNum := 0
//	err := client.ListApplicationsPages(params,
//	    func(page *m2.ListApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBatchJobDefinitions = "ListBatchJobDefinitions"

// ListBatchJobDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListBatchJobDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBatchJobDefinitions for more information on using the ListBatchJobDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBatchJobDefinitionsRequest method.
//	req, resp := client.ListBatchJobDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobDefinitions
func (c *M2) ListBatchJobDefinitionsRequest(input *ListBatchJobDefinitionsInput) (req *request.Request, output *ListBatchJobDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListBatchJobDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/batch-job-definitions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBatchJobDefinitionsInput{}
	}

	output = &ListBatchJobDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBatchJobDefinitions API operation for AWSMainframeModernization.
//
// Lists all the available batch job definitions based on the batch job resources
// uploaded during the application creation. The listed batch job definitions
// can then be used to start a batch job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListBatchJobDefinitions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobDefinitions
func (c *M2) ListBatchJobDefinitions(input *ListBatchJobDefinitionsInput) (*ListBatchJobDefinitionsOutput, error) {
	req, out := c.ListBatchJobDefinitionsRequest(input)
	return out, req.Send()
}

// ListBatchJobDefinitionsWithContext is the same as ListBatchJobDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListBatchJobDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListBatchJobDefinitionsWithContext(ctx aws.Context, input *ListBatchJobDefinitionsInput, opts ...request.Option) (*ListBatchJobDefinitionsOutput, error) {
	req, out := c.ListBatchJobDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBatchJobDefinitionsPages iterates over the pages of a ListBatchJobDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBatchJobDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBatchJobDefinitions operation.
//	pageNum := 0
//	err := client.ListBatchJobDefinitionsPages(params,
//	    func(page *m2.ListBatchJobDefinitionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListBatchJobDefinitionsPages(input *ListBatchJobDefinitionsInput, fn func(*ListBatchJobDefinitionsOutput, bool) bool) error {
	return c.ListBatchJobDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBatchJobDefinitionsPagesWithContext same as ListBatchJobDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListBatchJobDefinitionsPagesWithContext(ctx aws.Context, input *ListBatchJobDefinitionsInput, fn func(*ListBatchJobDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBatchJobDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBatchJobDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBatchJobDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBatchJobExecutions = "ListBatchJobExecutions"

// ListBatchJobExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListBatchJobExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBatchJobExecutions for more information on using the ListBatchJobExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBatchJobExecutionsRequest method.
//	req, resp := client.ListBatchJobExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobExecutions
func (c *M2) ListBatchJobExecutionsRequest(input *ListBatchJobExecutionsInput) (req *request.Request, output *ListBatchJobExecutionsOutput) {
	op := &request.Operation{
		Name:       opListBatchJobExecutions,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/batch-job-executions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBatchJobExecutionsInput{}
	}

	output = &ListBatchJobExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBatchJobExecutions API operation for AWSMainframeModernization.
//
// Lists historical, current, and scheduled batch job executions for a specific
// application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListBatchJobExecutions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobExecutions
func (c *M2) ListBatchJobExecutions(input *ListBatchJobExecutionsInput) (*ListBatchJobExecutionsOutput, error) {
	req, out := c.ListBatchJobExecutionsRequest(input)
	return out, req.Send()
}

// ListBatchJobExecutionsWithContext is the same as ListBatchJobExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListBatchJobExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListBatchJobExecutionsWithContext(ctx aws.Context, input *ListBatchJobExecutionsInput, opts ...request.Option) (*ListBatchJobExecutionsOutput, error) {
	req, out := c.ListBatchJobExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBatchJobExecutionsPages iterates over the pages of a ListBatchJobExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBatchJobExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBatchJobExecutions operation.
//	pageNum := 0
//	err := client.ListBatchJobExecutionsPages(params,
//	    func(page *m2.ListBatchJobExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListBatchJobExecutionsPages(input *ListBatchJobExecutionsInput, fn func(*ListBatchJobExecutionsOutput, bool) bool) error {
	return c.ListBatchJobExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBatchJobExecutionsPagesWithContext same as ListBatchJobExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListBatchJobExecutionsPagesWithContext(ctx aws.Context, input *ListBatchJobExecutionsInput, fn func(*ListBatchJobExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBatchJobExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBatchJobExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBatchJobExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSetImportHistory = "ListDataSetImportHistory"

// ListDataSetImportHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSetImportHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSetImportHistory for more information on using the ListDataSetImportHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSetImportHistoryRequest method.
//	req, resp := client.ListDataSetImportHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSetImportHistory
func (c *M2) ListDataSetImportHistoryRequest(input *ListDataSetImportHistoryInput) (req *request.Request, output *ListDataSetImportHistoryOutput) {
	op := &request.Operation{
		Name:       opListDataSetImportHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/dataset-import-tasks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetImportHistoryInput{}
	}

	output = &ListDataSetImportHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSetImportHistory API operation for AWSMainframeModernization.
//
// Lists the data set imports for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListDataSetImportHistory for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSetImportHistory
func (c *M2) ListDataSetImportHistory(input *ListDataSetImportHistoryInput) (*ListDataSetImportHistoryOutput, error) {
	req, out := c.ListDataSetImportHistoryRequest(input)
	return out, req.Send()
}

// ListDataSetImportHistoryWithContext is the same as ListDataSetImportHistory with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSetImportHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListDataSetImportHistoryWithContext(ctx aws.Context, input *ListDataSetImportHistoryInput, opts ...request.Option) (*ListDataSetImportHistoryOutput, error) {
	req, out := c.ListDataSetImportHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSetImportHistoryPages iterates over the pages of a ListDataSetImportHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSetImportHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSetImportHistory operation.
//	pageNum := 0
//	err := client.ListDataSetImportHistoryPages(params,
//	    func(page *m2.ListDataSetImportHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListDataSetImportHistoryPages(input *ListDataSetImportHistoryInput, fn func(*ListDataSetImportHistoryOutput, bool) bool) error {
	return c.ListDataSetImportHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSetImportHistoryPagesWithContext same as ListDataSetImportHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListDataSetImportHistoryPagesWithContext(ctx aws.Context, input *ListDataSetImportHistoryInput, fn func(*ListDataSetImportHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSetImportHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSetImportHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSetImportHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSets = "ListDataSets"

// ListDataSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSets for more information on using the ListDataSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSetsRequest method.
//	req, resp := client.ListDataSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSets
func (c *M2) ListDataSetsRequest(input *ListDataSetsInput) (req *request.Request, output *ListDataSetsOutput) {
	op := &request.Operation{
		Name:       opListDataSets,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/datasets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetsInput{}
	}

	output = &ListDataSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSets API operation for AWSMainframeModernization.
//
// Lists the data sets imported for a specific application. In Amazon Web Services
// Mainframe Modernization, data sets are associated with applications deployed
// on environments. This is known as importing data sets. Currently, Amazon
// Web Services Mainframe Modernization can import data sets into catalogs using
// CreateDataSetImportTask (https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListDataSets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSets
func (c *M2) ListDataSets(input *ListDataSetsInput) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	return out, req.Send()
}

// ListDataSetsWithContext is the same as ListDataSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListDataSetsWithContext(ctx aws.Context, input *ListDataSetsInput, opts ...request.Option) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSetsPages iterates over the pages of a ListDataSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSets operation.
//	pageNum := 0
//	err := client.ListDataSetsPages(params,
//	    func(page *m2.ListDataSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListDataSetsPages(input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool) error {
	return c.ListDataSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSetsPagesWithContext same as ListDataSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListDataSetsPagesWithContext(ctx aws.Context, input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeployments for more information on using the ListDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeploymentsRequest method.
//	req, resp := client.ListDeploymentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDeployments
func (c *M2) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/deployments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	output = &ListDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeployments API operation for AWSMainframeModernization.
//
// Returns a list of all deployments of a specific application. A deployment
// is a combination of a specific application and a specific version of that
// application. Each deployment is mapped to a particular application version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListDeployments for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDeployments
func (c *M2) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	return out, req.Send()
}

// ListDeploymentsWithContext is the same as ListDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListDeploymentsWithContext(ctx aws.Context, input *ListDeploymentsInput, opts ...request.Option) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentsPages iterates over the pages of a ListDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDeployments operation.
//	pageNum := 0
//	err := client.ListDeploymentsPages(params,
//	    func(page *m2.ListDeploymentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListDeploymentsPages(input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool) error {
	return c.ListDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentsPagesWithContext same as ListDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListDeploymentsPagesWithContext(ctx aws.Context, input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeploymentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEngineVersions = "ListEngineVersions"

// ListEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEngineVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEngineVersions for more information on using the ListEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEngineVersionsRequest method.
//	req, resp := client.ListEngineVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEngineVersions
func (c *M2) ListEngineVersionsRequest(input *ListEngineVersionsInput) (req *request.Request, output *ListEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opListEngineVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/engine-versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEngineVersionsInput{}
	}

	output = &ListEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEngineVersions API operation for AWSMainframeModernization.
//
// Lists the available engine versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListEngineVersions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEngineVersions
func (c *M2) ListEngineVersions(input *ListEngineVersionsInput) (*ListEngineVersionsOutput, error) {
	req, out := c.ListEngineVersionsRequest(input)
	return out, req.Send()
}

// ListEngineVersionsWithContext is the same as ListEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListEngineVersionsWithContext(ctx aws.Context, input *ListEngineVersionsInput, opts ...request.Option) (*ListEngineVersionsOutput, error) {
	req, out := c.ListEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEngineVersionsPages iterates over the pages of a ListEngineVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEngineVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEngineVersions operation.
//	pageNum := 0
//	err := client.ListEngineVersionsPages(params,
//	    func(page *m2.ListEngineVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListEngineVersionsPages(input *ListEngineVersionsInput, fn func(*ListEngineVersionsOutput, bool) bool) error {
	return c.ListEngineVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEngineVersionsPagesWithContext same as ListEngineVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListEngineVersionsPagesWithContext(ctx aws.Context, input *ListEngineVersionsInput, fn func(*ListEngineVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEngineVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEngineVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEngineVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentsRequest method.
//	req, resp := client.ListEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEnvironments
func (c *M2) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/environments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironments API operation for AWSMainframeModernization.
//
// Lists the runtime environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEnvironments
func (c *M2) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentsPages iterates over the pages of a ListEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironments operation.
//	pageNum := 0
//	err := client.ListEnvironmentsPages(params,
//	    func(page *m2.ListEnvironmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *M2) ListEnvironmentsPages(input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool) error {
	return c.ListEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentsPagesWithContext same as ListEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListEnvironmentsPagesWithContext(ctx aws.Context, input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListTagsForResource
func (c *M2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWSMainframeModernization.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListTagsForResource
func (c *M2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartApplication = "StartApplication"

// StartApplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartApplication for more information on using the StartApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartApplicationRequest method.
//	req, resp := client.StartApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StartApplication
func (c *M2) StartApplicationRequest(input *StartApplicationInput) (req *request.Request, output *StartApplicationOutput) {
	op := &request.Operation{
		Name:       opStartApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/start",
	}

	if input == nil {
		input = &StartApplicationInput{}
	}

	output = &StartApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartApplication API operation for AWSMainframeModernization.
//
// Starts an application that is currently stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation StartApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StartApplication
func (c *M2) StartApplication(input *StartApplicationInput) (*StartApplicationOutput, error) {
	req, out := c.StartApplicationRequest(input)
	return out, req.Send()
}

// StartApplicationWithContext is the same as StartApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) StartApplicationWithContext(ctx aws.Context, input *StartApplicationInput, opts ...request.Option) (*StartApplicationOutput, error) {
	req, out := c.StartApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartBatchJob = "StartBatchJob"

// StartBatchJobRequest generates a "aws/request.Request" representing the
// client's request for the StartBatchJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartBatchJob for more information on using the StartBatchJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartBatchJobRequest method.
//	req, resp := client.StartBatchJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StartBatchJob
func (c *M2) StartBatchJobRequest(input *StartBatchJobInput) (req *request.Request, output *StartBatchJobOutput) {
	op := &request.Operation{
		Name:       opStartBatchJob,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/batch-job",
	}

	if input == nil {
		input = &StartBatchJobInput{}
	}

	output = &StartBatchJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBatchJob API operation for AWSMainframeModernization.
//
// Starts a batch job and returns the unique identifier of this execution of
// the batch job. The associated application must be running in order to start
// the batch job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation StartBatchJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StartBatchJob
func (c *M2) StartBatchJob(input *StartBatchJobInput) (*StartBatchJobOutput, error) {
	req, out := c.StartBatchJobRequest(input)
	return out, req.Send()
}

// StartBatchJobWithContext is the same as StartBatchJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartBatchJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) StartBatchJobWithContext(ctx aws.Context, input *StartBatchJobInput, opts ...request.Option) (*StartBatchJobOutput, error) {
	req, out := c.StartBatchJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopApplication = "StopApplication"

// StopApplicationRequest generates a "aws/request.Request" representing the
// client's request for the StopApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopApplication for more information on using the StopApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopApplicationRequest method.
//	req, resp := client.StopApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StopApplication
func (c *M2) StopApplicationRequest(input *StopApplicationInput) (req *request.Request, output *StopApplicationOutput) {
	op := &request.Operation{
		Name:       opStopApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/stop",
	}

	if input == nil {
		input = &StopApplicationInput{}
	}

	output = &StopApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopApplication API operation for AWSMainframeModernization.
//
// Stops a running application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation StopApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StopApplication
func (c *M2) StopApplication(input *StopApplicationInput) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	return out, req.Send()
}

// StopApplicationWithContext is the same as StopApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) StopApplicationWithContext(ctx aws.Context, input *StopApplicationInput, opts ...request.Option) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/TagResource
func (c *M2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWSMainframeModernization.
//
// Adds one or more tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ServiceQuotaExceededException
//     One or more quotas for Amazon Web Services Mainframe Modernization exceeds
//     the limit.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/TagResource
func (c *M2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UntagResource
func (c *M2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWSMainframeModernization.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UntagResource
func (c *M2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApplicationRequest method.
//	req, resp := client.UpdateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UpdateApplication
func (c *M2) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for AWSMainframeModernization.
//
// Updates an application and creates a new version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UpdateApplication
func (c *M2) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentRequest method.
//	req, resp := client.UpdateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UpdateEnvironment
func (c *M2) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *UpdateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/environments/{environmentId}",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &UpdateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironment API operation for AWSMainframeModernization.
//
// Updates the configuration details for a specific environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSMainframeModernization's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more parameters provided in the request is not valid.
//
//   - ServiceQuotaExceededException
//     One or more quotas for Amazon Web Services Mainframe Modernization exceeds
//     the limit.
//
//   - ConflictException
//     The parameters provided in the request conflict with existing resources.
//
//   - InternalServerException
//     An unexpected error occurred during the processing of the request.
//
//   - AccessDeniedException
//     The account or role doesn't have the right permissions to make the request.
//
//   - ThrottlingException
//     The number of requests made exceeds the limit.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UpdateEnvironment
func (c *M2) UpdateEnvironment(input *UpdateEnvironmentInput) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *M2) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The account or role doesn't have the right permissions to make the request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines an alternate key. This value is optional. A legacy data set might
// not have any alternate key defined but if those alternate keys definitions
// exist, provide them, as some applications will make use of them.
type AlternateKey struct {
	_ struct{} `type:"structure"`

	// Indicates whether the alternate key values are supposed to be unique for
	// the given data set.
	AllowDuplicates *bool `locationName:"allowDuplicates" type:"boolean"`

	// A strictly positive integer value representing the length of the alternate
	// key.
	//
	// Length is a required field
	Length *int64 `locationName:"length" type:"integer" required:"true"`

	// The name of the alternate key.
	Name *string `locationName:"name" type:"string"`

	// A positive integer value representing the offset to mark the start of the
	// alternate key part in the record byte array.
	//
	// Offset is a required field
	Offset *int64 `locationName:"offset" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlternateKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlternateKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlternateKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlternateKey"}
	if s.Length == nil {
		invalidParams.Add(request.NewErrParamRequired("Length"))
	}
	if s.Offset == nil {
		invalidParams.Add(request.NewErrParamRequired("Offset"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowDuplicates sets the AllowDuplicates field's value.
func (s *AlternateKey) SetAllowDuplicates(v bool) *AlternateKey {
	s.AllowDuplicates = &v
	return s
}

// SetLength sets the Length field's value.
func (s *AlternateKey) SetLength(v int64) *AlternateKey {
	s.Length = &v
	return s
}

// SetName sets the Name field's value.
func (s *AlternateKey) SetName(v string) *AlternateKey {
	s.Name = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *AlternateKey) SetOffset(v int64) *AlternateKey {
	s.Offset = &v
	return s
}

// A subset of the possible application attributes. Used in the application
// list.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `locationName:"applicationArn" type:"string" required:"true"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The version of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`

	// The timestamp when the application was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// Indicates whether there is an ongoing deployment or if the application has
	// ever deployed successfully.
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" enum:"ApplicationDeploymentLifecycle"`

	// The description of the application.
	Description *string `locationName:"description" type:"string"`

	// The type of the target platform for this application.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// The unique identifier of the runtime environment that hosts this application.
	EnvironmentId *string `locationName:"environmentId" type:"string"`

	// The timestamp when the application was last started. Null until the application
	// has started running for the first time.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp"`

	// The name of the application.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the application.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ApplicationLifecycle"`

	// Indicates the status of the latest version of the application.
	VersionStatus *string `locationName:"versionStatus" type:"string" enum:"ApplicationVersionLifecycle"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ApplicationSummary) SetApplicationArn(v string) *ApplicationSummary {
	s.ApplicationArn = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationSummary) SetApplicationId(v string) *ApplicationSummary {
	s.ApplicationId = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *ApplicationSummary) SetApplicationVersion(v int64) *ApplicationSummary {
	s.ApplicationVersion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ApplicationSummary) SetCreationTime(v time.Time) *ApplicationSummary {
	s.CreationTime = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *ApplicationSummary) SetDeploymentStatus(v string) *ApplicationSummary {
	s.DeploymentStatus = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ApplicationSummary) SetDescription(v string) *ApplicationSummary {
	s.Description = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *ApplicationSummary) SetEngineType(v string) *ApplicationSummary {
	s.EngineType = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ApplicationSummary) SetEnvironmentId(v string) *ApplicationSummary {
	s.EnvironmentId = &v
	return s
}

// SetLastStartTime sets the LastStartTime field's value.
func (s *ApplicationSummary) SetLastStartTime(v time.Time) *ApplicationSummary {
	s.LastStartTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationSummary) SetName(v string) *ApplicationSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ApplicationSummary) SetStatus(v string) *ApplicationSummary {
	s.Status = &v
	return s
}

// SetVersionStatus sets the VersionStatus field's value.
func (s *ApplicationSummary) SetVersionStatus(v string) *ApplicationSummary {
	s.VersionStatus = &v
	return s
}

// Defines an application version summary.
type ApplicationVersionSummary struct {
	_ struct{} `type:"structure"`

	// The application version.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`

	// The timestamp when the application version was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The status of the application.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ApplicationVersionLifecycle"`

	// The reason for the reported status.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationVersionSummary) GoString() string {
	return s.String()
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *ApplicationVersionSummary) SetApplicationVersion(v int64) *ApplicationVersionSummary {
	s.ApplicationVersion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ApplicationVersionSummary) SetCreationTime(v time.Time) *ApplicationVersionSummary {
	s.CreationTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ApplicationVersionSummary) SetStatus(v string) *ApplicationVersionSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ApplicationVersionSummary) SetStatusReason(v string) *ApplicationVersionSummary {
	s.StatusReason = &v
	return s
}

// Defines the details of a batch job.
type BatchJobDefinition struct {
	_ struct{} `type:"structure"`

	// Specifies a file containing a batch job definition.
	FileBatchJobDefinition *FileBatchJobDefinition `locationName:"fileBatchJobDefinition" type:"structure"`

	// A script containing a batch job definition.
	ScriptBatchJobDefinition *ScriptBatchJobDefinition `locationName:"scriptBatchJobDefinition" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchJobDefinition) GoString() string {
	return s.String()
}

// SetFileBatchJobDefinition sets the FileBatchJobDefinition field's value.
func (s *BatchJobDefinition) SetFileBatchJobDefinition(v *FileBatchJobDefinition) *BatchJobDefinition {
	s.FileBatchJobDefinition = v
	return s
}

// SetScriptBatchJobDefinition sets the ScriptBatchJobDefinition field's value.
func (s *BatchJobDefinition) SetScriptBatchJobDefinition(v *ScriptBatchJobDefinition) *BatchJobDefinition {
	s.ScriptBatchJobDefinition = v
	return s
}

// A subset of the possible batch job attributes. Used in the batch job list.
type BatchJobExecutionSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application that hosts this batch job.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The timestamp when this batch job execution ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The unique identifier of this execution of the batch job.
	//
	// ExecutionId is a required field
	ExecutionId *string `locationName:"executionId" type:"string" required:"true"`

	// The unique identifier of a particular batch job.
	JobId *string `locationName:"jobId" type:"string"`

	// The name of a particular batch job.
	JobName *string `locationName:"jobName" type:"string"`

	// The type of a particular batch job execution.
	JobType *string `locationName:"jobType" type:"string" enum:"BatchJobType"`

	// The timestamp when a particular batch job execution started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The status of a particular batch job execution.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"BatchJobExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchJobExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchJobExecutionSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *BatchJobExecutionSummary) SetApplicationId(v string) *BatchJobExecutionSummary {
	s.ApplicationId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *BatchJobExecutionSummary) SetEndTime(v time.Time) *BatchJobExecutionSummary {
	s.EndTime = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *BatchJobExecutionSummary) SetExecutionId(v string) *BatchJobExecutionSummary {
	s.ExecutionId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *BatchJobExecutionSummary) SetJobId(v string) *BatchJobExecutionSummary {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchJobExecutionSummary) SetJobName(v string) *BatchJobExecutionSummary {
	s.JobName = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *BatchJobExecutionSummary) SetJobType(v string) *BatchJobExecutionSummary {
	s.JobType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *BatchJobExecutionSummary) SetStartTime(v time.Time) *BatchJobExecutionSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchJobExecutionSummary) SetStatus(v string) *BatchJobExecutionSummary {
	s.Status = &v
	return s
}

// Identifies a specific batch job.
type BatchJobIdentifier struct {
	_ struct{} `type:"structure"`

	// Specifies a file associated with a specific batch job.
	FileBatchJobIdentifier *FileBatchJobIdentifier `locationName:"fileBatchJobIdentifier" type:"structure"`

	// A batch job identifier in which the batch job to run is identified by the
	// script name.
	ScriptBatchJobIdentifier *ScriptBatchJobIdentifier `locationName:"scriptBatchJobIdentifier" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchJobIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchJobIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchJobIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchJobIdentifier"}
	if s.FileBatchJobIdentifier != nil {
		if err := s.FileBatchJobIdentifier.Validate(); err != nil {
			invalidParams.AddNested("FileBatchJobIdentifier", err.(request.ErrInvalidParams))
		}
	}
	if s.ScriptBatchJobIdentifier != nil {
		if err := s.ScriptBatchJobIdentifier.Validate(); err != nil {
			invalidParams.AddNested("ScriptBatchJobIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileBatchJobIdentifier sets the FileBatchJobIdentifier field's value.
func (s *BatchJobIdentifier) SetFileBatchJobIdentifier(v *FileBatchJobIdentifier) *BatchJobIdentifier {
	s.FileBatchJobIdentifier = v
	return s
}

// SetScriptBatchJobIdentifier sets the ScriptBatchJobIdentifier field's value.
func (s *BatchJobIdentifier) SetScriptBatchJobIdentifier(v *ScriptBatchJobIdentifier) *BatchJobIdentifier {
	s.ScriptBatchJobIdentifier = v
	return s
}

type CancelBatchJobExecutionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The unique identifier of the batch job execution.
	//
	// ExecutionId is a required field
	ExecutionId *string `location:"uri" locationName:"executionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchJobExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchJobExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelBatchJobExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelBatchJobExecutionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionId"))
	}
	if s.ExecutionId != nil && len(*s.ExecutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CancelBatchJobExecutionInput) SetApplicationId(v string) *CancelBatchJobExecutionInput {
	s.ApplicationId = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *CancelBatchJobExecutionInput) SetExecutionId(v string) *CancelBatchJobExecutionInput {
	s.ExecutionId = &v
	return s
}

type CancelBatchJobExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchJobExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelBatchJobExecutionOutput) GoString() string {
	return s.String()
}

// The parameters provided in the request conflict with existing resources.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the conflicting resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the conflicting resource.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier the service generates to ensure the idempotency
	// of the request to create an application. The service generates the clientToken
	// when the API call is triggered. The token expires after one hour, so if you
	// retry the API within this timeframe with the same clientToken, you will get
	// the same response. The service also handles deleting the clientToken after
	// it expires.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The application definition for this application. You can specify either inline
	// JSON or an S3 bucket location.
	//
	// Definition is a required field
	Definition *Definition `locationName:"definition" type:"structure" required:"true"`

	// The description of the application.
	Description *string `locationName:"description" type:"string"`

	// The type of the target platform for this application.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// The unique identifier of the application.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A list of tags to apply to the application.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.EngineType == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateApplicationInput) SetClientToken(v string) *CreateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateApplicationInput) SetDefinition(v *Definition) *CreateApplicationInput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *CreateApplicationInput) SetEngineType(v string) *CreateApplicationInput {
	s.EngineType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v map[string]*string) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `locationName:"applicationArn" type:"string" required:"true"`

	// The unique application identifier.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The version number of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *CreateApplicationOutput) SetApplicationArn(v string) *CreateApplicationOutput {
	s.ApplicationArn = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationOutput) SetApplicationId(v string) *CreateApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *CreateApplicationOutput) SetApplicationVersion(v int64) *CreateApplicationOutput {
	s.ApplicationVersion = &v
	return s
}

type CreateDataSetImportTaskInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application for which you want to import data
	// sets.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request to create a data set import. The service generates the clientToken
	// when the API call is triggered. The token expires after one hour, so if you
	// retry the API within this timeframe with the same clientToken, you will get
	// the same response. The service also handles deleting the clientToken after
	// it expires.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The data set import task configuration.
	//
	// ImportConfig is a required field
	ImportConfig *DataSetImportConfig `locationName:"importConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetImportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetImportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSetImportTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSetImportTaskInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ImportConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportConfig"))
	}
	if s.ImportConfig != nil {
		if err := s.ImportConfig.Validate(); err != nil {
			invalidParams.AddNested("ImportConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateDataSetImportTaskInput) SetApplicationId(v string) *CreateDataSetImportTaskInput {
	s.ApplicationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataSetImportTaskInput) SetClientToken(v string) *CreateDataSetImportTaskInput {
	s.ClientToken = &v
	return s
}

// SetImportConfig sets the ImportConfig field's value.
func (s *CreateDataSetImportTaskInput) SetImportConfig(v *DataSetImportConfig) *CreateDataSetImportTaskInput {
	s.ImportConfig = v
	return s
}

type CreateDataSetImportTaskOutput struct {
	_ struct{} `type:"structure"`

	// The task identifier. This operation is asynchronous. Use this identifier
	// with the GetDataSetImportTask operation to obtain the status of this task.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetImportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetImportTaskOutput) GoString() string {
	return s.String()
}

// SetTaskId sets the TaskId field's value.
func (s *CreateDataSetImportTaskOutput) SetTaskId(v string) *CreateDataSetImportTaskOutput {
	s.TaskId = &v
	return s
}

type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The application identifier.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The version of the application to deploy.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request to create a deployment. The service generates the clientToken
	// when the API call is triggered. The token expires after one hour, so if you
	// retry the API within this timeframe with the same clientToken, you will get
	// the same response. The service also handles deleting the clientToken after
	// it expires.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The identifier of the environment where this application will be deployed.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ApplicationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationVersion"))
	}
	if s.ApplicationVersion != nil && *s.ApplicationVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ApplicationVersion", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateDeploymentInput) SetApplicationId(v string) *CreateDeploymentInput {
	s.ApplicationId = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *CreateDeploymentInput) SetApplicationVersion(v int64) *CreateDeploymentInput {
	s.ApplicationVersion = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDeploymentInput) SetClientToken(v string) *CreateDeploymentInput {
	s.ClientToken = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateDeploymentInput) SetEnvironmentId(v string) *CreateDeploymentInput {
	s.EnvironmentId = &v
	return s
}

type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure the idempotency of
	// the request to create an environment. The service generates the clientToken
	// when the API call is triggered. The token expires after one hour, so if you
	// retry the API within this timeframe with the same clientToken, you will get
	// the same response. The service also handles deleting the clientToken after
	// it expires.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The description of the environment.
	Description *string `locationName:"description" type:"string"`

	// The engine type for the environment.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// The version of the engine type for the environment.
	EngineVersion *string `locationName:"engineVersion" type:"string"`

	// The details of a high availability configuration for this runtime environment.
	HighAvailabilityConfig *HighAvailabilityConfig `locationName:"highAvailabilityConfig" type:"structure"`

	// The type of instance for the environment.
	//
	// InstanceType is a required field
	InstanceType *string `locationName:"instanceType" type:"string" required:"true"`

	// The unique identifier of the environment.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Configures a desired maintenance window for the environment. If you do not
	// provide a value, a random system-generated value will be assigned.
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`

	// Specifies whether the environment is publicly accessible.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The list of security groups for the VPC associated with this environment.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// Optional. The storage configurations for this environment.
	StorageConfigurations []*StorageConfiguration `locationName:"storageConfigurations" type:"list"`

	// The list of subnets associated with the VPC for this environment.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The tags for the environment.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.EngineType == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineType"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.HighAvailabilityConfig != nil {
		if err := s.HighAvailabilityConfig.Validate(); err != nil {
			invalidParams.AddNested("HighAvailabilityConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageConfigurations != nil {
		for i, v := range s.StorageConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StorageConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEnvironmentInput) SetClientToken(v string) *CreateEnvironmentInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentInput) SetDescription(v string) *CreateEnvironmentInput {
	s.Description = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *CreateEnvironmentInput) SetEngineType(v string) *CreateEnvironmentInput {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateEnvironmentInput) SetEngineVersion(v string) *CreateEnvironmentInput {
	s.EngineVersion = &v
	return s
}

// SetHighAvailabilityConfig sets the HighAvailabilityConfig field's value.
func (s *CreateEnvironmentInput) SetHighAvailabilityConfig(v *HighAvailabilityConfig) *CreateEnvironmentInput {
	s.HighAvailabilityConfig = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateEnvironmentInput) SetInstanceType(v string) *CreateEnvironmentInput {
	s.InstanceType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentInput) SetName(v string) *CreateEnvironmentInput {
	s.Name = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateEnvironmentInput) SetPreferredMaintenanceWindow(v string) *CreateEnvironmentInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateEnvironmentInput) SetPubliclyAccessible(v bool) *CreateEnvironmentInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateEnvironmentInput) SetSecurityGroupIds(v []*string) *CreateEnvironmentInput {
	s.SecurityGroupIds = v
	return s
}

// SetStorageConfigurations sets the StorageConfigurations field's value.
func (s *CreateEnvironmentInput) SetStorageConfigurations(v []*StorageConfiguration) *CreateEnvironmentInput {
	s.StorageConfigurations = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateEnvironmentInput) SetSubnetIds(v []*string) *CreateEnvironmentInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentInput) SetTags(v map[string]*string) *CreateEnvironmentInput {
	s.Tags = v
	return s
}

type CreateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of this environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateEnvironmentOutput) SetEnvironmentId(v string) *CreateEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// Defines a data set.
type DataSet struct {
	_ struct{} `type:"structure"`

	// The logical identifier for a specific data set (in mainframe format).
	//
	// DatasetName is a required field
	DatasetName *string `locationName:"datasetName" type:"string" required:"true"`

	// The type of dataset. Possible values include VSAM, IS, PS, GDG, PO, PS, UNKNOWN
	// etc.
	//
	// DatasetOrg is a required field
	DatasetOrg *DatasetOrgAttributes `locationName:"datasetOrg" type:"structure" required:"true"`

	// The length of a record.
	//
	// RecordLength is a required field
	RecordLength *RecordLength `locationName:"recordLength" type:"structure" required:"true"`

	// The relative location of the data set in the database or file system.
	RelativePath *string `locationName:"relativePath" type:"string"`

	// The storage type of the data set: database or file system. For Micro Focus,
	// database corresponds to datastore and file system corresponds to EFS/FSX.
	// For Blu Age, there is no support of file system and database corresponds
	// to Blusam.
	StorageType *string `locationName:"storageType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSet"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetOrg == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetOrg"))
	}
	if s.RecordLength == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordLength"))
	}
	if s.DatasetOrg != nil {
		if err := s.DatasetOrg.Validate(); err != nil {
			invalidParams.AddNested("DatasetOrg", err.(request.ErrInvalidParams))
		}
	}
	if s.RecordLength != nil {
		if err := s.RecordLength.Validate(); err != nil {
			invalidParams.AddNested("RecordLength", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DataSet) SetDatasetName(v string) *DataSet {
	s.DatasetName = &v
	return s
}

// SetDatasetOrg sets the DatasetOrg field's value.
func (s *DataSet) SetDatasetOrg(v *DatasetOrgAttributes) *DataSet {
	s.DatasetOrg = v
	return s
}

// SetRecordLength sets the RecordLength field's value.
func (s *DataSet) SetRecordLength(v *RecordLength) *DataSet {
	s.RecordLength = v
	return s
}

// SetRelativePath sets the RelativePath field's value.
func (s *DataSet) SetRelativePath(v string) *DataSet {
	s.RelativePath = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DataSet) SetStorageType(v string) *DataSet {
	s.StorageType = &v
	return s
}

// Identifies one or more data sets you want to import with the CreateDataSetImportTask
// operation.
type DataSetImportConfig struct {
	_ struct{} `type:"structure"`

	// The data sets.
	DataSets []*DataSetImportItem `locationName:"dataSets" min:"1" type:"list"`

	// The Amazon S3 location of the data sets.
	S3Location *string `locationName:"s3Location" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetImportConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetImportConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSetImportConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSetImportConfig"}
	if s.DataSets != nil && len(s.DataSets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSets", 1))
	}
	if s.DataSets != nil {
		for i, v := range s.DataSets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSets sets the DataSets field's value.
func (s *DataSetImportConfig) SetDataSets(v []*DataSetImportItem) *DataSetImportConfig {
	s.DataSets = v
	return s
}

// SetS3Location sets the S3Location field's value.
func (s *DataSetImportConfig) SetS3Location(v string) *DataSetImportConfig {
	s.S3Location = &v
	return s
}

// Identifies a specific data set to import from an external location.
type DataSetImportItem struct {
	_ struct{} `type:"structure"`

	// The data set.
	//
	// DataSet is a required field
	DataSet *DataSet `locationName:"dataSet" type:"structure" required:"true"`

	// The location of the data set.
	//
	// ExternalLocation is a required field
	ExternalLocation *ExternalLocation `locationName:"externalLocation" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetImportItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetImportItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSetImportItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSetImportItem"}
	if s.DataSet == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSet"))
	}
	if s.ExternalLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalLocation"))
	}
	if s.DataSet != nil {
		if err := s.DataSet.Validate(); err != nil {
			invalidParams.AddNested("DataSet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSet sets the DataSet field's value.
func (s *DataSetImportItem) SetDataSet(v *DataSet) *DataSetImportItem {
	s.DataSet = v
	return s
}

// SetExternalLocation sets the ExternalLocation field's value.
func (s *DataSetImportItem) SetExternalLocation(v *ExternalLocation) *DataSetImportItem {
	s.ExternalLocation = v
	return s
}

// Represents a summary of data set imports.
type DataSetImportSummary struct {
	_ struct{} `type:"structure"`

	// The number of data set imports that have failed.
	//
	// Failed is a required field
	Failed *int64 `locationName:"failed" type:"integer" required:"true"`

	// The number of data set imports that are in progress.
	//
	// InProgress is a required field
	InProgress *int64 `locationName:"inProgress" type:"integer" required:"true"`

	// The number of data set imports that are pending.
	//
	// Pending is a required field
	Pending *int64 `locationName:"pending" type:"integer" required:"true"`

	// The number of data set imports that have succeeded.
	//
	// Succeeded is a required field
	Succeeded *int64 `locationName:"succeeded" type:"integer" required:"true"`

	// The total number of data set imports.
	//
	// Total is a required field
	Total *int64 `locationName:"total" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetImportSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetImportSummary) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *DataSetImportSummary) SetFailed(v int64) *DataSetImportSummary {
	s.Failed = &v
	return s
}

// SetInProgress sets the InProgress field's value.
func (s *DataSetImportSummary) SetInProgress(v int64) *DataSetImportSummary {
	s.InProgress = &v
	return s
}

// SetPending sets the Pending field's value.
func (s *DataSetImportSummary) SetPending(v int64) *DataSetImportSummary {
	s.Pending = &v
	return s
}

// SetSucceeded sets the Succeeded field's value.
func (s *DataSetImportSummary) SetSucceeded(v int64) *DataSetImportSummary {
	s.Succeeded = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *DataSetImportSummary) SetTotal(v int64) *DataSetImportSummary {
	s.Total = &v
	return s
}

// Contains information about a data set import task.
type DataSetImportTask struct {
	_ struct{} `type:"structure"`

	// The status of the data set import task.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSetTaskLifecycle"`

	// A summary of the data set import task.
	//
	// Summary is a required field
	Summary *DataSetImportSummary `locationName:"summary" type:"structure" required:"true"`

	// The identifier of the data set import task.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetImportTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetImportTask) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DataSetImportTask) SetStatus(v string) *DataSetImportTask {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *DataSetImportTask) SetSummary(v *DataSetImportSummary) *DataSetImportTask {
	s.Summary = v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *DataSetImportTask) SetTaskId(v string) *DataSetImportTask {
	s.TaskId = &v
	return s
}

// A subset of the possible data set attributes.
type DataSetSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp when the data set was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the data set.
	//
	// DataSetName is a required field
	DataSetName *string `locationName:"dataSetName" type:"string" required:"true"`

	// The type of data set. Possible values include VSAM, IS, PS, GDG, PO, PS,
	// or unknown.
	DataSetOrg *string `locationName:"dataSetOrg" type:"string"`

	// The format of the data set.
	Format *string `locationName:"format" type:"string"`

	// The last time the data set was referenced.
	LastReferencedTime *time.Time `locationName:"lastReferencedTime" type:"timestamp"`

	// The last time the data set was updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DataSetSummary) SetCreationTime(v time.Time) *DataSetSummary {
	s.CreationTime = &v
	return s
}

// SetDataSetName sets the DataSetName field's value.
func (s *DataSetSummary) SetDataSetName(v string) *DataSetSummary {
	s.DataSetName = &v
	return s
}

// SetDataSetOrg sets the DataSetOrg field's value.
func (s *DataSetSummary) SetDataSetOrg(v string) *DataSetSummary {
	s.DataSetOrg = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *DataSetSummary) SetFormat(v string) *DataSetSummary {
	s.Format = &v
	return s
}

// SetLastReferencedTime sets the LastReferencedTime field's value.
func (s *DataSetSummary) SetLastReferencedTime(v time.Time) *DataSetSummary {
	s.LastReferencedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DataSetSummary) SetLastUpdatedTime(v time.Time) *DataSetSummary {
	s.LastUpdatedTime = &v
	return s
}

// Additional details about the data set. Different attributes correspond to
// different data set organizations. The values are populated based on datasetOrg,
// storageType and backend (Blu Age or Micro Focus).
type DatasetDetailOrgAttributes struct {
	_ struct{} `type:"structure"`

	// The generation data group of the data set.
	Gdg *GdgDetailAttributes `locationName:"gdg" type:"structure"`

	// The details of a VSAM data set.
	Vsam *VsamDetailAttributes `locationName:"vsam" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetDetailOrgAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetDetailOrgAttributes) GoString() string {
	return s.String()
}

// SetGdg sets the Gdg field's value.
func (s *DatasetDetailOrgAttributes) SetGdg(v *GdgDetailAttributes) *DatasetDetailOrgAttributes {
	s.Gdg = v
	return s
}

// SetVsam sets the Vsam field's value.
func (s *DatasetDetailOrgAttributes) SetVsam(v *VsamDetailAttributes) *DatasetDetailOrgAttributes {
	s.Vsam = v
	return s
}

// Additional details about the data set. Different attributes correspond to
// different data set organizations. The values are populated based on datasetOrg,
// storageType and backend (Blu Age or Micro Focus).
type DatasetOrgAttributes struct {
	_ struct{} `type:"structure"`

	// The generation data group of the data set.
	Gdg *GdgAttributes `locationName:"gdg" type:"structure"`

	// The details of a VSAM data set.
	Vsam *VsamAttributes `locationName:"vsam" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetOrgAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetOrgAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetOrgAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetOrgAttributes"}
	if s.Vsam != nil {
		if err := s.Vsam.Validate(); err != nil {
			invalidParams.AddNested("Vsam", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGdg sets the Gdg field's value.
func (s *DatasetOrgAttributes) SetGdg(v *GdgAttributes) *DatasetOrgAttributes {
	s.Gdg = v
	return s
}

// SetVsam sets the Vsam field's value.
func (s *DatasetOrgAttributes) SetVsam(v *VsamAttributes) *DatasetOrgAttributes {
	s.Vsam = v
	return s
}

// The application definition for a particular application.
type Definition struct {
	_ struct{} `type:"structure"`

	// The content of the application definition. This is a JSON object that contains
	// the resource configuration/definitions that identify an application.
	Content *string `locationName:"content" min:"1" type:"string"`

	// The S3 bucket that contains the application definition.
	S3Location *string `locationName:"s3Location" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Definition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Definition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Definition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Definition"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *Definition) SetContent(v string) *Definition {
	s.Content = &v
	return s
}

// SetS3Location sets the S3Location field's value.
func (s *Definition) SetS3Location(v string) *Definition {
	s.S3Location = &v
	return s
}

type DeleteApplicationFromEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application you want to delete.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The unique identifier of the runtime environment where the application was
	// previously deployed.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationFromEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationFromEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationFromEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationFromEnvironmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApplicationFromEnvironmentInput) SetApplicationId(v string) *DeleteApplicationFromEnvironmentInput {
	s.ApplicationId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteApplicationFromEnvironmentInput) SetEnvironmentId(v string) *DeleteApplicationFromEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type DeleteApplicationFromEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationFromEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationFromEnvironmentOutput) GoString() string {
	return s.String()
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application you want to delete.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApplicationInput) SetApplicationId(v string) *DeleteApplicationInput {
	s.ApplicationId = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the runtime environment you want to delete.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteEnvironmentInput) SetEnvironmentId(v string) *DeleteEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

// Contains a summary of a deployed application.
type DeployedVersionSummary struct {
	_ struct{} `type:"structure"`

	// The version of the deployed application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`

	// The status of the deployment.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DeploymentLifecycle"`

	// The reason for the reported status.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployedVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployedVersionSummary) GoString() string {
	return s.String()
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *DeployedVersionSummary) SetApplicationVersion(v int64) *DeployedVersionSummary {
	s.ApplicationVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeployedVersionSummary) SetStatus(v string) *DeployedVersionSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DeployedVersionSummary) SetStatusReason(v string) *DeployedVersionSummary {
	s.StatusReason = &v
	return s
}

// A subset of information about a specific deployment.
type DeploymentSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The version of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`

	// The timestamp when the deployment was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The unique identifier of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The unique identifier of the environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The current status of the deployment.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DeploymentLifecycle"`

	// The reason for the reported status.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentSummary) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeploymentSummary) SetApplicationId(v string) *DeploymentSummary {
	s.ApplicationId = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *DeploymentSummary) SetApplicationVersion(v int64) *DeploymentSummary {
	s.ApplicationVersion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DeploymentSummary) SetCreationTime(v time.Time) *DeploymentSummary {
	s.CreationTime = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *DeploymentSummary) SetDeploymentId(v string) *DeploymentSummary {
	s.DeploymentId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeploymentSummary) SetEnvironmentId(v string) *DeploymentSummary {
	s.EnvironmentId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeploymentSummary) SetStatus(v string) *DeploymentSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DeploymentSummary) SetStatusReason(v string) *DeploymentSummary {
	s.StatusReason = &v
	return s
}

// Defines the storage configuration for an Amazon EFS file system.
type EfsStorageConfiguration struct {
	_ struct{} `type:"structure"`

	// The file system identifier.
	//
	// FileSystemId is a required field
	FileSystemId *string `locationName:"file-system-id" type:"string" required:"true"`

	// The mount point for the file system.
	//
	// MountPoint is a required field
	MountPoint *string `locationName:"mount-point" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EfsStorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EfsStorageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EfsStorageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EfsStorageConfiguration"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.MountPoint == nil {
		invalidParams.Add(request.NewErrParamRequired("MountPoint"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *EfsStorageConfiguration) SetFileSystemId(v string) *EfsStorageConfiguration {
	s.FileSystemId = &v
	return s
}

// SetMountPoint sets the MountPoint field's value.
func (s *EfsStorageConfiguration) SetMountPoint(v string) *EfsStorageConfiguration {
	s.MountPoint = &v
	return s
}

// A subset of information about the engine version for a specific application.
type EngineVersionsSummary struct {
	_ struct{} `type:"structure"`

	// The type of target platform for the application.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true"`

	// The version of the engine type used by the application.
	//
	// EngineVersion is a required field
	EngineVersion *string `locationName:"engineVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineVersionsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineVersionsSummary) GoString() string {
	return s.String()
}

// SetEngineType sets the EngineType field's value.
func (s *EngineVersionsSummary) SetEngineType(v string) *EngineVersionsSummary {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *EngineVersionsSummary) SetEngineVersion(v string) *EngineVersionsSummary {
	s.EngineVersion = &v
	return s
}

// Contains a subset of the possible environment attributes. Used in the environment
// list.
type EnvironmentSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp when the environment was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The target platform for the environment.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// The version of the runtime engine.
	//
	// EngineVersion is a required field
	EngineVersion *string `locationName:"engineVersion" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a particular runtime environment.
	//
	// EnvironmentArn is a required field
	EnvironmentArn *string `locationName:"environmentArn" type:"string" required:"true"`

	// The unique identifier of a particular runtime environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The instance type of the environment.
	//
	// InstanceType is a required field
	InstanceType *string `locationName:"instanceType" type:"string" required:"true"`

	// The name of the environment.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the environment
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"EnvironmentLifecycle"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *EnvironmentSummary) SetCreationTime(v time.Time) *EnvironmentSummary {
	s.CreationTime = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *EnvironmentSummary) SetEngineType(v string) *EnvironmentSummary {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *EnvironmentSummary) SetEngineVersion(v string) *EnvironmentSummary {
	s.EngineVersion = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *EnvironmentSummary) SetEnvironmentArn(v string) *EnvironmentSummary {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentSummary) SetEnvironmentId(v string) *EnvironmentSummary {
	s.EnvironmentId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *EnvironmentSummary) SetInstanceType(v string) *EnvironmentSummary {
	s.InstanceType = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentSummary) SetName(v string) *EnvironmentSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EnvironmentSummary) SetStatus(v string) *EnvironmentSummary {
	s.Status = &v
	return s
}

// Defines an external storage location.
type ExternalLocation struct {
	_ struct{} `type:"structure"`

	// The URI of the Amazon S3 bucket.
	S3Location *string `locationName:"s3Location" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalLocation) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *ExternalLocation) SetS3Location(v string) *ExternalLocation {
	s.S3Location = &v
	return s
}

// A file containing a batch job definition.
type FileBatchJobDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the file containing the batch job definition.
	//
	// FileName is a required field
	FileName *string `locationName:"fileName" type:"string" required:"true"`

	// The path to the file containing the batch job definition.
	FolderPath *string `locationName:"folderPath" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileBatchJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileBatchJobDefinition) GoString() string {
	return s.String()
}

// SetFileName sets the FileName field's value.
func (s *FileBatchJobDefinition) SetFileName(v string) *FileBatchJobDefinition {
	s.FileName = &v
	return s
}

// SetFolderPath sets the FolderPath field's value.
func (s *FileBatchJobDefinition) SetFolderPath(v string) *FileBatchJobDefinition {
	s.FolderPath = &v
	return s
}

// A batch job identifier in which the batch job to run is identified by the
// file name and the relative path to the file name.
type FileBatchJobIdentifier struct {
	_ struct{} `type:"structure"`

	// The file name for the batch job identifier.
	//
	// FileName is a required field
	FileName *string `locationName:"fileName" type:"string" required:"true"`

	// The relative path to the file name for the batch job identifier.
	FolderPath *string `locationName:"folderPath" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileBatchJobIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileBatchJobIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileBatchJobIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileBatchJobIdentifier"}
	if s.FileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileName sets the FileName field's value.
func (s *FileBatchJobIdentifier) SetFileName(v string) *FileBatchJobIdentifier {
	s.FileName = &v
	return s
}

// SetFolderPath sets the FolderPath field's value.
func (s *FileBatchJobIdentifier) SetFolderPath(v string) *FileBatchJobIdentifier {
	s.FolderPath = &v
	return s
}

// Defines the storage configuration for an Amazon FSx file system.
type FsxStorageConfiguration struct {
	_ struct{} `type:"structure"`

	// The file system identifier.
	//
	// FileSystemId is a required field
	FileSystemId *string `locationName:"file-system-id" type:"string" required:"true"`

	// The mount point for the file system.
	//
	// MountPoint is a required field
	MountPoint *string `locationName:"mount-point" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FsxStorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FsxStorageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FsxStorageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FsxStorageConfiguration"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.MountPoint == nil {
		invalidParams.Add(request.NewErrParamRequired("MountPoint"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *FsxStorageConfiguration) SetFileSystemId(v string) *FsxStorageConfiguration {
	s.FileSystemId = &v
	return s
}

// SetMountPoint sets the MountPoint field's value.
func (s *FsxStorageConfiguration) SetMountPoint(v string) *FsxStorageConfiguration {
	s.MountPoint = &v
	return s
}

// The required attributes for a generation data group data set. A generation
// data set is one of a collection of successive, historically related, catalogued
// data sets that together are known as a generation data group (GDG). Use this
// structure when you want to import a GDG. For more information on GDG, see
// Generation data sets (https://www.ibm.com/docs/en/zos/2.3.0?topic=guide-generation-data-sets).
type GdgAttributes struct {
	_ struct{} `type:"structure"`

	// The maximum number of generation data sets, up to 255, in a GDG.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The disposition of the data set in the catalog.
	RollDisposition *string `locationName:"rollDisposition" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GdgAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GdgAttributes) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GdgAttributes) SetLimit(v int64) *GdgAttributes {
	s.Limit = &v
	return s
}

// SetRollDisposition sets the RollDisposition field's value.
func (s *GdgAttributes) SetRollDisposition(v string) *GdgAttributes {
	s.RollDisposition = &v
	return s
}

// The required attributes for a generation data group data set. A generation
// data set is one of a collection of successive, historically related, catalogued
// data sets that together are known as a generation data group (GDG). Use this
// structure when you want to import a GDG. For more information on GDG, see
// Generation data sets (https://www.ibm.com/docs/en/zos/2.3.0?topic=guide-generation-data-sets).
type GdgDetailAttributes struct {
	_ struct{} `type:"structure"`

	// The maximum number of generation data sets, up to 255, in a GDG.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The disposition of the data set in the catalog.
	RollDisposition *string `locationName:"rollDisposition" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GdgDetailAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GdgDetailAttributes) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GdgDetailAttributes) SetLimit(v int64) *GdgDetailAttributes {
	s.Limit = &v
	return s
}

// SetRollDisposition sets the RollDisposition field's value.
func (s *GdgDetailAttributes) SetRollDisposition(v string) *GdgDetailAttributes {
	s.RollDisposition = &v
	return s
}

type GetApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationInput) SetApplicationId(v string) *GetApplicationInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `locationName:"applicationArn" type:"string" required:"true"`

	// The identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The timestamp when this application was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The version of the application that is deployed.
	DeployedVersion *DeployedVersionSummary `locationName:"deployedVersion" type:"structure"`

	// The description of the application.
	Description *string `locationName:"description" type:"string"`

	// The type of the target platform for the application.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// The identifier of the environment where the application will be deployed.
	EnvironmentId *string `locationName:"environmentId" type:"string"`

	// The timestamp when the application was last started. Null until the application
	// has started running for the first time.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp"`

	// The latest version of the application.
	//
	// LatestVersion is a required field
	LatestVersion *ApplicationVersionSummary `locationName:"latestVersion" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for the network load balancer listener created
	// in your Amazon Web Services account. Amazon Web Services Mainframe Modernization
	// creates this listener on your behalf the first time you deploy an application.
	ListenerArns []*string `locationName:"listenerArns" min:"1" type:"list"`

	// The port associated with the network load balancer listener created in your
	// Amazon Web Services account.
	ListenerPorts []*int64 `locationName:"listenerPorts" min:"1" type:"list"`

	// The public DNS name of the load balancer created in your Amazon Web Services
	// account.
	LoadBalancerDnsName *string `locationName:"loadBalancerDnsName" type:"string"`

	// The list of log summaries. Each log summary includes the log type as well
	// as the log group identifier. These are CloudWatch logs. The Amazon Web Services
	// Mainframe Modernization application log is pushed to CloudWatch under the
	// customer's account.
	LogGroups []*LogGroupSummary `locationName:"logGroups" type:"list"`

	// The unique identifier of the application.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the application.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ApplicationLifecycle"`

	// The reason for the reported status.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// A list of tags associated with the application.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Returns the Amazon Resource Names (ARNs) of the target groups that are attached
	// to the network load balancer.
	TargetGroupArns []*string `locationName:"targetGroupArns" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *GetApplicationOutput) SetApplicationArn(v string) *GetApplicationOutput {
	s.ApplicationArn = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationOutput) SetApplicationId(v string) *GetApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetApplicationOutput) SetCreationTime(v time.Time) *GetApplicationOutput {
	s.CreationTime = &v
	return s
}

// SetDeployedVersion sets the DeployedVersion field's value.
func (s *GetApplicationOutput) SetDeployedVersion(v *DeployedVersionSummary) *GetApplicationOutput {
	s.DeployedVersion = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetApplicationOutput) SetDescription(v string) *GetApplicationOutput {
	s.Description = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *GetApplicationOutput) SetEngineType(v string) *GetApplicationOutput {
	s.EngineType = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetApplicationOutput) SetEnvironmentId(v string) *GetApplicationOutput {
	s.EnvironmentId = &v
	return s
}

// SetLastStartTime sets the LastStartTime field's value.
func (s *GetApplicationOutput) SetLastStartTime(v time.Time) *GetApplicationOutput {
	s.LastStartTime = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetApplicationOutput) SetLatestVersion(v *ApplicationVersionSummary) *GetApplicationOutput {
	s.LatestVersion = v
	return s
}

// SetListenerArns sets the ListenerArns field's value.
func (s *GetApplicationOutput) SetListenerArns(v []*string) *GetApplicationOutput {
	s.ListenerArns = v
	return s
}

// SetListenerPorts sets the ListenerPorts field's value.
func (s *GetApplicationOutput) SetListenerPorts(v []*int64) *GetApplicationOutput {
	s.ListenerPorts = v
	return s
}

// SetLoadBalancerDnsName sets the LoadBalancerDnsName field's value.
func (s *GetApplicationOutput) SetLoadBalancerDnsName(v string) *GetApplicationOutput {
	s.LoadBalancerDnsName = &v
	return s
}

// SetLogGroups sets the LogGroups field's value.
func (s *GetApplicationOutput) SetLogGroups(v []*LogGroupSummary) *GetApplicationOutput {
	s.LogGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *GetApplicationOutput) SetName(v string) *GetApplicationOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetApplicationOutput) SetStatus(v string) *GetApplicationOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetApplicationOutput) SetStatusReason(v string) *GetApplicationOutput {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetApplicationOutput) SetTags(v map[string]*string) *GetApplicationOutput {
	s.Tags = v
	return s
}

// SetTargetGroupArns sets the TargetGroupArns field's value.
func (s *GetApplicationOutput) SetTargetGroupArns(v []*string) *GetApplicationOutput {
	s.TargetGroupArns = v
	return s
}

type GetApplicationVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The specific version of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `location:"uri" locationName:"applicationVersion" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ApplicationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationVersion"))
	}
	if s.ApplicationVersion != nil && *s.ApplicationVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ApplicationVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationVersionInput) SetApplicationId(v string) *GetApplicationVersionInput {
	s.ApplicationId = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *GetApplicationVersionInput) SetApplicationVersion(v int64) *GetApplicationVersionInput {
	s.ApplicationVersion = &v
	return s
}

type GetApplicationVersionOutput struct {
	_ struct{} `type:"structure"`

	// The specific version of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`

	// The timestamp when the application version was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The content of the application definition. This is a JSON object that contains
	// the resource configuration/definitions that identify an application.
	//
	// DefinitionContent is a required field
	DefinitionContent *string `locationName:"definitionContent" min:"1" type:"string" required:"true"`

	// The application description.
	Description *string `locationName:"description" type:"string"`

	// The name of the application version.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the application version.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ApplicationVersionLifecycle"`

	// The reason for the reported status.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationVersionOutput) GoString() string {
	return s.String()
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *GetApplicationVersionOutput) SetApplicationVersion(v int64) *GetApplicationVersionOutput {
	s.ApplicationVersion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetApplicationVersionOutput) SetCreationTime(v time.Time) *GetApplicationVersionOutput {
	s.CreationTime = &v
	return s
}

// SetDefinitionContent sets the DefinitionContent field's value.
func (s *GetApplicationVersionOutput) SetDefinitionContent(v string) *GetApplicationVersionOutput {
	s.DefinitionContent = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetApplicationVersionOutput) SetDescription(v string) *GetApplicationVersionOutput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetApplicationVersionOutput) SetName(v string) *GetApplicationVersionOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetApplicationVersionOutput) SetStatus(v string) *GetApplicationVersionOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetApplicationVersionOutput) SetStatusReason(v string) *GetApplicationVersionOutput {
	s.StatusReason = &v
	return s
}

type GetBatchJobExecutionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The unique identifier of the batch job execution.
	//
	// ExecutionId is a required field
	ExecutionId *string `location:"uri" locationName:"executionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchJobExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchJobExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBatchJobExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBatchJobExecutionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionId"))
	}
	if s.ExecutionId != nil && len(*s.ExecutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetBatchJobExecutionInput) SetApplicationId(v string) *GetBatchJobExecutionInput {
	s.ApplicationId = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *GetBatchJobExecutionInput) SetExecutionId(v string) *GetBatchJobExecutionInput {
	s.ExecutionId = &v
	return s
}

type GetBatchJobExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The timestamp when the batch job execution ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The unique identifier for this batch job execution.
	//
	// ExecutionId is a required field
	ExecutionId *string `locationName:"executionId" type:"string" required:"true"`

	// The unique identifier for this batch job.
	JobId *string `locationName:"jobId" type:"string"`

	// The name of this batch job.
	JobName *string `locationName:"jobName" type:"string"`

	// The type of job.
	JobType *string `locationName:"jobType" type:"string" enum:"BatchJobType"`

	// The user for the job.
	JobUser *string `locationName:"jobUser" type:"string"`

	// The timestamp when the batch job execution started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The status of the batch job execution.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"BatchJobExecutionStatus"`

	// The reason for the reported status.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchJobExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBatchJobExecutionOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetBatchJobExecutionOutput) SetApplicationId(v string) *GetBatchJobExecutionOutput {
	s.ApplicationId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetBatchJobExecutionOutput) SetEndTime(v time.Time) *GetBatchJobExecutionOutput {
	s.EndTime = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *GetBatchJobExecutionOutput) SetExecutionId(v string) *GetBatchJobExecutionOutput {
	s.ExecutionId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetBatchJobExecutionOutput) SetJobId(v string) *GetBatchJobExecutionOutput {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *GetBatchJobExecutionOutput) SetJobName(v string) *GetBatchJobExecutionOutput {
	s.JobName = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *GetBatchJobExecutionOutput) SetJobType(v string) *GetBatchJobExecutionOutput {
	s.JobType = &v
	return s
}

// SetJobUser sets the JobUser field's value.
func (s *GetBatchJobExecutionOutput) SetJobUser(v string) *GetBatchJobExecutionOutput {
	s.JobUser = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetBatchJobExecutionOutput) SetStartTime(v time.Time) *GetBatchJobExecutionOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBatchJobExecutionOutput) SetStatus(v string) *GetBatchJobExecutionOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetBatchJobExecutionOutput) SetStatusReason(v string) *GetBatchJobExecutionOutput {
	s.StatusReason = &v
	return s
}

type GetDataSetDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application that this data set is associated
	// with.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The name of the data set.
	//
	// DataSetName is a required field
	DataSetName *string `location:"uri" locationName:"dataSetName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSetDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSetDetailsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.DataSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetName"))
	}
	if s.DataSetName != nil && len(*s.DataSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDataSetDetailsInput) SetApplicationId(v string) *GetDataSetDetailsInput {
	s.ApplicationId = &v
	return s
}

// SetDataSetName sets the DataSetName field's value.
func (s *GetDataSetDetailsInput) SetDataSetName(v string) *GetDataSetDetailsInput {
	s.DataSetName = &v
	return s
}

type GetDataSetDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The size of the block on disk.
	Blocksize *int64 `locationName:"blocksize" type:"integer"`

	// The timestamp when the data set was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the data set.
	//
	// DataSetName is a required field
	DataSetName *string `locationName:"dataSetName" type:"string" required:"true"`

	// The type of data set. Possible values include VSAM, IS, PS, GDG, PO, PS,
	// or unknown.
	DataSetOrg *DatasetDetailOrgAttributes `locationName:"dataSetOrg" type:"structure"`

	// The last time the data set was referenced.
	LastReferencedTime *time.Time `locationName:"lastReferencedTime" type:"timestamp"`

	// The last time the data set was updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The locaion where the data set is stored.
	Location *string `locationName:"location" type:"string"`

	// The length of records in the data set.
	RecordLength *int64 `locationName:"recordLength" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetDetailsOutput) GoString() string {
	return s.String()
}

// SetBlocksize sets the Blocksize field's value.
func (s *GetDataSetDetailsOutput) SetBlocksize(v int64) *GetDataSetDetailsOutput {
	s.Blocksize = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetDataSetDetailsOutput) SetCreationTime(v time.Time) *GetDataSetDetailsOutput {
	s.CreationTime = &v
	return s
}

// SetDataSetName sets the DataSetName field's value.
func (s *GetDataSetDetailsOutput) SetDataSetName(v string) *GetDataSetDetailsOutput {
	s.DataSetName = &v
	return s
}

// SetDataSetOrg sets the DataSetOrg field's value.
func (s *GetDataSetDetailsOutput) SetDataSetOrg(v *DatasetDetailOrgAttributes) *GetDataSetDetailsOutput {
	s.DataSetOrg = v
	return s
}

// SetLastReferencedTime sets the LastReferencedTime field's value.
func (s *GetDataSetDetailsOutput) SetLastReferencedTime(v time.Time) *GetDataSetDetailsOutput {
	s.LastReferencedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetDataSetDetailsOutput) SetLastUpdatedTime(v time.Time) *GetDataSetDetailsOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *GetDataSetDetailsOutput) SetLocation(v string) *GetDataSetDetailsOutput {
	s.Location = &v
	return s
}

// SetRecordLength sets the RecordLength field's value.
func (s *GetDataSetDetailsOutput) SetRecordLength(v int64) *GetDataSetDetailsOutput {
	s.RecordLength = &v
	return s
}

type GetDataSetImportTaskInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application identifier.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The task identifier returned by the CreateDataSetImportTask operation.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetImportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetImportTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSetImportTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSetImportTaskInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDataSetImportTaskInput) SetApplicationId(v string) *GetDataSetImportTaskInput {
	s.ApplicationId = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *GetDataSetImportTaskInput) SetTaskId(v string) *GetDataSetImportTaskInput {
	s.TaskId = &v
	return s
}

type GetDataSetImportTaskOutput struct {
	_ struct{} `type:"structure"`

	// The status of the task.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSetTaskLifecycle"`

	// A summary of the status of the task.
	Summary *DataSetImportSummary `locationName:"summary" type:"structure"`

	// The task identifier.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetImportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSetImportTaskOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetDataSetImportTaskOutput) SetStatus(v string) *GetDataSetImportTaskOutput {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *GetDataSetImportTaskOutput) SetSummary(v *DataSetImportSummary) *GetDataSetImportTaskOutput {
	s.Summary = v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *GetDataSetImportTaskOutput) SetTaskId(v string) *GetDataSetImportTaskOutput {
	s.TaskId = &v
	return s
}

type GetDeploymentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The unique identifier for the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deploymentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDeploymentInput) SetApplicationId(v string) *GetDeploymentInput {
	s.ApplicationId = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentInput) SetDeploymentId(v string) *GetDeploymentInput {
	s.DeploymentId = &v
	return s
}

type GetDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" type:"string" required:"true"`

	// The application version.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`

	// The timestamp when the deployment was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The unique identifier of the deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The unique identifier of the runtime environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The status of the deployment.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DeploymentLifecycle"`

	// The reason for the reported status.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDeploymentOutput) SetApplicationId(v string) *GetDeploymentOutput {
	s.ApplicationId = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *GetDeploymentOutput) SetApplicationVersion(v int64) *GetDeploymentOutput {
	s.ApplicationVersion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetDeploymentOutput) SetCreationTime(v time.Time) *GetDeploymentOutput {
	s.CreationTime = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentOutput) SetDeploymentId(v string) *GetDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetDeploymentOutput) SetEnvironmentId(v string) *GetDeploymentOutput {
	s.EnvironmentId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDeploymentOutput) SetStatus(v string) *GetDeploymentOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetDeploymentOutput) SetStatusReason(v string) *GetDeploymentOutput {
	s.StatusReason = &v
	return s
}

type GetEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the runtime environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetEnvironmentInput) SetEnvironmentId(v string) *GetEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type GetEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The number of instances included in the runtime environment. A standalone
	// runtime environment has a maxiumum of one instance. Currently, a high availability
	// runtime environment has a maximum of two instances.
	ActualCapacity *int64 `locationName:"actualCapacity" min:"1" type:"integer"`

	// The timestamp when the runtime environment was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" required:"true"`

	// The description of the runtime environment.
	Description *string `locationName:"description" type:"string"`

	// The target platform for the runtime environment.
	//
	// EngineType is a required field
	EngineType *string `locationName:"engineType" type:"string" required:"true" enum:"EngineType"`

	// The version of the runtime engine.
	//
	// EngineVersion is a required field
	EngineVersion *string `locationName:"engineVersion" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the runtime environment.
	//
	// EnvironmentArn is a required field
	EnvironmentArn *string `locationName:"environmentArn" type:"string" required:"true"`

	// The unique identifier of the runtime environment.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The desired capacity of the high availability configuration for the runtime
	// environment.
	HighAvailabilityConfig *HighAvailabilityConfig `locationName:"highAvailabilityConfig" type:"structure"`

	// The type of instance underlying the runtime environment.
	//
	// InstanceType is a required field
	InstanceType *string `locationName:"instanceType" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the load balancer used with the runtime
	// environment.
	LoadBalancerArn *string `locationName:"loadBalancerArn" type:"string"`

	// The name of the runtime environment.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Indicates the pending maintenance scheduled on this environment.
	PendingMaintenance *PendingMaintenance `locationName:"pendingMaintenance" type:"structure"`

	// Configures a desired maintenance window for the environment. If you do not
	// provide a value, a random system-generated value will be assigned.
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`

	// Whether applications running in this runtime environment are publicly accessible.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The unique identifiers of the security groups assigned to this runtime environment.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list" required:"true"`

	// The status of the runtime environment.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"EnvironmentLifecycle"`

	// The reason for the reported status.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The storage configurations defined for the runtime environment.
	StorageConfigurations []*StorageConfiguration `locationName:"storageConfigurations" type:"list"`

	// The unique identifiers of the subnets assigned to this runtime environment.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`

	// The tags defined for this runtime environment.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The unique identifier for the VPC used with this runtime environment.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) GoString() string {
	return s.String()
}

// SetActualCapacity sets the ActualCapacity field's value.
func (s *GetEnvironmentOutput) SetActualCapacity(v int64) *GetEnvironmentOutput {
	s.ActualCapacity = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetEnvironmentOutput) SetCreationTime(v time.Time) *GetEnvironmentOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetEnvironmentOutput) SetDescription(v string) *GetEnvironmentOutput {
	s.Description = &v
	return s
}

// SetEngineType sets the EngineType field's value.
func (s *GetEnvironmentOutput) SetEngineType(v string) *GetEnvironmentOutput {
	s.EngineType = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *GetEnvironmentOutput) SetEngineVersion(v string) *GetEnvironmentOutput {
	s.EngineVersion = &v
	return s
}

// SetEnvironmentArn sets the EnvironmentArn field's value.
func (s *GetEnvironmentOutput) SetEnvironmentArn(v string) *GetEnvironmentOutput {
	s.EnvironmentArn = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetEnvironmentOutput) SetEnvironmentId(v string) *GetEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// SetHighAvailabilityConfig sets the HighAvailabilityConfig field's value.
func (s *GetEnvironmentOutput) SetHighAvailabilityConfig(v *HighAvailabilityConfig) *GetEnvironmentOutput {
	s.HighAvailabilityConfig = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *GetEnvironmentOutput) SetInstanceType(v string) *GetEnvironmentOutput {
	s.InstanceType = &v
	return s
}

// SetLoadBalancerArn sets the LoadBalancerArn field's value.
func (s *GetEnvironmentOutput) SetLoadBalancerArn(v string) *GetEnvironmentOutput {
	s.LoadBalancerArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEnvironmentOutput) SetName(v string) *GetEnvironmentOutput {
	s.Name = &v
	return s
}

// SetPendingMaintenance sets the PendingMaintenance field's value.
func (s *GetEnvironmentOutput) SetPendingMaintenance(v *PendingMaintenance) *GetEnvironmentOutput {
	s.PendingMaintenance = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *GetEnvironmentOutput) SetPreferredMaintenanceWindow(v string) *GetEnvironmentOutput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *GetEnvironmentOutput) SetPubliclyAccessible(v bool) *GetEnvironmentOutput {
	s.PubliclyAccessible = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *GetEnvironmentOutput) SetSecurityGroupIds(v []*string) *GetEnvironmentOutput {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetEnvironmentOutput) SetStatus(v string) *GetEnvironmentOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetEnvironmentOutput) SetStatusReason(v string) *GetEnvironmentOutput {
	s.StatusReason = &v
	return s
}

// SetStorageConfigurations sets the StorageConfigurations field's value.
func (s *GetEnvironmentOutput) SetStorageConfigurations(v []*StorageConfiguration) *GetEnvironmentOutput {
	s.StorageConfigurations = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *GetEnvironmentOutput) SetSubnetIds(v []*string) *GetEnvironmentOutput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEnvironmentOutput) SetTags(v map[string]*string) *GetEnvironmentOutput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *GetEnvironmentOutput) SetVpcId(v string) *GetEnvironmentOutput {
	s.VpcId = &v
	return s
}

// Defines the details of a high availability configuration.
type HighAvailabilityConfig struct {
	_ struct{} `type:"structure"`

	// The number of instances in a high availability configuration.
	//
	// DesiredCapacity is a required field
	DesiredCapacity *int64 `locationName:"desiredCapacity" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HighAvailabilityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HighAvailabilityConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HighAvailabilityConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HighAvailabilityConfig"}
	if s.DesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredCapacity"))
	}
	if s.DesiredCapacity != nil && *s.DesiredCapacity < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredCapacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *HighAvailabilityConfig) SetDesiredCapacity(v int64) *HighAvailabilityConfig {
	s.DesiredCapacity = &v
	return s
}

// An unexpected error occurred during the processing of the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The maximum number of application versions to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token returned from a previous call to this operation. This
	// specifies the next item to return. To return to the beginning of the list,
	// exclude this parameter.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListApplicationVersionsInput) SetApplicationId(v string) *ListApplicationVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationVersionsInput) SetMaxResults(v int64) *ListApplicationVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationVersionsInput) SetNextToken(v string) *ListApplicationVersionsInput {
	s.NextToken = &v
	return s
}

type ListApplicationVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of application versions.
	//
	// ApplicationVersions is a required field
	ApplicationVersions []*ApplicationVersionSummary `locationName:"applicationVersions" type:"list" required:"true"`

	// If there are more items to return, this contains a token that is passed to
	// a subsequent call to this operation to retrieve the next set of items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationVersionsOutput) GoString() string {
	return s.String()
}

// SetApplicationVersions sets the ApplicationVersions field's value.
func (s *ListApplicationVersionsOutput) SetApplicationVersions(v []*ApplicationVersionSummary) *ListApplicationVersionsOutput {
	s.ApplicationVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationVersionsOutput) SetNextToken(v string) *ListApplicationVersionsOutput {
	s.NextToken = &v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the runtime environment where the applications are
	// deployed.
	EnvironmentId *string `location:"querystring" locationName:"environmentId" type:"string"`

	// The maximum number of applications to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The names of the applications.
	Names []*string `location:"querystring" locationName:"names" min:"1" type:"list"`

	// A pagination token to control the number of applications displayed in the
	// list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *ListApplicationsInput) SetEnvironmentId(v string) *ListApplicationsInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNames sets the Names field's value.
func (s *ListApplicationsInput) SetNames(v []*string) *ListApplicationsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of summary details for all the applications in an environment.
	//
	// Applications is a required field
	Applications []*ApplicationSummary `locationName:"applications" type:"list" required:"true"`

	// A pagination token that's returned when the response doesn't contain all
	// applications.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*ApplicationSummary) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListBatchJobDefinitionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The maximum number of batch job definitions to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token returned from a previous call to this operation. This
	// specifies the next item to return. To return to the beginning of the list,
	// exclude this parameter.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// If the batch job definition is a FileBatchJobDefinition, the prefix allows
	// you to search on the file names of FileBatchJobDefinitions.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchJobDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchJobDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBatchJobDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBatchJobDefinitionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListBatchJobDefinitionsInput) SetApplicationId(v string) *ListBatchJobDefinitionsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBatchJobDefinitionsInput) SetMaxResults(v int64) *ListBatchJobDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchJobDefinitionsInput) SetNextToken(v string) *ListBatchJobDefinitionsInput {
	s.NextToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListBatchJobDefinitionsInput) SetPrefix(v string) *ListBatchJobDefinitionsInput {
	s.Prefix = &v
	return s
}

type ListBatchJobDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of batch job definitions.
	//
	// BatchJobDefinitions is a required field
	BatchJobDefinitions []*BatchJobDefinition `locationName:"batchJobDefinitions" type:"list" required:"true"`

	// If there are more items to return, this contains a token that is passed to
	// a subsequent call to this operation to retrieve the next set of items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchJobDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchJobDefinitionsOutput) GoString() string {
	return s.String()
}

// SetBatchJobDefinitions sets the BatchJobDefinitions field's value.
func (s *ListBatchJobDefinitionsOutput) SetBatchJobDefinitions(v []*BatchJobDefinition) *ListBatchJobDefinitionsOutput {
	s.BatchJobDefinitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchJobDefinitionsOutput) SetNextToken(v string) *ListBatchJobDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListBatchJobExecutionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The unique identifier of each batch job execution.
	ExecutionIds []*string `location:"querystring" locationName:"executionIds" min:"1" type:"list"`

	// The name of each batch job execution.
	JobName *string `location:"querystring" locationName:"jobName" type:"string"`

	// The maximum number of batch job executions to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token to control the number of batch job executions displayed
	// in the list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The time after which the batch job executions started.
	StartedAfter *time.Time `location:"querystring" locationName:"startedAfter" type:"timestamp"`

	// The time before the batch job executions started.
	StartedBefore *time.Time `location:"querystring" locationName:"startedBefore" type:"timestamp"`

	// The status of the batch job executions.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"BatchJobExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchJobExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchJobExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBatchJobExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBatchJobExecutionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ExecutionIds != nil && len(s.ExecutionIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListBatchJobExecutionsInput) SetApplicationId(v string) *ListBatchJobExecutionsInput {
	s.ApplicationId = &v
	return s
}

// SetExecutionIds sets the ExecutionIds field's value.
func (s *ListBatchJobExecutionsInput) SetExecutionIds(v []*string) *ListBatchJobExecutionsInput {
	s.ExecutionIds = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ListBatchJobExecutionsInput) SetJobName(v string) *ListBatchJobExecutionsInput {
	s.JobName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBatchJobExecutionsInput) SetMaxResults(v int64) *ListBatchJobExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchJobExecutionsInput) SetNextToken(v string) *ListBatchJobExecutionsInput {
	s.NextToken = &v
	return s
}

// SetStartedAfter sets the StartedAfter field's value.
func (s *ListBatchJobExecutionsInput) SetStartedAfter(v time.Time) *ListBatchJobExecutionsInput {
	s.StartedAfter = &v
	return s
}

// SetStartedBefore sets the StartedBefore field's value.
func (s *ListBatchJobExecutionsInput) SetStartedBefore(v time.Time) *ListBatchJobExecutionsInput {
	s.StartedBefore = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListBatchJobExecutionsInput) SetStatus(v string) *ListBatchJobExecutionsInput {
	s.Status = &v
	return s
}

type ListBatchJobExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of batch job executions for an application.
	//
	// BatchJobExecutions is a required field
	BatchJobExecutions []*BatchJobExecutionSummary `locationName:"batchJobExecutions" type:"list" required:"true"`

	// A pagination token that's returned when the response doesn't contain all
	// batch job executions.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchJobExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBatchJobExecutionsOutput) GoString() string {
	return s.String()
}

// SetBatchJobExecutions sets the BatchJobExecutions field's value.
func (s *ListBatchJobExecutionsOutput) SetBatchJobExecutions(v []*BatchJobExecutionSummary) *ListBatchJobExecutionsOutput {
	s.BatchJobExecutions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBatchJobExecutionsOutput) SetNextToken(v string) *ListBatchJobExecutionsOutput {
	s.NextToken = &v
	return s
}

type ListDataSetImportHistoryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The maximum number of objects to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token returned from a previous call to this operation. This
	// specifies the next item to return. To return to the beginning of the list,
	// exclude this parameter.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetImportHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetImportHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSetImportHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSetImportHistoryInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListDataSetImportHistoryInput) SetApplicationId(v string) *ListDataSetImportHistoryInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSetImportHistoryInput) SetMaxResults(v int64) *ListDataSetImportHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetImportHistoryInput) SetNextToken(v string) *ListDataSetImportHistoryInput {
	s.NextToken = &v
	return s
}

type ListDataSetImportHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The data set import tasks.
	//
	// DataSetImportTasks is a required field
	DataSetImportTasks []*DataSetImportTask `locationName:"dataSetImportTasks" type:"list" required:"true"`

	// If there are more items to return, this contains a token that is passed to
	// a subsequent call to this operation to retrieve the next set of items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetImportHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetImportHistoryOutput) GoString() string {
	return s.String()
}

// SetDataSetImportTasks sets the DataSetImportTasks field's value.
func (s *ListDataSetImportHistoryOutput) SetDataSetImportTasks(v []*DataSetImportTask) *ListDataSetImportHistoryOutput {
	s.DataSetImportTasks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetImportHistoryOutput) SetNextToken(v string) *ListDataSetImportHistoryOutput {
	s.NextToken = &v
	return s
}

type ListDataSetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application for which you want to list the associated
	// data sets.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The maximum number of objects to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token returned from a previous call to this operation. This
	// specifies the next item to return. To return to the beginning of the list,
	// exclude this parameter.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The prefix of the data set name, which you can use to filter the list of
	// data sets.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSetsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListDataSetsInput) SetApplicationId(v string) *ListDataSetsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSetsInput) SetMaxResults(v int64) *ListDataSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetsInput) SetNextToken(v string) *ListDataSetsInput {
	s.NextToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListDataSetsInput) SetPrefix(v string) *ListDataSetsInput {
	s.Prefix = &v
	return s
}

type ListDataSetsOutput struct {
	_ struct{} `type:"structure"`

	// The list of data sets, containing ionformation including the creating time,
	// the data set name, the data set organization, the data set format, and the
	// last time the data set was referenced or updated.
	//
	// DataSets is a required field
	DataSets []*DataSetSummary `locationName:"dataSets" type:"list" required:"true"`

	// If there are more items to return, this contains a token that is passed to
	// a subsequent call to this operation to retrieve the next set of items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSetsOutput) GoString() string {
	return s.String()
}

// SetDataSets sets the DataSets field's value.
func (s *ListDataSetsOutput) SetDataSets(v []*DataSetSummary) *ListDataSetsOutput {
	s.DataSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSetsOutput) SetNextToken(v string) *ListDataSetsOutput {
	s.NextToken = &v
	return s
}

type ListDeploymentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application identifier.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The maximum number of objects to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token returned from a previous call to this operation. This
	// specifies the next item to return. To return to the beginning of the list,
	// exclude this parameter.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListDeploymentsInput) SetApplicationId(v string) *ListDeploymentsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentsInput) SetMaxResults(v int64) *ListDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsInput) SetNextToken(v string) *ListDeploymentsInput {
	s.NextToken = &v
	return s
}

type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of deployments that is returned.
	//
	// Deployments is a required field
	Deployments []*DeploymentSummary `locationName:"deployments" type:"list" required:"true"`

	// If there are more items to return, this contains a token that is passed to
	// a subsequent call to this operation to retrieve the next set of items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *ListDeploymentsOutput) SetDeployments(v []*DeploymentSummary) *ListDeploymentsOutput {
	s.Deployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsOutput) SetNextToken(v string) *ListDeploymentsOutput {
	s.NextToken = &v
	return s
}

type ListEngineVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The type of target platform.
	EngineType *string `location:"querystring" locationName:"engineType" type:"string" enum:"EngineType"`

	// The maximum number of objects to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token returned from a previous call to this operation. This
	// specifies the next item to return. To return to the beginning of the list,
	// exclude this parameter.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngineVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEngineVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEngineVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineType sets the EngineType field's value.
func (s *ListEngineVersionsInput) SetEngineType(v string) *ListEngineVersionsInput {
	s.EngineType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEngineVersionsInput) SetMaxResults(v int64) *ListEngineVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEngineVersionsInput) SetNextToken(v string) *ListEngineVersionsInput {
	s.NextToken = &v
	return s
}

type ListEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Returns the engine versions.
	//
	// EngineVersions is a required field
	EngineVersions []*EngineVersionsSummary `locationName:"engineVersions" type:"list" required:"true"`

	// If there are more items to return, this contains a token that is passed to
	// a subsequent call to this operation to retrieve the next set of items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEngineVersionsOutput) GoString() string {
	return s.String()
}

// SetEngineVersions sets the EngineVersions field's value.
func (s *ListEngineVersionsOutput) SetEngineVersions(v []*EngineVersionsSummary) *ListEngineVersionsOutput {
	s.EngineVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEngineVersionsOutput) SetNextToken(v string) *ListEngineVersionsOutput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The engine type for the environment.
	EngineType *string `location:"querystring" locationName:"engineType" type:"string" enum:"EngineType"`

	// The maximum number of environments to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the environment.
	Names []*string `location:"querystring" locationName:"names" min:"1" type:"list"`

	// A pagination token to control the number of environments displayed in the
	// list.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineType sets the EngineType field's value.
func (s *ListEnvironmentsInput) SetEngineType(v string) *ListEnvironmentsInput {
	s.EngineType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentsInput) SetMaxResults(v int64) *ListEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNames sets the Names field's value.
func (s *ListEnvironmentsInput) SetNames(v []*string) *ListEnvironmentsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsInput) SetNextToken(v string) *ListEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of summary details for all the environments in your account.
	//
	// Environments is a required field
	Environments []*EnvironmentSummary `locationName:"environments" type:"list" required:"true"`

	// A pagination token that's returned when the response doesn't contain all
	// the environments.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *ListEnvironmentsOutput) SetEnvironments(v []*EnvironmentSummary) *ListEnvironmentsOutput {
	s.Environments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsOutput) SetNextToken(v string) *ListEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A subset of the attributes about a log group. In CloudWatch a log group is
// a group of log streams that share the same retention, monitoring, and access
// control settings.
type LogGroupSummary struct {
	_ struct{} `type:"structure"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The type of log.
	//
	// LogType is a required field
	LogType *string `locationName:"logType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogGroupSummary) GoString() string {
	return s.String()
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *LogGroupSummary) SetLogGroupName(v string) *LogGroupSummary {
	s.LogGroupName = &v
	return s
}

// SetLogType sets the LogType field's value.
func (s *LogGroupSummary) SetLogType(v string) *LogGroupSummary {
	s.LogType = &v
	return s
}

// The information about the maintenance schedule.
type MaintenanceSchedule struct {
	_ struct{} `type:"structure"`

	// The time the scheduled maintenance is to end.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The time the scheduled maintenance is to start.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaintenanceSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaintenanceSchedule) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *MaintenanceSchedule) SetEndTime(v time.Time) *MaintenanceSchedule {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MaintenanceSchedule) SetStartTime(v time.Time) *MaintenanceSchedule {
	s.StartTime = &v
	return s
}

// The scheduled maintenance for a runtime engine.
type PendingMaintenance struct {
	_ struct{} `type:"structure"`

	// The specific runtime engine that the maintenance schedule applies to.
	EngineVersion *string `locationName:"engineVersion" type:"string"`

	// The maintenance schedule for the engine version.
	Schedule *MaintenanceSchedule `locationName:"schedule" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingMaintenance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingMaintenance) GoString() string {
	return s.String()
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *PendingMaintenance) SetEngineVersion(v string) *PendingMaintenance {
	s.EngineVersion = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *PendingMaintenance) SetSchedule(v *MaintenanceSchedule) *PendingMaintenance {
	s.Schedule = v
	return s
}

// The primary key for a KSDS data set.
type PrimaryKey struct {
	_ struct{} `type:"structure"`

	// A strictly positive integer value representing the length of the primary
	// key.
	//
	// Length is a required field
	Length *int64 `locationName:"length" type:"integer" required:"true"`

	// A name for the Primary Key.
	Name *string `locationName:"name" type:"string"`

	// A positive integer value representing the offset to mark the start of the
	// primary key in the record byte array.
	//
	// Offset is a required field
	Offset *int64 `locationName:"offset" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrimaryKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrimaryKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrimaryKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrimaryKey"}
	if s.Length == nil {
		invalidParams.Add(request.NewErrParamRequired("Length"))
	}
	if s.Offset == nil {
		invalidParams.Add(request.NewErrParamRequired("Offset"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLength sets the Length field's value.
func (s *PrimaryKey) SetLength(v int64) *PrimaryKey {
	s.Length = &v
	return s
}

// SetName sets the Name field's value.
func (s *PrimaryKey) SetName(v string) *PrimaryKey {
	s.Name = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *PrimaryKey) SetOffset(v int64) *PrimaryKey {
	s.Offset = &v
	return s
}

// The length of the records in the data set.
type RecordLength struct {
	_ struct{} `type:"structure"`

	// The maximum record length. In case of fixed, both minimum and maximum are
	// the same.
	//
	// Max is a required field
	Max *int64 `locationName:"max" type:"integer" required:"true"`

	// The minimum record length of a record.
	//
	// Min is a required field
	Min *int64 `locationName:"min" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordLength) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordLength) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordLength) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordLength"}
	if s.Max == nil {
		invalidParams.Add(request.NewErrParamRequired("Max"))
	}
	if s.Min == nil {
		invalidParams.Add(request.NewErrParamRequired("Min"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMax sets the Max field's value.
func (s *RecordLength) SetMax(v int64) *RecordLength {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *RecordLength) SetMin(v int64) *RecordLength {
	s.Min = &v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the missing resource.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of the missing resource.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A batch job definition contained in a script.
type ScriptBatchJobDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the script containing the batch job definition.
	//
	// ScriptName is a required field
	ScriptName *string `locationName:"scriptName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScriptBatchJobDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScriptBatchJobDefinition) GoString() string {
	return s.String()
}

// SetScriptName sets the ScriptName field's value.
func (s *ScriptBatchJobDefinition) SetScriptName(v string) *ScriptBatchJobDefinition {
	s.ScriptName = &v
	return s
}

// A batch job identifier in which the batch job to run is identified by the
// script name.
type ScriptBatchJobIdentifier struct {
	_ struct{} `type:"structure"`

	// The name of the script containing the batch job definition.
	//
	// ScriptName is a required field
	ScriptName *string `locationName:"scriptName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScriptBatchJobIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScriptBatchJobIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScriptBatchJobIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScriptBatchJobIdentifier"}
	if s.ScriptName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScriptName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScriptName sets the ScriptName field's value.
func (s *ScriptBatchJobIdentifier) SetScriptName(v string) *ScriptBatchJobIdentifier {
	s.ScriptName = &v
	return s
}

// One or more quotas for Amazon Web Services Mainframe Modernization exceeds
// the limit.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the exceeded quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The ID of the resource that is exceeding the quota limit.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of resource that is exceeding the quota limit for Amazon Web Services
	// Mainframe Modernization.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// A code that identifies the service that the exceeded quota belongs to.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the application you want to start.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StartApplicationInput) SetApplicationId(v string) *StartApplicationInput {
	s.ApplicationId = &v
	return s
}

type StartApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationOutput) GoString() string {
	return s.String()
}

type StartBatchJobInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application associated with this batch job.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The unique identifier of the batch job.
	//
	// BatchJobIdentifier is a required field
	BatchJobIdentifier *BatchJobIdentifier `locationName:"batchJobIdentifier" type:"structure" required:"true"`

	// The collection of batch job parameters. For details about limits for keys
	// and values, see Coding variables in JCL (https://www.ibm.com/docs/en/workload-automation/9.3.0?topic=zos-coding-variables-in-jcl).
	JobParams map[string]*string `locationName:"jobParams" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartBatchJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartBatchJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartBatchJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartBatchJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.BatchJobIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchJobIdentifier"))
	}
	if s.BatchJobIdentifier != nil {
		if err := s.BatchJobIdentifier.Validate(); err != nil {
			invalidParams.AddNested("BatchJobIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StartBatchJobInput) SetApplicationId(v string) *StartBatchJobInput {
	s.ApplicationId = &v
	return s
}

// SetBatchJobIdentifier sets the BatchJobIdentifier field's value.
func (s *StartBatchJobInput) SetBatchJobIdentifier(v *BatchJobIdentifier) *StartBatchJobInput {
	s.BatchJobIdentifier = v
	return s
}

// SetJobParams sets the JobParams field's value.
func (s *StartBatchJobInput) SetJobParams(v map[string]*string) *StartBatchJobInput {
	s.JobParams = v
	return s
}

type StartBatchJobOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of this execution of the batch job.
	//
	// ExecutionId is a required field
	ExecutionId *string `locationName:"executionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartBatchJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartBatchJobOutput) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *StartBatchJobOutput) SetExecutionId(v string) *StartBatchJobOutput {
	s.ExecutionId = &v
	return s
}

type StopApplicationInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application you want to stop.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// Stopping an application process can take a long time. Setting this parameter
	// to true lets you force stop the application so you don't need to wait until
	// the process finishes to apply another action on the application. The default
	// value is false.
	ForceStop *bool `locationName:"forceStop" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StopApplicationInput) SetApplicationId(v string) *StopApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetForceStop sets the ForceStop field's value.
func (s *StopApplicationInput) SetForceStop(v bool) *StopApplicationInput {
	s.ForceStop = &v
	return s
}

type StopApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationOutput) GoString() string {
	return s.String()
}

// Defines the storage configuration for an environment.
type StorageConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the storage configuration for an Amazon EFS file system.
	Efs *EfsStorageConfiguration `locationName:"efs" type:"structure"`

	// Defines the storage configuration for an Amazon FSx file system.
	Fsx *FsxStorageConfiguration `locationName:"fsx" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageConfiguration"}
	if s.Efs != nil {
		if err := s.Efs.Validate(); err != nil {
			invalidParams.AddNested("Efs", err.(request.ErrInvalidParams))
		}
	}
	if s.Fsx != nil {
		if err := s.Fsx.Validate(); err != nil {
			invalidParams.AddNested("Fsx", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEfs sets the Efs field's value.
func (s *StorageConfiguration) SetEfs(v *EfsStorageConfiguration) *StorageConfiguration {
	s.Efs = v
	return s
}

// SetFsx sets the Fsx field's value.
func (s *StorageConfiguration) SetFsx(v *FsxStorageConfiguration) *StorageConfiguration {
	s.Fsx = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The number of requests made exceeds the limit.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the throttled reuqest.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The number of seconds to wait before retrying the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The identifier of the service that the throttled request was made to.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the application you want to update.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// The current version of the application to update.
	//
	// CurrentApplicationVersion is a required field
	CurrentApplicationVersion *int64 `locationName:"currentApplicationVersion" min:"1" type:"integer" required:"true"`

	// The application definition for this application. You can specify either inline
	// JSON or an S3 bucket location.
	Definition *Definition `locationName:"definition" type:"structure"`

	// The description of the application to update.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CurrentApplicationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersion"))
	}
	if s.CurrentApplicationVersion != nil && *s.CurrentApplicationVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersion", 1))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationInput) SetApplicationId(v string) *UpdateApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetCurrentApplicationVersion sets the CurrentApplicationVersion field's value.
func (s *UpdateApplicationInput) SetCurrentApplicationVersion(v int64) *UpdateApplicationInput {
	s.CurrentApplicationVersion = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *UpdateApplicationInput) SetDefinition(v *Definition) *UpdateApplicationInput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The new version of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *int64 `locationName:"applicationVersion" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *UpdateApplicationOutput) SetApplicationVersion(v int64) *UpdateApplicationOutput {
	s.ApplicationVersion = &v
	return s
}

type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to update the environment during the maintenance window.
	// The default is false. Currently, Amazon Web Services Mainframe Modernization
	// accepts the engineVersion parameter only if applyDuringMaintenanceWindow
	// is true. If any parameter other than engineVersion is provided in UpdateEnvironmentRequest,
	// it will fail if applyDuringMaintenanceWindow is set to true.
	ApplyDuringMaintenanceWindow *bool `locationName:"applyDuringMaintenanceWindow" type:"boolean"`

	// The desired capacity for the environment to update.
	DesiredCapacity *int64 `locationName:"desiredCapacity" min:"1" type:"integer"`

	// The version of the runtime engine for the environment.
	EngineVersion *string `locationName:"engineVersion" type:"string"`

	// The unique identifier of the runtime environment that you want to update.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"environmentId" type:"string" required:"true"`

	// The instance type for the environment to update.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// Configures a desired maintenance window for the environment. If you do not
	// provide a value, a random system-generated value will be assigned.
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.DesiredCapacity != nil && *s.DesiredCapacity < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredCapacity", 1))
	}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyDuringMaintenanceWindow sets the ApplyDuringMaintenanceWindow field's value.
func (s *UpdateEnvironmentInput) SetApplyDuringMaintenanceWindow(v bool) *UpdateEnvironmentInput {
	s.ApplyDuringMaintenanceWindow = &v
	return s
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *UpdateEnvironmentInput) SetDesiredCapacity(v int64) *UpdateEnvironmentInput {
	s.DesiredCapacity = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *UpdateEnvironmentInput) SetEngineVersion(v string) *UpdateEnvironmentInput {
	s.EngineVersion = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateEnvironmentInput) SetEnvironmentId(v string) *UpdateEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *UpdateEnvironmentInput) SetInstanceType(v string) *UpdateEnvironmentInput {
	s.InstanceType = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *UpdateEnvironmentInput) SetPreferredMaintenanceWindow(v string) *UpdateEnvironmentInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the runtime environment that was updated.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateEnvironmentOutput) SetEnvironmentId(v string) *UpdateEnvironmentOutput {
	s.EnvironmentId = &v
	return s
}

// One or more parameters provided in the request is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of fields that failed service validation.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason why it failed service validation.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a validation exception field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message of the exception field.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the exception field.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// The attributes of a VSAM type data set.
type VsamAttributes struct {
	_ struct{} `type:"structure"`

	// The alternate key definitions, if any. A legacy dataset might not have any
	// alternate key defined, but if those alternate keys definitions exist, provide
	// them as some applications will make use of them.
	AlternateKeys []*AlternateKey `locationName:"alternateKeys" type:"list"`

	// Indicates whether indexes for this dataset are stored as compressed values.
	// If you have a large data set (typically > 100 Mb), consider setting this
	// flag to True.
	Compressed *bool `locationName:"compressed" type:"boolean"`

	// The character set used by the data set. Can be ASCII, EBCDIC, or unknown.
	Encoding *string `locationName:"encoding" type:"string"`

	// The record format of the data set.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true"`

	// The primary key of the data set.
	PrimaryKey *PrimaryKey `locationName:"primaryKey" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VsamAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VsamAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VsamAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VsamAttributes"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.AlternateKeys != nil {
		for i, v := range s.AlternateKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AlternateKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PrimaryKey != nil {
		if err := s.PrimaryKey.Validate(); err != nil {
			invalidParams.AddNested("PrimaryKey", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlternateKeys sets the AlternateKeys field's value.
func (s *VsamAttributes) SetAlternateKeys(v []*AlternateKey) *VsamAttributes {
	s.AlternateKeys = v
	return s
}

// SetCompressed sets the Compressed field's value.
func (s *VsamAttributes) SetCompressed(v bool) *VsamAttributes {
	s.Compressed = &v
	return s
}

// SetEncoding sets the Encoding field's value.
func (s *VsamAttributes) SetEncoding(v string) *VsamAttributes {
	s.Encoding = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *VsamAttributes) SetFormat(v string) *VsamAttributes {
	s.Format = &v
	return s
}

// SetPrimaryKey sets the PrimaryKey field's value.
func (s *VsamAttributes) SetPrimaryKey(v *PrimaryKey) *VsamAttributes {
	s.PrimaryKey = v
	return s
}

// The attributes of a VSAM type data set.
type VsamDetailAttributes struct {
	_ struct{} `type:"structure"`

	// The alternate key definitions, if any. A legacy dataset might not have any
	// alternate key defined, but if those alternate keys definitions exist, provide
	// them as some applications will make use of them.
	AlternateKeys []*AlternateKey `locationName:"alternateKeys" type:"list"`

	// If set to True, enforces loading the data set into cache before it’s used
	// by the application.
	CacheAtStartup *bool `locationName:"cacheAtStartup" type:"boolean"`

	// Indicates whether indexes for this dataset are stored as compressed values.
	// If you have a large data set (typically > 100 Mb), consider setting this
	// flag to True.
	Compressed *bool `locationName:"compressed" type:"boolean"`

	// The character set used by the data set. Can be ASCII, EBCDIC, or unknown.
	Encoding *string `locationName:"encoding" type:"string"`

	// The primary key of the data set.
	PrimaryKey *PrimaryKey `locationName:"primaryKey" type:"structure"`

	// The record format of the data set.
	RecordFormat *string `locationName:"recordFormat" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VsamDetailAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VsamDetailAttributes) GoString() string {
	return s.String()
}

// SetAlternateKeys sets the AlternateKeys field's value.
func (s *VsamDetailAttributes) SetAlternateKeys(v []*AlternateKey) *VsamDetailAttributes {
	s.AlternateKeys = v
	return s
}

// SetCacheAtStartup sets the CacheAtStartup field's value.
func (s *VsamDetailAttributes) SetCacheAtStartup(v bool) *VsamDetailAttributes {
	s.CacheAtStartup = &v
	return s
}

// SetCompressed sets the Compressed field's value.
func (s *VsamDetailAttributes) SetCompressed(v bool) *VsamDetailAttributes {
	s.Compressed = &v
	return s
}

// SetEncoding sets the Encoding field's value.
func (s *VsamDetailAttributes) SetEncoding(v string) *VsamDetailAttributes {
	s.Encoding = &v
	return s
}

// SetPrimaryKey sets the PrimaryKey field's value.
func (s *VsamDetailAttributes) SetPrimaryKey(v *PrimaryKey) *VsamDetailAttributes {
	s.PrimaryKey = v
	return s
}

// SetRecordFormat sets the RecordFormat field's value.
func (s *VsamDetailAttributes) SetRecordFormat(v string) *VsamDetailAttributes {
	s.RecordFormat = &v
	return s
}

const (
	// ApplicationDeploymentLifecycleDeploying is a ApplicationDeploymentLifecycle enum value
	ApplicationDeploymentLifecycleDeploying = "Deploying"

	// ApplicationDeploymentLifecycleDeployed is a ApplicationDeploymentLifecycle enum value
	ApplicationDeploymentLifecycleDeployed = "Deployed"
)

// ApplicationDeploymentLifecycle_Values returns all elements of the ApplicationDeploymentLifecycle enum
func ApplicationDeploymentLifecycle_Values() []string {
	return []string{
		ApplicationDeploymentLifecycleDeploying,
		ApplicationDeploymentLifecycleDeployed,
	}
}

const (
	// ApplicationLifecycleCreating is a ApplicationLifecycle enum value
	ApplicationLifecycleCreating = "Creating"

	// ApplicationLifecycleCreated is a ApplicationLifecycle enum value
	ApplicationLifecycleCreated = "Created"

	// ApplicationLifecycleAvailable is a ApplicationLifecycle enum value
	ApplicationLifecycleAvailable = "Available"

	// ApplicationLifecycleReady is a ApplicationLifecycle enum value
	ApplicationLifecycleReady = "Ready"

	// ApplicationLifecycleStarting is a ApplicationLifecycle enum value
	ApplicationLifecycleStarting = "Starting"

	// ApplicationLifecycleRunning is a ApplicationLifecycle enum value
	ApplicationLifecycleRunning = "Running"

	// ApplicationLifecycleStopping is a ApplicationLifecycle enum value
	ApplicationLifecycleStopping = "Stopping"

	// ApplicationLifecycleStopped is a ApplicationLifecycle enum value
	ApplicationLifecycleStopped = "Stopped"

	// ApplicationLifecycleFailed is a ApplicationLifecycle enum value
	ApplicationLifecycleFailed = "Failed"

	// ApplicationLifecycleDeleting is a ApplicationLifecycle enum value
	ApplicationLifecycleDeleting = "Deleting"
)

// ApplicationLifecycle_Values returns all elements of the ApplicationLifecycle enum
func ApplicationLifecycle_Values() []string {
	return []string{
		ApplicationLifecycleCreating,
		ApplicationLifecycleCreated,
		ApplicationLifecycleAvailable,
		ApplicationLifecycleReady,
		ApplicationLifecycleStarting,
		ApplicationLifecycleRunning,
		ApplicationLifecycleStopping,
		ApplicationLifecycleStopped,
		ApplicationLifecycleFailed,
		ApplicationLifecycleDeleting,
	}
}

const (
	// ApplicationVersionLifecycleCreating is a ApplicationVersionLifecycle enum value
	ApplicationVersionLifecycleCreating = "Creating"

	// ApplicationVersionLifecycleAvailable is a ApplicationVersionLifecycle enum value
	ApplicationVersionLifecycleAvailable = "Available"

	// ApplicationVersionLifecycleFailed is a ApplicationVersionLifecycle enum value
	ApplicationVersionLifecycleFailed = "Failed"
)

// ApplicationVersionLifecycle_Values returns all elements of the ApplicationVersionLifecycle enum
func ApplicationVersionLifecycle_Values() []string {
	return []string{
		ApplicationVersionLifecycleCreating,
		ApplicationVersionLifecycleAvailable,
		ApplicationVersionLifecycleFailed,
	}
}

const (
	// BatchJobExecutionStatusSubmitting is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusSubmitting = "Submitting"

	// BatchJobExecutionStatusHolding is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusHolding = "Holding"

	// BatchJobExecutionStatusDispatching is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusDispatching = "Dispatching"

	// BatchJobExecutionStatusRunning is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusRunning = "Running"

	// BatchJobExecutionStatusCancelling is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusCancelling = "Cancelling"

	// BatchJobExecutionStatusCancelled is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusCancelled = "Cancelled"

	// BatchJobExecutionStatusSucceeded is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusSucceeded = "Succeeded"

	// BatchJobExecutionStatusFailed is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusFailed = "Failed"

	// BatchJobExecutionStatusSucceededWithWarning is a BatchJobExecutionStatus enum value
	BatchJobExecutionStatusSucceededWithWarning = "Succeeded With Warning"
)

// BatchJobExecutionStatus_Values returns all elements of the BatchJobExecutionStatus enum
func BatchJobExecutionStatus_Values() []string {
	return []string{
		BatchJobExecutionStatusSubmitting,
		BatchJobExecutionStatusHolding,
		BatchJobExecutionStatusDispatching,
		BatchJobExecutionStatusRunning,
		BatchJobExecutionStatusCancelling,
		BatchJobExecutionStatusCancelled,
		BatchJobExecutionStatusSucceeded,
		BatchJobExecutionStatusFailed,
		BatchJobExecutionStatusSucceededWithWarning,
	}
}

const (
	// BatchJobTypeVse is a BatchJobType enum value
	BatchJobTypeVse = "VSE"

	// BatchJobTypeJes2 is a BatchJobType enum value
	BatchJobTypeJes2 = "JES2"

	// BatchJobTypeJes3 is a BatchJobType enum value
	BatchJobTypeJes3 = "JES3"
)

// BatchJobType_Values returns all elements of the BatchJobType enum
func BatchJobType_Values() []string {
	return []string{
		BatchJobTypeVse,
		BatchJobTypeJes2,
		BatchJobTypeJes3,
	}
}

const (
	// DataSetTaskLifecycleCreating is a DataSetTaskLifecycle enum value
	DataSetTaskLifecycleCreating = "Creating"

	// DataSetTaskLifecycleRunning is a DataSetTaskLifecycle enum value
	DataSetTaskLifecycleRunning = "Running"

	// DataSetTaskLifecycleCompleted is a DataSetTaskLifecycle enum value
	DataSetTaskLifecycleCompleted = "Completed"
)

// DataSetTaskLifecycle_Values returns all elements of the DataSetTaskLifecycle enum
func DataSetTaskLifecycle_Values() []string {
	return []string{
		DataSetTaskLifecycleCreating,
		DataSetTaskLifecycleRunning,
		DataSetTaskLifecycleCompleted,
	}
}

const (
	// DeploymentLifecycleDeploying is a DeploymentLifecycle enum value
	DeploymentLifecycleDeploying = "Deploying"

	// DeploymentLifecycleSucceeded is a DeploymentLifecycle enum value
	DeploymentLifecycleSucceeded = "Succeeded"

	// DeploymentLifecycleFailed is a DeploymentLifecycle enum value
	DeploymentLifecycleFailed = "Failed"
)

// DeploymentLifecycle_Values returns all elements of the DeploymentLifecycle enum
func DeploymentLifecycle_Values() []string {
	return []string{
		DeploymentLifecycleDeploying,
		DeploymentLifecycleSucceeded,
		DeploymentLifecycleFailed,
	}
}

const (
	// EngineTypeMicrofocus is a EngineType enum value
	EngineTypeMicrofocus = "microfocus"

	// EngineTypeBluage is a EngineType enum value
	EngineTypeBluage = "bluage"
)

// EngineType_Values returns all elements of the EngineType enum
func EngineType_Values() []string {
	return []string{
		EngineTypeMicrofocus,
		EngineTypeBluage,
	}
}

const (
	// EnvironmentLifecycleCreating is a EnvironmentLifecycle enum value
	EnvironmentLifecycleCreating = "Creating"

	// EnvironmentLifecycleAvailable is a EnvironmentLifecycle enum value
	EnvironmentLifecycleAvailable = "Available"

	// EnvironmentLifecycleDeleting is a EnvironmentLifecycle enum value
	EnvironmentLifecycleDeleting = "Deleting"

	// EnvironmentLifecycleFailed is a EnvironmentLifecycle enum value
	EnvironmentLifecycleFailed = "Failed"
)

// EnvironmentLifecycle_Values returns all elements of the EnvironmentLifecycle enum
func EnvironmentLifecycle_Values() []string {
	return []string{
		EnvironmentLifecycleCreating,
		EnvironmentLifecycleAvailable,
		EnvironmentLifecycleDeleting,
		EnvironmentLifecycleFailed,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
