package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCategories invokes the webplus.DescribeCategories API synchronously
// api document: https://help.aliyun.com/api/webplus/describecategories.html
func (client *Client) DescribeCategories(request *DescribeCategoriesRequest) (response *DescribeCategoriesResponse, err error) {
	response = CreateDescribeCategoriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCategoriesWithChan invokes the webplus.DescribeCategories API asynchronously
// api document: https://help.aliyun.com/api/webplus/describecategories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCategoriesWithChan(request *DescribeCategoriesRequest) (<-chan *DescribeCategoriesResponse, <-chan error) {
	responseChan := make(chan *DescribeCategoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCategories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCategoriesWithCallback invokes the webplus.DescribeCategories API asynchronously
// api document: https://help.aliyun.com/api/webplus/describecategories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCategoriesWithCallback(request *DescribeCategoriesRequest, callback func(response *DescribeCategoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCategoriesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCategories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCategoriesRequest is the request struct for api DescribeCategories
type DescribeCategoriesRequest struct {
	*requests.RoaRequest
}

// DescribeCategoriesResponse is the response struct for api DescribeCategories
type DescribeCategoriesResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	Categories Categories `json:"Categories" xml:"Categories"`
}

// CreateDescribeCategoriesRequest creates a request to invoke DescribeCategories API
func CreateDescribeCategoriesRequest() (request *DescribeCategoriesRequest) {
	request = &DescribeCategoriesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeCategories", "/pop/v1/wam/category", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeCategoriesResponse creates a response to parse from DescribeCategories response
func CreateDescribeCategoriesResponse() (response *DescribeCategoriesResponse) {
	response = &DescribeCategoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
