package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyParentPlatform invokes the vs.ModifyParentPlatform API synchronously
func (client *Client) ModifyParentPlatform(request *ModifyParentPlatformRequest) (response *ModifyParentPlatformResponse, err error) {
	response = CreateModifyParentPlatformResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyParentPlatformWithChan invokes the vs.ModifyParentPlatform API asynchronously
func (client *Client) ModifyParentPlatformWithChan(request *ModifyParentPlatformRequest) (<-chan *ModifyParentPlatformResponse, <-chan error) {
	responseChan := make(chan *ModifyParentPlatformResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyParentPlatform(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyParentPlatformWithCallback invokes the vs.ModifyParentPlatform API asynchronously
func (client *Client) ModifyParentPlatformWithCallback(request *ModifyParentPlatformRequest, callback func(response *ModifyParentPlatformResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyParentPlatformResponse
		var err error
		defer close(result)
		response, err = client.ModifyParentPlatform(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyParentPlatformRequest is the request struct for api ModifyParentPlatform
type ModifyParentPlatformRequest struct {
	*requests.RpcRequest
	GbId           string           `position:"Query" name:"GbId"`
	ClientAuth     requests.Boolean `position:"Query" name:"ClientAuth"`
	Description    string           `position:"Query" name:"Description"`
	AutoStart      requests.Boolean `position:"Query" name:"AutoStart"`
	Id             string           `position:"Query" name:"Id"`
	ClientPassword string           `position:"Query" name:"ClientPassword"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	Ip             string           `position:"Query" name:"Ip"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Port           requests.Integer `position:"Query" name:"Port"`
	Name           string           `position:"Query" name:"Name"`
	ClientUsername string           `position:"Query" name:"ClientUsername"`
}

// ModifyParentPlatformResponse is the response struct for api ModifyParentPlatform
type ModifyParentPlatformResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateModifyParentPlatformRequest creates a request to invoke ModifyParentPlatform API
func CreateModifyParentPlatformRequest() (request *ModifyParentPlatformRequest) {
	request = &ModifyParentPlatformRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "ModifyParentPlatform", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyParentPlatformResponse creates a response to parse from ModifyParentPlatform response
func CreateModifyParentPlatformResponse() (response *ModifyParentPlatformResponse) {
	response = &ModifyParentPlatformResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
