package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddRenderingDeviceInternetPorts invokes the vs.AddRenderingDeviceInternetPorts API synchronously
func (client *Client) AddRenderingDeviceInternetPorts(request *AddRenderingDeviceInternetPortsRequest) (response *AddRenderingDeviceInternetPortsResponse, err error) {
	response = CreateAddRenderingDeviceInternetPortsResponse()
	err = client.DoAction(request, response)
	return
}

// AddRenderingDeviceInternetPortsWithChan invokes the vs.AddRenderingDeviceInternetPorts API asynchronously
func (client *Client) AddRenderingDeviceInternetPortsWithChan(request *AddRenderingDeviceInternetPortsRequest) (<-chan *AddRenderingDeviceInternetPortsResponse, <-chan error) {
	responseChan := make(chan *AddRenderingDeviceInternetPortsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddRenderingDeviceInternetPorts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddRenderingDeviceInternetPortsWithCallback invokes the vs.AddRenderingDeviceInternetPorts API asynchronously
func (client *Client) AddRenderingDeviceInternetPortsWithCallback(request *AddRenderingDeviceInternetPortsRequest, callback func(response *AddRenderingDeviceInternetPortsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddRenderingDeviceInternetPortsResponse
		var err error
		defer close(result)
		response, err = client.AddRenderingDeviceInternetPorts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddRenderingDeviceInternetPortsRequest is the request struct for api AddRenderingDeviceInternetPorts
type AddRenderingDeviceInternetPortsRequest struct {
	*requests.RpcRequest
	ISP          string           `position:"Query" name:"ISP"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	IpProtocol   string           `position:"Query" name:"IpProtocol"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	InstanceIds  string           `position:"Query" name:"InstanceIds"`
	InternalPort string           `position:"Query" name:"InternalPort"`
}

// AddRenderingDeviceInternetPortsResponse is the response struct for api AddRenderingDeviceInternetPorts
type AddRenderingDeviceInternetPortsResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	InstanceIds []string `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateAddRenderingDeviceInternetPortsRequest creates a request to invoke AddRenderingDeviceInternetPorts API
func CreateAddRenderingDeviceInternetPortsRequest() (request *AddRenderingDeviceInternetPortsRequest) {
	request = &AddRenderingDeviceInternetPortsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "AddRenderingDeviceInternetPorts", "", "")
	request.Method = requests.POST
	return
}

// CreateAddRenderingDeviceInternetPortsResponse creates a response to parse from AddRenderingDeviceInternetPorts response
func CreateAddRenderingDeviceInternetPortsResponse() (response *AddRenderingDeviceInternetPortsResponse) {
	response = &AddRenderingDeviceInternetPortsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
