package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFullNatEntry invokes the vpc.DeleteFullNatEntry API synchronously
func (client *Client) DeleteFullNatEntry(request *DeleteFullNatEntryRequest) (response *DeleteFullNatEntryResponse, err error) {
	response = CreateDeleteFullNatEntryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFullNatEntryWithChan invokes the vpc.DeleteFullNatEntry API asynchronously
func (client *Client) DeleteFullNatEntryWithChan(request *DeleteFullNatEntryRequest) (<-chan *DeleteFullNatEntryResponse, <-chan error) {
	responseChan := make(chan *DeleteFullNatEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFullNatEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFullNatEntryWithCallback invokes the vpc.DeleteFullNatEntry API asynchronously
func (client *Client) DeleteFullNatEntryWithCallback(request *DeleteFullNatEntryRequest, callback func(response *DeleteFullNatEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFullNatEntryResponse
		var err error
		defer close(result)
		response, err = client.DeleteFullNatEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFullNatEntryRequest is the request struct for api DeleteFullNatEntry
type DeleteFullNatEntryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	FullNatEntryId       string           `position:"Query" name:"FullNatEntryId"`
	FullNatTableId       string           `position:"Query" name:"FullNatTableId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteFullNatEntryResponse is the response struct for api DeleteFullNatEntry
type DeleteFullNatEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFullNatEntryRequest creates a request to invoke DeleteFullNatEntry API
func CreateDeleteFullNatEntryRequest() (request *DeleteFullNatEntryRequest) {
	request = &DeleteFullNatEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteFullNatEntry", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFullNatEntryResponse creates a response to parse from DeleteFullNatEntry response
func CreateDeleteFullNatEntryResponse() (response *DeleteFullNatEntryResponse) {
	response = &DeleteFullNatEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
