package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferCallToAgent invokes the scsp.TransferCallToAgent API synchronously
func (client *Client) TransferCallToAgent(request *TransferCallToAgentRequest) (response *TransferCallToAgentResponse, err error) {
	response = CreateTransferCallToAgentResponse()
	err = client.DoAction(request, response)
	return
}

// TransferCallToAgentWithChan invokes the scsp.TransferCallToAgent API asynchronously
func (client *Client) TransferCallToAgentWithChan(request *TransferCallToAgentRequest) (<-chan *TransferCallToAgentResponse, <-chan error) {
	responseChan := make(chan *TransferCallToAgentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferCallToAgent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferCallToAgentWithCallback invokes the scsp.TransferCallToAgent API asynchronously
func (client *Client) TransferCallToAgentWithCallback(request *TransferCallToAgentRequest, callback func(response *TransferCallToAgentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferCallToAgentResponse
		var err error
		defer close(result)
		response, err = client.TransferCallToAgent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferCallToAgentRequest is the request struct for api TransferCallToAgent
type TransferCallToAgentRequest struct {
	*requests.RpcRequest
	ClientToken       string           `position:"Body"`
	InstanceId        string           `position:"Body"`
	AccountName       string           `position:"Body"`
	TargetAccountName string           `position:"Body"`
	CallId            string           `position:"Body"`
	JobId             string           `position:"Body"`
	ConnectionId      string           `position:"Body"`
	HoldConnectionId  string           `position:"Body"`
	Type              requests.Integer `position:"Body"`
	IsSingleTransfer  string           `position:"Body"`
}

// TransferCallToAgentResponse is the response struct for api TransferCallToAgent
type TransferCallToAgentResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateTransferCallToAgentRequest creates a request to invoke TransferCallToAgent API
func CreateTransferCallToAgentRequest() (request *TransferCallToAgentRequest) {
	request = &TransferCallToAgentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "TransferCallToAgent", "", "")
	request.Method = requests.POST
	return
}

// CreateTransferCallToAgentResponse creates a response to parse from TransferCallToAgent response
func CreateTransferCallToAgentResponse() (response *TransferCallToAgentResponse) {
	response = &TransferCallToAgentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
