package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceBySQL invokes the iot.QueryDeviceBySQL API synchronously
func (client *Client) QueryDeviceBySQL(request *QueryDeviceBySQLRequest) (response *QueryDeviceBySQLResponse, err error) {
	response = CreateQueryDeviceBySQLResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceBySQLWithChan invokes the iot.QueryDeviceBySQL API asynchronously
func (client *Client) QueryDeviceBySQLWithChan(request *QueryDeviceBySQLRequest) (<-chan *QueryDeviceBySQLResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceBySQLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceBySQL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceBySQLWithCallback invokes the iot.QueryDeviceBySQL API asynchronously
func (client *Client) QueryDeviceBySQLWithCallback(request *QueryDeviceBySQLRequest, callback func(response *QueryDeviceBySQLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceBySQLResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceBySQL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceBySQLRequest is the request struct for api QueryDeviceBySQL
type QueryDeviceBySQLRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	SQL               string `position:"Query" name:"SQL"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
}

// QueryDeviceBySQLResponse is the response struct for api QueryDeviceBySQL
type QueryDeviceBySQLResponse struct {
	*responses.BaseResponse
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	Success      bool                     `json:"Success" xml:"Success"`
	Code         string                   `json:"Code" xml:"Code"`
	ErrorMessage string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	TotalCount   int64                    `json:"TotalCount" xml:"TotalCount"`
	Data         []SimpleDeviceSearchInfo `json:"Data" xml:"Data"`
}

// CreateQueryDeviceBySQLRequest creates a request to invoke QueryDeviceBySQL API
func CreateQueryDeviceBySQLRequest() (request *QueryDeviceBySQLRequest) {
	request = &QueryDeviceBySQLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceBySQL", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceBySQLResponse creates a response to parse from QueryDeviceBySQL response
func CreateQueryDeviceBySQLResponse() (response *QueryDeviceBySQLResponse) {
	response = &QueryDeviceBySQLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
