package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVideo invokes the imm.GetVideo API synchronously
func (client *Client) GetVideo(request *GetVideoRequest) (response *GetVideoResponse, err error) {
	response = CreateGetVideoResponse()
	err = client.DoAction(request, response)
	return
}

// GetVideoWithChan invokes the imm.GetVideo API asynchronously
func (client *Client) GetVideoWithChan(request *GetVideoRequest) (<-chan *GetVideoResponse, <-chan error) {
	responseChan := make(chan *GetVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVideoWithCallback invokes the imm.GetVideo API asynchronously
func (client *Client) GetVideoWithCallback(request *GetVideoRequest, callback func(response *GetVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVideoResponse
		var err error
		defer close(result)
		response, err = client.GetVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVideoRequest is the request struct for api GetVideo
type GetVideoRequest struct {
	*requests.RpcRequest
	Project  string `position:"Query" name:"Project"`
	VideoUri string `position:"Query" name:"VideoUri"`
	SetId    string `position:"Query" name:"SetId"`
}

// GetVideoResponse is the response struct for api GetVideo
type GetVideoResponse struct {
	*responses.BaseResponse
	ModifyTime               string          `json:"ModifyTime" xml:"ModifyTime"`
	ProcessStatus            string          `json:"ProcessStatus" xml:"ProcessStatus"`
	VideoWidth               int             `json:"VideoWidth" xml:"VideoWidth"`
	SourceType               string          `json:"SourceType" xml:"SourceType"`
	SourceUri                string          `json:"SourceUri" xml:"SourceUri"`
	VideoInfo                string          `json:"VideoInfo" xml:"VideoInfo"`
	VideoFrameTagsModifyTime string          `json:"VideoFrameTagsModifyTime" xml:"VideoFrameTagsModifyTime"`
	RemarksA                 string          `json:"RemarksA" xml:"RemarksA"`
	VideoFacesFailReason     string          `json:"VideoFacesFailReason" xml:"VideoFacesFailReason"`
	RemarksB                 string          `json:"RemarksB" xml:"RemarksB"`
	VideoFacesStatus         string          `json:"VideoFacesStatus" xml:"VideoFacesStatus"`
	RemarksC                 string          `json:"RemarksC" xml:"RemarksC"`
	VideoOCRModifyTime       string          `json:"VideoOCRModifyTime" xml:"VideoOCRModifyTime"`
	RemarksD                 string          `json:"RemarksD" xml:"RemarksD"`
	VideoHeight              int             `json:"VideoHeight" xml:"VideoHeight"`
	SourcePosition           string          `json:"SourcePosition" xml:"SourcePosition"`
	VideoOCRFailReason       string          `json:"VideoOCRFailReason" xml:"VideoOCRFailReason"`
	VideoFrameTagsStatus     string          `json:"VideoFrameTagsStatus" xml:"VideoFrameTagsStatus"`
	VideoTagsFailReason      string          `json:"VideoTagsFailReason" xml:"VideoTagsFailReason"`
	VideoTagsModifyTime      string          `json:"VideoTagsModifyTime" xml:"VideoTagsModifyTime"`
	VideoOCRStatus           string          `json:"VideoOCRStatus" xml:"VideoOCRStatus"`
	VideoFrames              int             `json:"VideoFrames" xml:"VideoFrames"`
	RequestId                string          `json:"RequestId" xml:"RequestId"`
	ProcessModifyTime        string          `json:"ProcessModifyTime" xml:"ProcessModifyTime"`
	VideoSTTModifyTime       string          `json:"VideoSTTModifyTime" xml:"VideoSTTModifyTime"`
	ProcessFailReason        string          `json:"ProcessFailReason" xml:"ProcessFailReason"`
	CreateTime               string          `json:"CreateTime" xml:"CreateTime"`
	ExternalId               string          `json:"ExternalId" xml:"ExternalId"`
	VideoSTTFailReason       string          `json:"VideoSTTFailReason" xml:"VideoSTTFailReason"`
	VideoUri                 string          `json:"VideoUri" xml:"VideoUri"`
	VideoFrameTagsFailReason string          `json:"VideoFrameTagsFailReason" xml:"VideoFrameTagsFailReason"`
	VideoFormat              string          `json:"VideoFormat" xml:"VideoFormat"`
	VideoSTTStatus           string          `json:"VideoSTTStatus" xml:"VideoSTTStatus"`
	VideoFacesModifyTime     string          `json:"VideoFacesModifyTime" xml:"VideoFacesModifyTime"`
	CelebrityModifyTime      string          `json:"CelebrityModifyTime" xml:"CelebrityModifyTime"`
	VideoDuration            float64         `json:"VideoDuration" xml:"VideoDuration"`
	CelebrityFailReason      string          `json:"CelebrityFailReason" xml:"CelebrityFailReason"`
	SetId                    string          `json:"SetId" xml:"SetId"`
	CelebrityStatus          string          `json:"CelebrityStatus" xml:"CelebrityStatus"`
	VideoTagsStatus          string          `json:"VideoTagsStatus" xml:"VideoTagsStatus"`
	FileSize                 int             `json:"FileSize" xml:"FileSize"`
	Persons                  []PersonsItem   `json:"Persons" xml:"Persons"`
	Celebrity                []CelebrityItem `json:"Celebrity" xml:"Celebrity"`
	VideoTags                []VideoTagsItem `json:"VideoTags" xml:"VideoTags"`
}

// CreateGetVideoRequest creates a request to invoke GetVideo API
func CreateGetVideoRequest() (request *GetVideoRequest) {
	request = &GetVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "GetVideo", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVideoResponse creates a response to parse from GetVideo response
func CreateGetVideoResponse() (response *GetVideoResponse) {
	response = &GetVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
