package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySubscription invokes the dts.ModifySubscription API synchronously
func (client *Client) ModifySubscription(request *ModifySubscriptionRequest) (response *ModifySubscriptionResponse, err error) {
	response = CreateModifySubscriptionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySubscriptionWithChan invokes the dts.ModifySubscription API asynchronously
func (client *Client) ModifySubscriptionWithChan(request *ModifySubscriptionRequest) (<-chan *ModifySubscriptionResponse, <-chan error) {
	responseChan := make(chan *ModifySubscriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySubscription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySubscriptionWithCallback invokes the dts.ModifySubscription API asynchronously
func (client *Client) ModifySubscriptionWithCallback(request *ModifySubscriptionRequest, callback func(response *ModifySubscriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySubscriptionResponse
		var err error
		defer close(result)
		response, err = client.ModifySubscription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySubscriptionRequest is the request struct for api ModifySubscription
type ModifySubscriptionRequest struct {
	*requests.RpcRequest
	DbList                  string           `position:"Query" name:"DbList"`
	SubscriptionDataTypeDDL requests.Boolean `position:"Query" name:"SubscriptionDataTypeDDL"`
	SubscriptionDataTypeDML requests.Boolean `position:"Query" name:"SubscriptionDataTypeDML"`
	DtsJobId                string           `position:"Query" name:"DtsJobId"`
	DtsInstanceId           string           `position:"Query" name:"DtsInstanceId"`
}

// ModifySubscriptionResponse is the response struct for api ModifySubscription
type ModifySubscriptionResponse struct {
	*responses.BaseResponse
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        string `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateModifySubscriptionRequest creates a request to invoke ModifySubscription API
func CreateModifySubscriptionRequest() (request *ModifySubscriptionRequest) {
	request = &ModifySubscriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ModifySubscription", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySubscriptionResponse creates a response to parse from ModifySubscription response
func CreateModifySubscriptionResponse() (response *ModifySubscriptionResponse) {
	response = &ModifySubscriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
