package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSlsEmptyCount invokes the ddoscoo.DescribeSlsEmptyCount API synchronously
func (client *Client) DescribeSlsEmptyCount(request *DescribeSlsEmptyCountRequest) (response *DescribeSlsEmptyCountResponse, err error) {
	response = CreateDescribeSlsEmptyCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSlsEmptyCountWithChan invokes the ddoscoo.DescribeSlsEmptyCount API asynchronously
func (client *Client) DescribeSlsEmptyCountWithChan(request *DescribeSlsEmptyCountRequest) (<-chan *DescribeSlsEmptyCountResponse, <-chan error) {
	responseChan := make(chan *DescribeSlsEmptyCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSlsEmptyCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSlsEmptyCountWithCallback invokes the ddoscoo.DescribeSlsEmptyCount API asynchronously
func (client *Client) DescribeSlsEmptyCountWithCallback(request *DescribeSlsEmptyCountRequest, callback func(response *DescribeSlsEmptyCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSlsEmptyCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeSlsEmptyCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSlsEmptyCountRequest is the request struct for api DescribeSlsEmptyCount
type DescribeSlsEmptyCountRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Lang            string `position:"Query" name:"Lang"`
}

// DescribeSlsEmptyCountResponse is the response struct for api DescribeSlsEmptyCount
type DescribeSlsEmptyCountResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	AvailableCount int    `json:"AvailableCount" xml:"AvailableCount"`
}

// CreateDescribeSlsEmptyCountRequest creates a request to invoke DescribeSlsEmptyCount API
func CreateDescribeSlsEmptyCountRequest() (request *DescribeSlsEmptyCountRequest) {
	request = &DescribeSlsEmptyCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeSlsEmptyCount", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSlsEmptyCountResponse creates a response to parse from DescribeSlsEmptyCount response
func CreateDescribeSlsEmptyCountResponse() (response *DescribeSlsEmptyCountResponse) {
	response = &DescribeSlsEmptyCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
