package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConnectionMeta invokes the dataworks_public.GetConnectionMeta API synchronously
func (client *Client) GetConnectionMeta(request *GetConnectionMetaRequest) (response *GetConnectionMetaResponse, err error) {
	response = CreateGetConnectionMetaResponse()
	err = client.DoAction(request, response)
	return
}

// GetConnectionMetaWithChan invokes the dataworks_public.GetConnectionMeta API asynchronously
func (client *Client) GetConnectionMetaWithChan(request *GetConnectionMetaRequest) (<-chan *GetConnectionMetaResponse, <-chan error) {
	responseChan := make(chan *GetConnectionMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConnectionMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConnectionMetaWithCallback invokes the dataworks_public.GetConnectionMeta API asynchronously
func (client *Client) GetConnectionMetaWithCallback(request *GetConnectionMetaRequest, callback func(response *GetConnectionMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConnectionMetaResponse
		var err error
		defer close(result)
		response, err = client.GetConnectionMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConnectionMetaRequest is the request struct for api GetConnectionMeta
type GetConnectionMetaRequest struct {
	*requests.RpcRequest
	DatasourceName string           `position:"Query" name:"DatasourceName"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	EnvType        string           `position:"Query" name:"EnvType"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
}

// GetConnectionMetaResponse is the response struct for api GetConnectionMeta
type GetConnectionMetaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetConnectionMetaRequest creates a request to invoke GetConnectionMeta API
func CreateGetConnectionMetaRequest() (request *GetConnectionMetaRequest) {
	request = &GetConnectionMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetConnectionMeta", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConnectionMetaResponse creates a response to parse from GetConnectionMeta response
func CreateGetConnectionMetaResponse() (response *GetConnectionMetaResponse) {
	response = &GetConnectionMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
