package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActiveFlowLog invokes the cbn.ActiveFlowLog API synchronously
func (client *Client) ActiveFlowLog(request *ActiveFlowLogRequest) (response *ActiveFlowLogResponse, err error) {
	response = CreateActiveFlowLogResponse()
	err = client.DoAction(request, response)
	return
}

// ActiveFlowLogWithChan invokes the cbn.ActiveFlowLog API asynchronously
func (client *Client) ActiveFlowLogWithChan(request *ActiveFlowLogRequest) (<-chan *ActiveFlowLogResponse, <-chan error) {
	responseChan := make(chan *ActiveFlowLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActiveFlowLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActiveFlowLogWithCallback invokes the cbn.ActiveFlowLog API asynchronously
func (client *Client) ActiveFlowLogWithCallback(request *ActiveFlowLogRequest, callback func(response *ActiveFlowLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActiveFlowLogResponse
		var err error
		defer close(result)
		response, err = client.ActiveFlowLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActiveFlowLogRequest is the request struct for api ActiveFlowLog
type ActiveFlowLogRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	CenId                string           `position:"Query" name:"CenId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	FlowLogId            string           `position:"Query" name:"FlowLogId"`
}

// ActiveFlowLogResponse is the response struct for api ActiveFlowLog
type ActiveFlowLogResponse struct {
	*responses.BaseResponse
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateActiveFlowLogRequest creates a request to invoke ActiveFlowLog API
func CreateActiveFlowLogRequest() (request *ActiveFlowLogRequest) {
	request = &ActiveFlowLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ActiveFlowLog", "", "")
	request.Method = requests.POST
	return
}

// CreateActiveFlowLogResponse creates a response to parse from ActiveFlowLog response
func CreateActiveFlowLogResponse() (response *ActiveFlowLogResponse) {
	response = &ActiveFlowLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
