package io

import (
	"io"

	"github.com/clbanning/mxj/v2"
)

func init() {
	registerInputHandler("xml", func() InputHandler { return &XMLInputHandler{} })
}

// Declare conformance with InputHandler interface.
var _ InputHandler = &XMLInputHandler{}

// XMLInputHandler handles parsing XML data.
type XMLInputHandler struct{}

// Name implements InputHandler.Name().
func (x *XMLInputHandler) Name() string {
	return "xml"
}

// Parse implements InputHandler.Parse().
func (x *XMLInputHandler) Parse(reader io.Reader) (interface{}, error) {
	inputBytes, err := io.ReadAll(reader)
	if err != nil {
		return nil, err
	}

	parsed, err := mxj.NewMapXml(inputBytes)
	if err != nil {
		return nil, err
	}

	return parsed, nil
}

// SetOption implements InputHandler.SetOption().
func (x *XMLInputHandler) SetOption(name string, value string) error {
	// The XML handler does not have any options.
	return nil
}
