package io

import (
	"bufio"
	"io"

	"github.com/komkom/jsonc/jsonc"
)

func init() {
	registerInputHandler("jsonc", func() InputHandler { return &JSONCInputHandler{} })
}

// Declare conformance with InputHandler interface.
var _ InputHandler = &JSONCInputHandler{}

// JSONCInputHandler handles parsing JSONC data.
type JSONCInputHandler struct{}

// Name implements InputHandler.Name().
func (j *JSONCInputHandler) Name() string {
	return "jsonc"
}

// Parse implements InputHandler.Parse().
func (j *JSONCInputHandler) Parse(reader io.Reader) (interface{}, error) {
	dec, _ := jsonc.NewDecoder(bufio.NewReader(reader))

	var out interface{}

	err := dec.Decode(&out)

	if err != nil {
		return nil, err
	}

	return out, nil
}

// SetOption implements InputHandler.SetOption().
func (j *JSONCInputHandler) SetOption(name string, value string) error {
	// The JSONC handler does not have any options.
	return nil
}
