package io

import (
	"io"

	"github.com/subosito/gotenv"
)

func init() {
	registerInputHandler("dotenv", func() InputHandler { return &DotEnvInputHandler{} })
}

// Declare conformance with InputHandler interface.
var _ InputHandler = &DotEnvInputHandler{}

// DotEnvInputHandler handles parsing DotEnv data.
type DotEnvInputHandler struct{}

// Name implements InputHandler.Name().
func (j *DotEnvInputHandler) Name() string {
	return "dotenv"
}

// Parse implements InputHandler.Parse().
func (j *DotEnvInputHandler) Parse(reader io.Reader) (interface{}, error) {
	inputBytes, err := io.ReadAll(reader)
	if err != nil {
		return nil, err
	}

	env, err := gotenv.Unmarshal(string(inputBytes))
	if err != nil {
		return nil, err
	}

	return map[string]string(env), nil
}

// SetOption implements InputHandler.SetOption().
func (j *DotEnvInputHandler) SetOption(name string, value string) error {
	// The DotEnv handler does not have any options.
	return nil
}
