<!-- vim: set nocp ft=markdown ts=2 sw=2 ai cc=80 et nolist wrap lbr :-->
<!-- SPDX-License-Identifier: FSFAP -->
<!-- scspell-id: 234ac36d-f778-11ec-8863-80ee73e9b8e7 -->
<!-- Copyright (c) 2006-2023 The DPS8M Development Team
     Copying and distribution of this file, with or without modification,
     are permitted in any medium without royalty provided the copyright
     notice and this notice are preserved.  This file is offered "AS-IS",
     without any warranty. -->

# DPS8M Simulator

[![Website](https://img.shields.io/website?up_message=online&url=https%3A%2F%2Fdps8m.gitlab.io)](https://dps8m.gitlab.io/)
&nbsp;
[![Pipelines](https://gitlab.com/dps8m/dps8m/badges/master/pipeline.svg?ignore_skipped=true)](https://gitlab.com/dps8m/dps8m/pipelines/latest/)
&nbsp;
[![Best Practices](https://bestpractices.coreinfrastructure.org/projects/6229/badge.svg)](https://bestpractices.coreinfrastructure.org/en/projects/6229)
&nbsp;
[![Coverity Scan](https://img.shields.io/coverity/scan/27403.svg)](https://scan.coverity.com/projects/dps8m-simulator)
&nbsp;
[![OpenHub](https://img.shields.io/badge/openhub-dps8m-ok.svg)](https://www.openhub.net/p/dps8m/)
&nbsp;

 - **DPS8M** is a simulator of the **36‑bit** GE Large Systems / Honeywell /
   Bull 600/6000‑series mainframe computers (Honeywell 6180, Honeywell
   Series‑60 ∕ Level‑68, and Honeywell ∕ Bull **DPS‑8/M**) descended from
   the **GE‑645** and engineered to support the
   [**Multics** operating system](https://swenson.org/multics_wiki/).

 - Visit the
   [**DPS8M Simulator Homepage**](https://dps8m.gitlab.io/)
   for additional information.

## SAST Tools

* [**PVS-Studio**](https://pvs-studio.com/en/pvs-studio/?utm_source=github&utm_medium=organic&utm_campaign=open_source) - A static analyzer for C, C++, C#, and Java code.
* [Coverity® Scan](https://scan.coverity.com/) - Find and fix defects in Java, C/C++, C#, JavaScript, Ruby, or Python code.
* [Oracle Developer Studio](https://www.oracle.com/application-development/developerstudio/) - Performance, security, and thread analysis tools to help write higher quality code.
* [Cppcheck](https://cppcheck.sourceforge.io/) - A static analysis tool for C/C++ code.
* [Clang Static Analyzer](https://clang-analyzer.llvm.org/) - A source code analysis tool that finds bugs in C, C++, and Objective-C programs.
* [Flawfinder](https://dwheeler.com/flawfinder/) - Examine C/C++ source code for possible security weaknesses.
