{ inputs, ... }:
let
  sharedLib = inputs.self.sharedLib;
in
{
  perSystem =
    {
      self',
      lib,
      pkgs,
      ...
    }:
    let
      tapeTestLib = inputs.self.tapeTestLib { inherit self' lib pkgs; };
    in
    {
      checks = tapeTestLib.embeddInFlake {
        issueView = {
          extraSetup = [
            "berg auth login --token TOKEN"
            "berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}"
            "berg repo clone ${sharedLib.user}/${sharedLib.repo}"
            "cd ${sharedLib.repo}"
          ];
          exec = [
            "Sleep 1s"
            ''Type "berg issue create"''
            "Sleep 3s"
            "Enter"
            "Sleep 1s"
            ''Type "First issue"''
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            ''Type "berg issue view 1"''
            "Sleep 1s"
            "Enter"
            "Sleep 5s"
          ];
        };
        issueComment = {
          extraSetup = [
            "berg auth login --token TOKEN"
            "berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}"
            "berg repo clone ${sharedLib.user}/${sharedLib.repo}"
            "cd ${sharedLib.repo}"
          ];
          exec = [
            ''Type "berg issue create"''
            "Sleep 500ms"
            "Enter"
            ''Type "foo"''
            "Sleep 500ms"
            "Enter"
            "Sleep 500ms"
            "Enter"
            "Sleep 500ms"
            "Enter"
            "Sleep 500ms"
            ''Type "berg issue comment"''
            "Sleep 500ms"
            "Enter"
            "Sleep 500ms"
            "Enter"
            "Sleep 500ms"
            "Enter"
            "Sleep 500ms"
            ''Type "berg issue view --comments"''
            "Sleep 500ms"
            "Enter"
            "Sleep 500ms"
            "Enter"
            "Sleep 5s"
          ];
        };
        issueEditState = {
          extraSetup = [
            "berg auth login --token TOKEN"
            "berg --non-interactive repo create --name ${sharedLib.repo} --default-branch ${sharedLib.main}"
            "berg repo clone ${sharedLib.user}/${sharedLib.repo}"
            "cd ${sharedLib.repo}"
          ];
          exec = [
            "Sleep 1s"
            ''Type "berg issue create"''
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            ''Type "First issue"''
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            ''Type "berg issue edit 1"''
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            "Down"
            "Sleep 1s"
            "Down"
            "Sleep 1s"
            "Space"
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            "Down"
            "Sleep 1s"
            "Enter"
            "Sleep 1s"
            ''Type "berg issue view 1"''
            "Sleep 500ms"
            "Enter"
            "Sleep 5s"
          ];
        };
      };
    };
}
