use clap::Parser;

use crate::{actions::BergCommand, types::config::BergConfig};

pub async fn berg_main() {
    tracing_subscriber::fmt::init();

    if let Err(e) = BergCommand::parse().run().await {
        let config = match BergConfig::new() {
            Ok(config) => config,
            Err(e) => {
                eprintln!("{e:?}");
                return;
            }
        };
        let mut table = config.make_table();
        table.add_row(vec![
            comfy_table::Cell::new(format!("{e:?}")).fg(comfy_table::Color::Red)
        ]);
        eprintln!("{table}", table = table.show());
    }
}
