// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/language/v2/language_service.proto

package languagepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the text encoding that the caller uses to process the output.
// Providing an `EncodingType` is recommended because the API provides the
// beginning offsets for various outputs, such as tokens and mentions, and
// languages that natively use different text encodings may access offsets
// differently.
type EncodingType int32

const (
	// If `EncodingType` is not specified, encoding-dependent information (such as
	// `begin_offset`) will be set at `-1`.
	EncodingType_NONE EncodingType = 0
	// Encoding-dependent information (such as `begin_offset`) is calculated based
	// on the UTF-8 encoding of the input. C++ and Go are examples of languages
	// that use this encoding natively.
	EncodingType_UTF8 EncodingType = 1
	// Encoding-dependent information (such as `begin_offset`) is calculated based
	// on the UTF-16 encoding of the input. Java and JavaScript are examples of
	// languages that use this encoding natively.
	EncodingType_UTF16 EncodingType = 2
	// Encoding-dependent information (such as `begin_offset`) is calculated based
	// on the UTF-32 encoding of the input. Python is an example of a language
	// that uses this encoding natively.
	EncodingType_UTF32 EncodingType = 3
)

// Enum value maps for EncodingType.
var (
	EncodingType_name = map[int32]string{
		0: "NONE",
		1: "UTF8",
		2: "UTF16",
		3: "UTF32",
	}
	EncodingType_value = map[string]int32{
		"NONE":  0,
		"UTF8":  1,
		"UTF16": 2,
		"UTF32": 3,
	}
)

func (x EncodingType) Enum() *EncodingType {
	p := new(EncodingType)
	*p = x
	return p
}

func (x EncodingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncodingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v2_language_service_proto_enumTypes[0].Descriptor()
}

func (EncodingType) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v2_language_service_proto_enumTypes[0]
}

func (x EncodingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncodingType.Descriptor instead.
func (EncodingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{0}
}

// The document types enum.
type Document_Type int32

const (
	// The content type is not specified.
	Document_TYPE_UNSPECIFIED Document_Type = 0
	// Plain text
	Document_PLAIN_TEXT Document_Type = 1
	// HTML
	Document_HTML Document_Type = 2
)

// Enum value maps for Document_Type.
var (
	Document_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PLAIN_TEXT",
		2: "HTML",
	}
	Document_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"PLAIN_TEXT":       1,
		"HTML":             2,
	}
)

func (x Document_Type) Enum() *Document_Type {
	p := new(Document_Type)
	*p = x
	return p
}

func (x Document_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v2_language_service_proto_enumTypes[1].Descriptor()
}

func (Document_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v2_language_service_proto_enumTypes[1]
}

func (x Document_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Document_Type.Descriptor instead.
func (Document_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{0, 0}
}

// The type of the entity. The table
// below lists the associated fields for entities that have different
// metadata.
type Entity_Type int32

const (
	// Unknown
	Entity_UNKNOWN Entity_Type = 0
	// Person
	Entity_PERSON Entity_Type = 1
	// Location
	Entity_LOCATION Entity_Type = 2
	// Organization
	Entity_ORGANIZATION Entity_Type = 3
	// Event
	Entity_EVENT Entity_Type = 4
	// Artwork
	Entity_WORK_OF_ART Entity_Type = 5
	// Consumer product
	Entity_CONSUMER_GOOD Entity_Type = 6
	// Other types of entities
	Entity_OTHER Entity_Type = 7
	// Phone number
	//
	// The metadata lists the phone number, formatted according to local
	// convention, plus whichever additional elements appear in the text:
	//
	// * `number` - the actual number, broken down into sections as per local
	// convention
	// * `national_prefix` - country code, if detected
	// * `area_code` - region or area code, if detected
	// * `extension` - phone extension (to be dialed after connection), if
	// detected
	Entity_PHONE_NUMBER Entity_Type = 9
	// Address
	//
	// The metadata identifies the street number and locality plus whichever
	// additional elements appear in the text:
	//
	// * `street_number` - street number
	// * `locality` - city or town
	// * `street_name` - street/route name, if detected
	// * `postal_code` - postal code, if detected
	// * `country` - country, if detected
	// * `broad_region` - administrative area, such as the state, if detected
	// * `narrow_region` - smaller administrative area, such as county, if
	// detected
	// * `sublocality` - used in Asian addresses to demark a district within a
	// city, if detected
	Entity_ADDRESS Entity_Type = 10
	// Date
	//
	// The metadata identifies the components of the date:
	//
	// * `year` - four digit year, if detected
	// * `month` - two digit month number, if detected
	// * `day` - two digit day number, if detected
	Entity_DATE Entity_Type = 11
	// Number
	//
	// The metadata is the number itself.
	Entity_NUMBER Entity_Type = 12
	// Price
	//
	// The metadata identifies the `value` and `currency`.
	Entity_PRICE Entity_Type = 13
)

// Enum value maps for Entity_Type.
var (
	Entity_Type_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "PERSON",
		2:  "LOCATION",
		3:  "ORGANIZATION",
		4:  "EVENT",
		5:  "WORK_OF_ART",
		6:  "CONSUMER_GOOD",
		7:  "OTHER",
		9:  "PHONE_NUMBER",
		10: "ADDRESS",
		11: "DATE",
		12: "NUMBER",
		13: "PRICE",
	}
	Entity_Type_value = map[string]int32{
		"UNKNOWN":       0,
		"PERSON":        1,
		"LOCATION":      2,
		"ORGANIZATION":  3,
		"EVENT":         4,
		"WORK_OF_ART":   5,
		"CONSUMER_GOOD": 6,
		"OTHER":         7,
		"PHONE_NUMBER":  9,
		"ADDRESS":       10,
		"DATE":          11,
		"NUMBER":        12,
		"PRICE":         13,
	}
)

func (x Entity_Type) Enum() *Entity_Type {
	p := new(Entity_Type)
	*p = x
	return p
}

func (x Entity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Entity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v2_language_service_proto_enumTypes[2].Descriptor()
}

func (Entity_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v2_language_service_proto_enumTypes[2]
}

func (x Entity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Entity_Type.Descriptor instead.
func (Entity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{2, 0}
}

// The supported types of mentions.
type EntityMention_Type int32

const (
	// Unknown
	EntityMention_TYPE_UNKNOWN EntityMention_Type = 0
	// Proper name
	EntityMention_PROPER EntityMention_Type = 1
	// Common noun (or noun compound)
	EntityMention_COMMON EntityMention_Type = 2
)

// Enum value maps for EntityMention_Type.
var (
	EntityMention_Type_name = map[int32]string{
		0: "TYPE_UNKNOWN",
		1: "PROPER",
		2: "COMMON",
	}
	EntityMention_Type_value = map[string]int32{
		"TYPE_UNKNOWN": 0,
		"PROPER":       1,
		"COMMON":       2,
	}
)

func (x EntityMention_Type) Enum() *EntityMention_Type {
	p := new(EntityMention_Type)
	*p = x
	return p
}

func (x EntityMention_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityMention_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v2_language_service_proto_enumTypes[3].Descriptor()
}

func (EntityMention_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v2_language_service_proto_enumTypes[3]
}

func (x EntityMention_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntityMention_Type.Descriptor instead.
func (EntityMention_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{4, 0}
}

// The model version to use for ModerateText.
type ModerateTextRequest_ModelVersion int32

const (
	// The default model version.
	ModerateTextRequest_MODEL_VERSION_UNSPECIFIED ModerateTextRequest_ModelVersion = 0
	// Use the v1 model, this model is used by default when not provided.
	// The v1 model only returns probability (confidence) score for each
	// category.
	ModerateTextRequest_MODEL_VERSION_1 ModerateTextRequest_ModelVersion = 1
	// Use the v2 model.
	// The v2 model only returns probability (confidence) score for each
	// category, and returns severity score for a subset of the categories.
	ModerateTextRequest_MODEL_VERSION_2 ModerateTextRequest_ModelVersion = 2
)

// Enum value maps for ModerateTextRequest_ModelVersion.
var (
	ModerateTextRequest_ModelVersion_name = map[int32]string{
		0: "MODEL_VERSION_UNSPECIFIED",
		1: "MODEL_VERSION_1",
		2: "MODEL_VERSION_2",
	}
	ModerateTextRequest_ModelVersion_value = map[string]int32{
		"MODEL_VERSION_UNSPECIFIED": 0,
		"MODEL_VERSION_1":           1,
		"MODEL_VERSION_2":           2,
	}
)

func (x ModerateTextRequest_ModelVersion) Enum() *ModerateTextRequest_ModelVersion {
	p := new(ModerateTextRequest_ModelVersion)
	*p = x
	return p
}

func (x ModerateTextRequest_ModelVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModerateTextRequest_ModelVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v2_language_service_proto_enumTypes[4].Descriptor()
}

func (ModerateTextRequest_ModelVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v2_language_service_proto_enumTypes[4]
}

func (x ModerateTextRequest_ModelVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ModerateTextRequest_ModelVersion.Descriptor instead.
func (ModerateTextRequest_ModelVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{13, 0}
}

// Represents the input to API methods.
type Document struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. If the type is not set or is `TYPE_UNSPECIFIED`,
	// returns an `INVALID_ARGUMENT` error.
	Type Document_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.language.v2.Document_Type" json:"type,omitempty"`
	// The source of the document: a string containing the content or a
	// Google Cloud Storage URI.
	//
	// Types that are assignable to Source:
	//
	//	*Document_Content
	//	*Document_GcsContentUri
	Source isDocument_Source `protobuf_oneof:"source"`
	// Optional. The language of the document (if not specified, the language is
	// automatically detected). Both ISO and BCP-47 language codes are
	// accepted.<br>
	// [Language
	// Support](https://cloud.google.com/natural-language/docs/languages) lists
	// currently supported languages for each API method. If the language (either
	// specified by the caller or automatically detected) is not supported by the
	// called API method, an `INVALID_ARGUMENT` error is returned.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *Document) Reset() {
	*x = Document{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document) ProtoMessage() {}

func (x *Document) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document.ProtoReflect.Descriptor instead.
func (*Document) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{0}
}

func (x *Document) GetType() Document_Type {
	if x != nil {
		return x.Type
	}
	return Document_TYPE_UNSPECIFIED
}

func (m *Document) GetSource() isDocument_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Document) GetContent() string {
	if x, ok := x.GetSource().(*Document_Content); ok {
		return x.Content
	}
	return ""
}

func (x *Document) GetGcsContentUri() string {
	if x, ok := x.GetSource().(*Document_GcsContentUri); ok {
		return x.GcsContentUri
	}
	return ""
}

func (x *Document) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isDocument_Source interface {
	isDocument_Source()
}

type Document_Content struct {
	// The content of the input in string format.
	// Cloud audit logging exempt since it is based on user data.
	Content string `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

type Document_GcsContentUri struct {
	// The Google Cloud Storage URI where the file content is located.
	// This URI must be of the form: gs://bucket_name/object_name. For more
	// details, see https://cloud.google.com/storage/docs/reference-uris.
	// NOTE: Cloud Storage object versioning is not supported.
	GcsContentUri string `protobuf:"bytes,3,opt,name=gcs_content_uri,json=gcsContentUri,proto3,oneof"`
}

func (*Document_Content) isDocument_Source() {}

func (*Document_GcsContentUri) isDocument_Source() {}

// Represents a sentence in the input document.
type Sentence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sentence text.
	Text *TextSpan `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// For calls to [AnalyzeSentiment][] or if
	// [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v2.AnnotateTextRequest.Features.extract_document_sentiment]
	// is set to true, this field will contain the sentiment for the sentence.
	Sentiment *Sentiment `protobuf:"bytes,2,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *Sentence) Reset() {
	*x = Sentence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Sentence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sentence) ProtoMessage() {}

func (x *Sentence) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sentence.ProtoReflect.Descriptor instead.
func (*Sentence) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{1}
}

func (x *Sentence) GetText() *TextSpan {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *Sentence) GetSentiment() *Sentiment {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

// Represents a phrase in the text that is a known entity, such as
// a person, an organization, or location. The API associates information, such
// as probability and mentions, with entities.
type Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The representative name for the entity.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The entity type.
	Type Entity_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.language.v2.Entity_Type" json:"type,omitempty"`
	// Metadata associated with the entity.
	//
	// For the metadata
	// associated with other entity types, see the Type table below.
	Metadata map[string]string `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The mentions of this entity in the input document. The API currently
	// supports proper noun mentions.
	Mentions []*EntityMention `protobuf:"bytes,5,rep,name=mentions,proto3" json:"mentions,omitempty"`
	// For calls to [AnalyzeEntitySentiment][] or if
	// [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v2.AnnotateTextRequest.Features.extract_entity_sentiment]
	// is set to true, this field will contain the aggregate sentiment expressed
	// for this entity in the provided document.
	Sentiment *Sentiment `protobuf:"bytes,6,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *Entity) Reset() {
	*x = Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity) ProtoMessage() {}

func (x *Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity.ProtoReflect.Descriptor instead.
func (*Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{2}
}

func (x *Entity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entity) GetType() Entity_Type {
	if x != nil {
		return x.Type
	}
	return Entity_UNKNOWN
}

func (x *Entity) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Entity) GetMentions() []*EntityMention {
	if x != nil {
		return x.Mentions
	}
	return nil
}

func (x *Entity) GetSentiment() *Sentiment {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

// Represents the feeling associated with the entire text or entities in
// the text.
type Sentiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment regardless of score (positive or
	// negative).
	Magnitude float32 `protobuf:"fixed32,1,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
	// Sentiment score between -1.0 (negative sentiment) and 1.0
	// (positive sentiment).
	Score float32 `protobuf:"fixed32,2,opt,name=score,proto3" json:"score,omitempty"`
}

func (x *Sentiment) Reset() {
	*x = Sentiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Sentiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sentiment) ProtoMessage() {}

func (x *Sentiment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sentiment.ProtoReflect.Descriptor instead.
func (*Sentiment) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{3}
}

func (x *Sentiment) GetMagnitude() float32 {
	if x != nil {
		return x.Magnitude
	}
	return 0
}

func (x *Sentiment) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

// Represents a mention for an entity in the text. Currently, proper noun
// mentions are supported.
type EntityMention struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mention text.
	Text *TextSpan `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The type of the entity mention.
	Type EntityMention_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.language.v2.EntityMention_Type" json:"type,omitempty"`
	// For calls to [AnalyzeEntitySentiment][] or if
	// [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v2.AnnotateTextRequest.Features.extract_entity_sentiment]
	// is set to true, this field will contain the sentiment expressed for this
	// mention of the entity in the provided document.
	Sentiment *Sentiment `protobuf:"bytes,3,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
	// Probability score associated with the entity.
	//
	// The score shows the probability of the entity mention being the entity
	// type. The score is in (0, 1] range.
	Probability float32 `protobuf:"fixed32,4,opt,name=probability,proto3" json:"probability,omitempty"`
}

func (x *EntityMention) Reset() {
	*x = EntityMention{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityMention) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityMention) ProtoMessage() {}

func (x *EntityMention) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityMention.ProtoReflect.Descriptor instead.
func (*EntityMention) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{4}
}

func (x *EntityMention) GetText() *TextSpan {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *EntityMention) GetType() EntityMention_Type {
	if x != nil {
		return x.Type
	}
	return EntityMention_TYPE_UNKNOWN
}

func (x *EntityMention) GetSentiment() *Sentiment {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

func (x *EntityMention) GetProbability() float32 {
	if x != nil {
		return x.Probability
	}
	return 0
}

// Represents a text span in the input document.
type TextSpan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The content of the text span, which is a substring of the document.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The API calculates the beginning offset of the content in the original
	// document according to the
	// [EncodingType][google.cloud.language.v2.EncodingType] specified in the API
	// request.
	BeginOffset int32 `protobuf:"varint,2,opt,name=begin_offset,json=beginOffset,proto3" json:"begin_offset,omitempty"`
}

func (x *TextSpan) Reset() {
	*x = TextSpan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSpan) ProtoMessage() {}

func (x *TextSpan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSpan.ProtoReflect.Descriptor instead.
func (*TextSpan) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{5}
}

func (x *TextSpan) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *TextSpan) GetBeginOffset() int32 {
	if x != nil {
		return x.BeginOffset
	}
	return 0
}

// Represents a category returned from the text classifier.
type ClassificationCategory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the category representing the document.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The classifier's confidence of the category. Number represents how certain
	// the classifier is that this category represents the given text.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Optional. The classifier's severity of the category. This is only present
	// when the ModerateTextRequest.ModelVersion is set to MODEL_VERSION_2, and
	// the corresponding category has a severity score.
	Severity float32 `protobuf:"fixed32,3,opt,name=severity,proto3" json:"severity,omitempty"`
}

func (x *ClassificationCategory) Reset() {
	*x = ClassificationCategory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassificationCategory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassificationCategory) ProtoMessage() {}

func (x *ClassificationCategory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassificationCategory.ProtoReflect.Descriptor instead.
func (*ClassificationCategory) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{6}
}

func (x *ClassificationCategory) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ClassificationCategory) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *ClassificationCategory) GetSeverity() float32 {
	if x != nil {
		return x.Severity
	}
	return 0
}

// The sentiment analysis request message.
type AnalyzeSentimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The encoding type used by the API to calculate sentence offsets.
	EncodingType EncodingType `protobuf:"varint,2,opt,name=encoding_type,json=encodingType,proto3,enum=google.cloud.language.v2.EncodingType" json:"encoding_type,omitempty"`
}

func (x *AnalyzeSentimentRequest) Reset() {
	*x = AnalyzeSentimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeSentimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeSentimentRequest) ProtoMessage() {}

func (x *AnalyzeSentimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeSentimentRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeSentimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{7}
}

func (x *AnalyzeSentimentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AnalyzeSentimentRequest) GetEncodingType() EncodingType {
	if x != nil {
		return x.EncodingType
	}
	return EncodingType_NONE
}

// The sentiment analysis response message.
type AnalyzeSentimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overall sentiment of the input document.
	DocumentSentiment *Sentiment `protobuf:"bytes,1,opt,name=document_sentiment,json=documentSentiment,proto3" json:"document_sentiment,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][] field for more details.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The sentiment for all the sentences in the document.
	Sentences []*Sentence `protobuf:"bytes,3,rep,name=sentences,proto3" json:"sentences,omitempty"`
	// Whether the language is officially supported. The API may still return a
	// response when the language is not supported, but it is on a best effort
	// basis.
	LanguageSupported bool `protobuf:"varint,4,opt,name=language_supported,json=languageSupported,proto3" json:"language_supported,omitempty"`
}

func (x *AnalyzeSentimentResponse) Reset() {
	*x = AnalyzeSentimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeSentimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeSentimentResponse) ProtoMessage() {}

func (x *AnalyzeSentimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeSentimentResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeSentimentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{8}
}

func (x *AnalyzeSentimentResponse) GetDocumentSentiment() *Sentiment {
	if x != nil {
		return x.DocumentSentiment
	}
	return nil
}

func (x *AnalyzeSentimentResponse) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *AnalyzeSentimentResponse) GetSentences() []*Sentence {
	if x != nil {
		return x.Sentences
	}
	return nil
}

func (x *AnalyzeSentimentResponse) GetLanguageSupported() bool {
	if x != nil {
		return x.LanguageSupported
	}
	return false
}

// The entity analysis request message.
type AnalyzeEntitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The encoding type used by the API to calculate offsets.
	EncodingType EncodingType `protobuf:"varint,2,opt,name=encoding_type,json=encodingType,proto3,enum=google.cloud.language.v2.EncodingType" json:"encoding_type,omitempty"`
}

func (x *AnalyzeEntitiesRequest) Reset() {
	*x = AnalyzeEntitiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeEntitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeEntitiesRequest) ProtoMessage() {}

func (x *AnalyzeEntitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeEntitiesRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeEntitiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{9}
}

func (x *AnalyzeEntitiesRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AnalyzeEntitiesRequest) GetEncodingType() EncodingType {
	if x != nil {
		return x.EncodingType
	}
	return EncodingType_NONE
}

// The entity analysis response message.
type AnalyzeEntitiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The recognized entities in the input document.
	Entities []*Entity `protobuf:"bytes,1,rep,name=entities,proto3" json:"entities,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][] field for more details.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Whether the language is officially supported. The API may still return a
	// response when the language is not supported, but it is on a best effort
	// basis.
	LanguageSupported bool `protobuf:"varint,3,opt,name=language_supported,json=languageSupported,proto3" json:"language_supported,omitempty"`
}

func (x *AnalyzeEntitiesResponse) Reset() {
	*x = AnalyzeEntitiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeEntitiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeEntitiesResponse) ProtoMessage() {}

func (x *AnalyzeEntitiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeEntitiesResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeEntitiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{10}
}

func (x *AnalyzeEntitiesResponse) GetEntities() []*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *AnalyzeEntitiesResponse) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *AnalyzeEntitiesResponse) GetLanguageSupported() bool {
	if x != nil {
		return x.LanguageSupported
	}
	return false
}

// The document classification request message.
type ClassifyTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
}

func (x *ClassifyTextRequest) Reset() {
	*x = ClassifyTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassifyTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassifyTextRequest) ProtoMessage() {}

func (x *ClassifyTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassifyTextRequest.ProtoReflect.Descriptor instead.
func (*ClassifyTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{11}
}

func (x *ClassifyTextRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

// The document classification response message.
type ClassifyTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Categories representing the input document.
	Categories []*ClassificationCategory `protobuf:"bytes,1,rep,name=categories,proto3" json:"categories,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][] field for more details.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Whether the language is officially supported. The API may still return a
	// response when the language is not supported, but it is on a best effort
	// basis.
	LanguageSupported bool `protobuf:"varint,3,opt,name=language_supported,json=languageSupported,proto3" json:"language_supported,omitempty"`
}

func (x *ClassifyTextResponse) Reset() {
	*x = ClassifyTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassifyTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassifyTextResponse) ProtoMessage() {}

func (x *ClassifyTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassifyTextResponse.ProtoReflect.Descriptor instead.
func (*ClassifyTextResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{12}
}

func (x *ClassifyTextResponse) GetCategories() []*ClassificationCategory {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *ClassifyTextResponse) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ClassifyTextResponse) GetLanguageSupported() bool {
	if x != nil {
		return x.LanguageSupported
	}
	return false
}

// The document moderation request message.
type ModerateTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// Optional. The model version to use for ModerateText.
	ModelVersion ModerateTextRequest_ModelVersion `protobuf:"varint,2,opt,name=model_version,json=modelVersion,proto3,enum=google.cloud.language.v2.ModerateTextRequest_ModelVersion" json:"model_version,omitempty"`
}

func (x *ModerateTextRequest) Reset() {
	*x = ModerateTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModerateTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModerateTextRequest) ProtoMessage() {}

func (x *ModerateTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModerateTextRequest.ProtoReflect.Descriptor instead.
func (*ModerateTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{13}
}

func (x *ModerateTextRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *ModerateTextRequest) GetModelVersion() ModerateTextRequest_ModelVersion {
	if x != nil {
		return x.ModelVersion
	}
	return ModerateTextRequest_MODEL_VERSION_UNSPECIFIED
}

// The document moderation response message.
type ModerateTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Harmful and sensitive categories representing the input document.
	ModerationCategories []*ClassificationCategory `protobuf:"bytes,1,rep,name=moderation_categories,json=moderationCategories,proto3" json:"moderation_categories,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][] field for more details.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Whether the language is officially supported. The API may still return a
	// response when the language is not supported, but it is on a best effort
	// basis.
	LanguageSupported bool `protobuf:"varint,3,opt,name=language_supported,json=languageSupported,proto3" json:"language_supported,omitempty"`
}

func (x *ModerateTextResponse) Reset() {
	*x = ModerateTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModerateTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModerateTextResponse) ProtoMessage() {}

func (x *ModerateTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModerateTextResponse.ProtoReflect.Descriptor instead.
func (*ModerateTextResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{14}
}

func (x *ModerateTextResponse) GetModerationCategories() []*ClassificationCategory {
	if x != nil {
		return x.ModerationCategories
	}
	return nil
}

func (x *ModerateTextResponse) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ModerateTextResponse) GetLanguageSupported() bool {
	if x != nil {
		return x.LanguageSupported
	}
	return false
}

// The request message for the text annotation API, which can perform multiple
// analysis types in one call.
type AnnotateTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// Required. The enabled features.
	Features *AnnotateTextRequest_Features `protobuf:"bytes,2,opt,name=features,proto3" json:"features,omitempty"`
	// The encoding type used by the API to calculate offsets.
	EncodingType EncodingType `protobuf:"varint,3,opt,name=encoding_type,json=encodingType,proto3,enum=google.cloud.language.v2.EncodingType" json:"encoding_type,omitempty"`
}

func (x *AnnotateTextRequest) Reset() {
	*x = AnnotateTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateTextRequest) ProtoMessage() {}

func (x *AnnotateTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateTextRequest.ProtoReflect.Descriptor instead.
func (*AnnotateTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{15}
}

func (x *AnnotateTextRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AnnotateTextRequest) GetFeatures() *AnnotateTextRequest_Features {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *AnnotateTextRequest) GetEncodingType() EncodingType {
	if x != nil {
		return x.EncodingType
	}
	return EncodingType_NONE
}

// The text annotations response message.
type AnnotateTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sentences in the input document. Populated if the user enables
	// [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v2.AnnotateTextRequest.Features.extract_document_sentiment].
	Sentences []*Sentence `protobuf:"bytes,1,rep,name=sentences,proto3" json:"sentences,omitempty"`
	// Entities, along with their semantic information, in the input document.
	// Populated if the user enables
	// [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v2.AnnotateTextRequest.Features.extract_entities]
	// or
	// [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v2.AnnotateTextRequest.Features.extract_entity_sentiment].
	Entities []*Entity `protobuf:"bytes,2,rep,name=entities,proto3" json:"entities,omitempty"`
	// The overall sentiment for the document. Populated if the user enables
	// [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v2.AnnotateTextRequest.Features.extract_document_sentiment].
	DocumentSentiment *Sentiment `protobuf:"bytes,3,opt,name=document_sentiment,json=documentSentiment,proto3" json:"document_sentiment,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][] field for more details.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Categories identified in the input document.
	Categories []*ClassificationCategory `protobuf:"bytes,5,rep,name=categories,proto3" json:"categories,omitempty"`
	// Harmful and sensitive categories identified in the input document.
	ModerationCategories []*ClassificationCategory `protobuf:"bytes,6,rep,name=moderation_categories,json=moderationCategories,proto3" json:"moderation_categories,omitempty"`
	// Whether the language is officially supported by all requested features.
	// The API may still return a response when the language is not supported, but
	// it is on a best effort basis.
	LanguageSupported bool `protobuf:"varint,7,opt,name=language_supported,json=languageSupported,proto3" json:"language_supported,omitempty"`
}

func (x *AnnotateTextResponse) Reset() {
	*x = AnnotateTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateTextResponse) ProtoMessage() {}

func (x *AnnotateTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateTextResponse.ProtoReflect.Descriptor instead.
func (*AnnotateTextResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{16}
}

func (x *AnnotateTextResponse) GetSentences() []*Sentence {
	if x != nil {
		return x.Sentences
	}
	return nil
}

func (x *AnnotateTextResponse) GetEntities() []*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *AnnotateTextResponse) GetDocumentSentiment() *Sentiment {
	if x != nil {
		return x.DocumentSentiment
	}
	return nil
}

func (x *AnnotateTextResponse) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *AnnotateTextResponse) GetCategories() []*ClassificationCategory {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *AnnotateTextResponse) GetModerationCategories() []*ClassificationCategory {
	if x != nil {
		return x.ModerationCategories
	}
	return nil
}

func (x *AnnotateTextResponse) GetLanguageSupported() bool {
	if x != nil {
		return x.LanguageSupported
	}
	return false
}

// All available features.
// Setting each one to true will enable that specific analysis for the input.
type AnnotateTextRequest_Features struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Extract entities.
	ExtractEntities bool `protobuf:"varint,1,opt,name=extract_entities,json=extractEntities,proto3" json:"extract_entities,omitempty"`
	// Optional. Extract document-level sentiment.
	ExtractDocumentSentiment bool `protobuf:"varint,2,opt,name=extract_document_sentiment,json=extractDocumentSentiment,proto3" json:"extract_document_sentiment,omitempty"`
	// Optional. Classify the full document into categories.
	ClassifyText bool `protobuf:"varint,4,opt,name=classify_text,json=classifyText,proto3" json:"classify_text,omitempty"`
	// Optional. Moderate the document for harmful and sensitive categories.
	ModerateText bool `protobuf:"varint,5,opt,name=moderate_text,json=moderateText,proto3" json:"moderate_text,omitempty"`
}

func (x *AnnotateTextRequest_Features) Reset() {
	*x = AnnotateTextRequest_Features{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateTextRequest_Features) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateTextRequest_Features) ProtoMessage() {}

func (x *AnnotateTextRequest_Features) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v2_language_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateTextRequest_Features.ProtoReflect.Descriptor instead.
func (*AnnotateTextRequest_Features) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v2_language_service_proto_rawDescGZIP(), []int{15, 0}
}

func (x *AnnotateTextRequest_Features) GetExtractEntities() bool {
	if x != nil {
		return x.ExtractEntities
	}
	return false
}

func (x *AnnotateTextRequest_Features) GetExtractDocumentSentiment() bool {
	if x != nil {
		return x.ExtractDocumentSentiment
	}
	return false
}

func (x *AnnotateTextRequest_Features) GetClassifyText() bool {
	if x != nil {
		return x.ClassifyText
	}
	return false
}

func (x *AnnotateTextRequest_Features) GetModerateText() bool {
	if x != nil {
		return x.ModerateText
	}
	return false
}

var File_google_cloud_language_v2_language_service_proto protoreflect.FileDescriptor

var file_google_cloud_language_v2_language_service_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xf9, 0x01, 0x0a, 0x08, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x67, 0x63, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x36, 0x0a,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50,
	0x4c, 0x41, 0x49, 0x4e, 0x5f, 0x54, 0x45, 0x58, 0x54, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48,
	0x54, 0x4d, 0x4c, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0x85, 0x01, 0x0a, 0x08, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x41, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x73, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xa4, 0x04, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x4a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x43, 0x0a,
	0x08, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x41, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xb9, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x45, 0x52, 0x53,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12,
	0x0f, 0x0a, 0x0b, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4f, 0x46, 0x5f, 0x41, 0x52, 0x54, 0x10, 0x05,
	0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x47, 0x4f, 0x4f,
	0x44, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x07, 0x12, 0x10,
	0x0a, 0x0c, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x09,
	0x12, 0x0b, 0x0a, 0x07, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0a, 0x12, 0x08, 0x0a,
	0x04, 0x44, 0x41, 0x54, 0x45, 0x10, 0x0b, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45,
	0x52, 0x10, 0x0c, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x52, 0x49, 0x43, 0x45, 0x10, 0x0d, 0x22, 0x3f,
	0x0a, 0x09, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x6d,
	0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09,
	0x6d, 0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22,
	0xa0, 0x02, 0x0a, 0x0d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x36, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53,
	0x70, 0x61, 0x6e, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x09, 0x73,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x22, 0x30, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x52,
	0x4f, 0x50, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4d, 0x4d, 0x4f, 0x4e,
	0x10, 0x02, 0x22, 0x47, 0x0a, 0x08, 0x54, 0x65, 0x78, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x65, 0x67, 0x69,
	0x6e, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b,
	0x62, 0x65, 0x67, 0x69, 0x6e, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x6d, 0x0a, 0x16, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x73, 0x65, 0x76,
	0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x22, 0xab, 0x01, 0x0a, 0x17, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0d, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22, 0x84, 0x02, 0x0a, 0x18, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x12, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40,
	0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x2d, 0x0a, 0x12, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x22,
	0xaa, 0x01, 0x0a, 0x16, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x4b, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22, 0xab, 0x01, 0x0a,
	0x17, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x22, 0x5a, 0x0a, 0x13, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xbc, 0x01, 0x0a, 0x14, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x50, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x11, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x22, 0x99, 0x02, 0x0a, 0x13, 0x4d, 0x6f, 0x64, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x64, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x57, 0x0a, 0x0c, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x4f, 0x44, 0x45,
	0x4c, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x4f, 0x44, 0x45, 0x4c,
	0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x31, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x32, 0x10,
	0x02, 0x22, 0xd1, 0x01, 0x0a, 0x14, 0x4d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x15, 0x6d, 0x6f,
	0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x14, 0x6d, 0x6f, 0x64,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x11, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x22, 0xd4, 0x03, 0x0a, 0x13, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x57, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0d, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xd1, 0x01, 0x0a, 0x08, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74,
	0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x1a, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18,
	0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x79, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x6d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x22, 0xf7, 0x03, 0x0a,
	0x14, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x73, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x12, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x50,
	0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x12, 0x65, 0x0a, 0x15, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x52, 0x14, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x11, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x2a, 0x38, 0x0a, 0x0c, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x55, 0x54, 0x46, 0x38, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x54,
	0x46, 0x31, 0x36, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x54, 0x46, 0x33, 0x32, 0x10, 0x03,
	0x32, 0xb0, 0x08, 0x0a, 0x0f, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xc8, 0x01, 0x0a, 0x10, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4d, 0xda, 0x41, 0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xda, 0x41, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x3a, 0x01, 0x2a, 0x22,
	0x1e, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0xc4, 0x01, 0x0a, 0x0f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x16, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0xda, 0x41, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x22, 0x3a, 0x01, 0x2a, 0x22, 0x1d, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x0c, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x30, 0xda, 0x41, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x3a, 0x01, 0x2a, 0x22, 0x1a, 0x2f, 0x76,
	0x32, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x9f, 0x01, 0x0a, 0x0c, 0x4d, 0x6f, 0x64,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x30, 0xda, 0x41, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x3a, 0x01, 0x2a, 0x22, 0x1a,
	0x2f, 0x76, 0x32, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x6d, 0x6f,
	0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0xca, 0x01, 0x0a, 0x0c, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5b, 0xda, 0x41, 0x1f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x2c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xda, 0x41,
	0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x3a, 0x01, 0x2a, 0x22, 0x1a, 0x2f, 0x76, 0x32,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x1a, 0x7a, 0xca, 0x41, 0x17, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5d, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0x70, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x32, 0x42, 0x14, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_language_v2_language_service_proto_rawDescOnce sync.Once
	file_google_cloud_language_v2_language_service_proto_rawDescData = file_google_cloud_language_v2_language_service_proto_rawDesc
)

func file_google_cloud_language_v2_language_service_proto_rawDescGZIP() []byte {
	file_google_cloud_language_v2_language_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_language_v2_language_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_language_v2_language_service_proto_rawDescData)
	})
	return file_google_cloud_language_v2_language_service_proto_rawDescData
}

var file_google_cloud_language_v2_language_service_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_language_v2_language_service_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_cloud_language_v2_language_service_proto_goTypes = []any{
	(EncodingType)(0),                     // 0: google.cloud.language.v2.EncodingType
	(Document_Type)(0),                    // 1: google.cloud.language.v2.Document.Type
	(Entity_Type)(0),                      // 2: google.cloud.language.v2.Entity.Type
	(EntityMention_Type)(0),               // 3: google.cloud.language.v2.EntityMention.Type
	(ModerateTextRequest_ModelVersion)(0), // 4: google.cloud.language.v2.ModerateTextRequest.ModelVersion
	(*Document)(nil),                      // 5: google.cloud.language.v2.Document
	(*Sentence)(nil),                      // 6: google.cloud.language.v2.Sentence
	(*Entity)(nil),                        // 7: google.cloud.language.v2.Entity
	(*Sentiment)(nil),                     // 8: google.cloud.language.v2.Sentiment
	(*EntityMention)(nil),                 // 9: google.cloud.language.v2.EntityMention
	(*TextSpan)(nil),                      // 10: google.cloud.language.v2.TextSpan
	(*ClassificationCategory)(nil),        // 11: google.cloud.language.v2.ClassificationCategory
	(*AnalyzeSentimentRequest)(nil),       // 12: google.cloud.language.v2.AnalyzeSentimentRequest
	(*AnalyzeSentimentResponse)(nil),      // 13: google.cloud.language.v2.AnalyzeSentimentResponse
	(*AnalyzeEntitiesRequest)(nil),        // 14: google.cloud.language.v2.AnalyzeEntitiesRequest
	(*AnalyzeEntitiesResponse)(nil),       // 15: google.cloud.language.v2.AnalyzeEntitiesResponse
	(*ClassifyTextRequest)(nil),           // 16: google.cloud.language.v2.ClassifyTextRequest
	(*ClassifyTextResponse)(nil),          // 17: google.cloud.language.v2.ClassifyTextResponse
	(*ModerateTextRequest)(nil),           // 18: google.cloud.language.v2.ModerateTextRequest
	(*ModerateTextResponse)(nil),          // 19: google.cloud.language.v2.ModerateTextResponse
	(*AnnotateTextRequest)(nil),           // 20: google.cloud.language.v2.AnnotateTextRequest
	(*AnnotateTextResponse)(nil),          // 21: google.cloud.language.v2.AnnotateTextResponse
	nil,                                   // 22: google.cloud.language.v2.Entity.MetadataEntry
	(*AnnotateTextRequest_Features)(nil),  // 23: google.cloud.language.v2.AnnotateTextRequest.Features
}
var file_google_cloud_language_v2_language_service_proto_depIdxs = []int32{
	1,  // 0: google.cloud.language.v2.Document.type:type_name -> google.cloud.language.v2.Document.Type
	10, // 1: google.cloud.language.v2.Sentence.text:type_name -> google.cloud.language.v2.TextSpan
	8,  // 2: google.cloud.language.v2.Sentence.sentiment:type_name -> google.cloud.language.v2.Sentiment
	2,  // 3: google.cloud.language.v2.Entity.type:type_name -> google.cloud.language.v2.Entity.Type
	22, // 4: google.cloud.language.v2.Entity.metadata:type_name -> google.cloud.language.v2.Entity.MetadataEntry
	9,  // 5: google.cloud.language.v2.Entity.mentions:type_name -> google.cloud.language.v2.EntityMention
	8,  // 6: google.cloud.language.v2.Entity.sentiment:type_name -> google.cloud.language.v2.Sentiment
	10, // 7: google.cloud.language.v2.EntityMention.text:type_name -> google.cloud.language.v2.TextSpan
	3,  // 8: google.cloud.language.v2.EntityMention.type:type_name -> google.cloud.language.v2.EntityMention.Type
	8,  // 9: google.cloud.language.v2.EntityMention.sentiment:type_name -> google.cloud.language.v2.Sentiment
	5,  // 10: google.cloud.language.v2.AnalyzeSentimentRequest.document:type_name -> google.cloud.language.v2.Document
	0,  // 11: google.cloud.language.v2.AnalyzeSentimentRequest.encoding_type:type_name -> google.cloud.language.v2.EncodingType
	8,  // 12: google.cloud.language.v2.AnalyzeSentimentResponse.document_sentiment:type_name -> google.cloud.language.v2.Sentiment
	6,  // 13: google.cloud.language.v2.AnalyzeSentimentResponse.sentences:type_name -> google.cloud.language.v2.Sentence
	5,  // 14: google.cloud.language.v2.AnalyzeEntitiesRequest.document:type_name -> google.cloud.language.v2.Document
	0,  // 15: google.cloud.language.v2.AnalyzeEntitiesRequest.encoding_type:type_name -> google.cloud.language.v2.EncodingType
	7,  // 16: google.cloud.language.v2.AnalyzeEntitiesResponse.entities:type_name -> google.cloud.language.v2.Entity
	5,  // 17: google.cloud.language.v2.ClassifyTextRequest.document:type_name -> google.cloud.language.v2.Document
	11, // 18: google.cloud.language.v2.ClassifyTextResponse.categories:type_name -> google.cloud.language.v2.ClassificationCategory
	5,  // 19: google.cloud.language.v2.ModerateTextRequest.document:type_name -> google.cloud.language.v2.Document
	4,  // 20: google.cloud.language.v2.ModerateTextRequest.model_version:type_name -> google.cloud.language.v2.ModerateTextRequest.ModelVersion
	11, // 21: google.cloud.language.v2.ModerateTextResponse.moderation_categories:type_name -> google.cloud.language.v2.ClassificationCategory
	5,  // 22: google.cloud.language.v2.AnnotateTextRequest.document:type_name -> google.cloud.language.v2.Document
	23, // 23: google.cloud.language.v2.AnnotateTextRequest.features:type_name -> google.cloud.language.v2.AnnotateTextRequest.Features
	0,  // 24: google.cloud.language.v2.AnnotateTextRequest.encoding_type:type_name -> google.cloud.language.v2.EncodingType
	6,  // 25: google.cloud.language.v2.AnnotateTextResponse.sentences:type_name -> google.cloud.language.v2.Sentence
	7,  // 26: google.cloud.language.v2.AnnotateTextResponse.entities:type_name -> google.cloud.language.v2.Entity
	8,  // 27: google.cloud.language.v2.AnnotateTextResponse.document_sentiment:type_name -> google.cloud.language.v2.Sentiment
	11, // 28: google.cloud.language.v2.AnnotateTextResponse.categories:type_name -> google.cloud.language.v2.ClassificationCategory
	11, // 29: google.cloud.language.v2.AnnotateTextResponse.moderation_categories:type_name -> google.cloud.language.v2.ClassificationCategory
	12, // 30: google.cloud.language.v2.LanguageService.AnalyzeSentiment:input_type -> google.cloud.language.v2.AnalyzeSentimentRequest
	14, // 31: google.cloud.language.v2.LanguageService.AnalyzeEntities:input_type -> google.cloud.language.v2.AnalyzeEntitiesRequest
	16, // 32: google.cloud.language.v2.LanguageService.ClassifyText:input_type -> google.cloud.language.v2.ClassifyTextRequest
	18, // 33: google.cloud.language.v2.LanguageService.ModerateText:input_type -> google.cloud.language.v2.ModerateTextRequest
	20, // 34: google.cloud.language.v2.LanguageService.AnnotateText:input_type -> google.cloud.language.v2.AnnotateTextRequest
	13, // 35: google.cloud.language.v2.LanguageService.AnalyzeSentiment:output_type -> google.cloud.language.v2.AnalyzeSentimentResponse
	15, // 36: google.cloud.language.v2.LanguageService.AnalyzeEntities:output_type -> google.cloud.language.v2.AnalyzeEntitiesResponse
	17, // 37: google.cloud.language.v2.LanguageService.ClassifyText:output_type -> google.cloud.language.v2.ClassifyTextResponse
	19, // 38: google.cloud.language.v2.LanguageService.ModerateText:output_type -> google.cloud.language.v2.ModerateTextResponse
	21, // 39: google.cloud.language.v2.LanguageService.AnnotateText:output_type -> google.cloud.language.v2.AnnotateTextResponse
	35, // [35:40] is the sub-list for method output_type
	30, // [30:35] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_language_v2_language_service_proto_init() }
func file_google_cloud_language_v2_language_service_proto_init() {
	if File_google_cloud_language_v2_language_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_language_v2_language_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Document); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Sentence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*Sentiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*EntityMention); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*TextSpan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ClassificationCategory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeSentimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeSentimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeEntitiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeEntitiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*ClassifyTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*ClassifyTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*ModerateTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*ModerateTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*AnnotateTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*AnnotateTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v2_language_service_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*AnnotateTextRequest_Features); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_language_v2_language_service_proto_msgTypes[0].OneofWrappers = []any{
		(*Document_Content)(nil),
		(*Document_GcsContentUri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_language_v2_language_service_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_language_v2_language_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_language_v2_language_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_language_v2_language_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_language_v2_language_service_proto_msgTypes,
	}.Build()
	File_google_cloud_language_v2_language_service_proto = out.File
	file_google_cloud_language_v2_language_service_proto_rawDesc = nil
	file_google_cloud_language_v2_language_service_proto_goTypes = nil
	file_google_cloud_language_v2_language_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LanguageServiceClient is the client API for LanguageService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LanguageServiceClient interface {
	// Analyzes the sentiment of the provided text.
	AnalyzeSentiment(ctx context.Context, in *AnalyzeSentimentRequest, opts ...grpc.CallOption) (*AnalyzeSentimentResponse, error)
	// Finds named entities (currently proper names and common nouns) in the text
	// along with entity types, probability, mentions for each entity, and
	// other properties.
	AnalyzeEntities(ctx context.Context, in *AnalyzeEntitiesRequest, opts ...grpc.CallOption) (*AnalyzeEntitiesResponse, error)
	// Classifies a document into categories.
	ClassifyText(ctx context.Context, in *ClassifyTextRequest, opts ...grpc.CallOption) (*ClassifyTextResponse, error)
	// Moderates a document for harmful and sensitive categories.
	ModerateText(ctx context.Context, in *ModerateTextRequest, opts ...grpc.CallOption) (*ModerateTextResponse, error)
	// A convenience method that provides all features in one call.
	AnnotateText(ctx context.Context, in *AnnotateTextRequest, opts ...grpc.CallOption) (*AnnotateTextResponse, error)
}

type languageServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLanguageServiceClient(cc grpc.ClientConnInterface) LanguageServiceClient {
	return &languageServiceClient{cc}
}

func (c *languageServiceClient) AnalyzeSentiment(ctx context.Context, in *AnalyzeSentimentRequest, opts ...grpc.CallOption) (*AnalyzeSentimentResponse, error) {
	out := new(AnalyzeSentimentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v2.LanguageService/AnalyzeSentiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnalyzeEntities(ctx context.Context, in *AnalyzeEntitiesRequest, opts ...grpc.CallOption) (*AnalyzeEntitiesResponse, error) {
	out := new(AnalyzeEntitiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v2.LanguageService/AnalyzeEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) ClassifyText(ctx context.Context, in *ClassifyTextRequest, opts ...grpc.CallOption) (*ClassifyTextResponse, error) {
	out := new(ClassifyTextResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v2.LanguageService/ClassifyText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) ModerateText(ctx context.Context, in *ModerateTextRequest, opts ...grpc.CallOption) (*ModerateTextResponse, error) {
	out := new(ModerateTextResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v2.LanguageService/ModerateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnnotateText(ctx context.Context, in *AnnotateTextRequest, opts ...grpc.CallOption) (*AnnotateTextResponse, error) {
	out := new(AnnotateTextResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v2.LanguageService/AnnotateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LanguageServiceServer is the server API for LanguageService service.
type LanguageServiceServer interface {
	// Analyzes the sentiment of the provided text.
	AnalyzeSentiment(context.Context, *AnalyzeSentimentRequest) (*AnalyzeSentimentResponse, error)
	// Finds named entities (currently proper names and common nouns) in the text
	// along with entity types, probability, mentions for each entity, and
	// other properties.
	AnalyzeEntities(context.Context, *AnalyzeEntitiesRequest) (*AnalyzeEntitiesResponse, error)
	// Classifies a document into categories.
	ClassifyText(context.Context, *ClassifyTextRequest) (*ClassifyTextResponse, error)
	// Moderates a document for harmful and sensitive categories.
	ModerateText(context.Context, *ModerateTextRequest) (*ModerateTextResponse, error)
	// A convenience method that provides all features in one call.
	AnnotateText(context.Context, *AnnotateTextRequest) (*AnnotateTextResponse, error)
}

// UnimplementedLanguageServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLanguageServiceServer struct {
}

func (*UnimplementedLanguageServiceServer) AnalyzeSentiment(context.Context, *AnalyzeSentimentRequest) (*AnalyzeSentimentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeSentiment not implemented")
}
func (*UnimplementedLanguageServiceServer) AnalyzeEntities(context.Context, *AnalyzeEntitiesRequest) (*AnalyzeEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeEntities not implemented")
}
func (*UnimplementedLanguageServiceServer) ClassifyText(context.Context, *ClassifyTextRequest) (*ClassifyTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClassifyText not implemented")
}
func (*UnimplementedLanguageServiceServer) ModerateText(context.Context, *ModerateTextRequest) (*ModerateTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModerateText not implemented")
}
func (*UnimplementedLanguageServiceServer) AnnotateText(context.Context, *AnnotateTextRequest) (*AnnotateTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateText not implemented")
}

func RegisterLanguageServiceServer(s *grpc.Server, srv LanguageServiceServer) {
	s.RegisterService(&_LanguageService_serviceDesc, srv)
}

func _LanguageService_AnalyzeSentiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeSentimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeSentiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v2.LanguageService/AnalyzeSentiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeSentiment(ctx, req.(*AnalyzeSentimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnalyzeEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v2.LanguageService/AnalyzeEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeEntities(ctx, req.(*AnalyzeEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_ClassifyText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClassifyTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).ClassifyText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v2.LanguageService/ClassifyText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).ClassifyText(ctx, req.(*ClassifyTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_ModerateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModerateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).ModerateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v2.LanguageService/ModerateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).ModerateText(ctx, req.(*ModerateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnnotateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnnotateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v2.LanguageService/AnnotateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnnotateText(ctx, req.(*AnnotateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LanguageService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.language.v2.LanguageService",
	HandlerType: (*LanguageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnalyzeSentiment",
			Handler:    _LanguageService_AnalyzeSentiment_Handler,
		},
		{
			MethodName: "AnalyzeEntities",
			Handler:    _LanguageService_AnalyzeEntities_Handler,
		},
		{
			MethodName: "ClassifyText",
			Handler:    _LanguageService_ClassifyText_Handler,
		},
		{
			MethodName: "ModerateText",
			Handler:    _LanguageService_ModerateText_Handler,
		},
		{
			MethodName: "AnnotateText",
			Handler:    _LanguageService_AnnotateText_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/language/v2/language_service.proto",
}
