10 PRINT "PROGRAM FILE 203: EFFECT OF ZONES AND MARGIN ON PRINT."
20 PRINT "    ANSI STANDARD 12.4, 12.2"
30 PRINT
40 PRINT "THIS TEST IS CONCERNED WITH THE VARIOUS RULES GOVERNING THE"
50 PRINT "INTERACTION OF ZONE-WIDTH, MARGIN-WIDTH, COLUMNAR POSITION,"
60 PRINT "AND PRINT-SEPARATORS AS DESCRIBED IN THE STANDARD."
70 PRINT
80 PRINT "PLEASE ENTER ZONE-WIDTH FOR THIS IMPLEMENTATION."
90 INPUT Z
100 IF Z=INT(Z) THEN 130
110 PRINT "MUST BE AN INTEGER."
120 GOTO 80
130 IF Z>=14 THEN 160
140 PRINT "ZONE-WIDTH MUST BE >=14."
150 GOTO 80
160 PRINT "PLEASE ENTER MARGIN FOR THIS IMPLEMENTATION."
170 INPUT M
180 IF M=INT(M) THEN 210
190 PRINT "MUST BE AN INTEGER."
200 GOTO 160
210 IF M>=Z THEN 235
220 PRINT "MARGIN MUST BE >= ZONE-WIDTH."
230 GOTO 160
235 PRINT "PLEASE ENTER NUMBER OF PRINT ZONES ON A LINE."
240 INPUT Z9
245 IF Z9=INT(Z9) THEN 260
250 PRINT "MUST BE AN INTEGER."
255 GOTO 235
260 IF Z9 <= ((M-1/Z) + 1) THEN 275
265 PRINT "NUMBER OF ZONES TOO LARGE FOR MARGIN AND ZONE-WIDTH."
270 GOTO 80
275 REM LENGTH OF LAST ZONE
280 LET Z8=M-(Z*(Z9-1))
290 PRINT
300 PRINT "THROUGHOUT THESE TESTS, PAIRS OF OUTPUTS WILL BE PRINTED."
310 PRINT "THE FIRST OF WHICH IS GENERATED ACCORDING TO THE INFORMATION"
320 PRINT "JUST SUPPLIED, AND THE SECOND OF WHICH REPRESENTS THE "
330 PRINT "FEATURE BEING TESTED. THESE TWO OUTPUTS MUST BE IDENTICAL"
340 PRINT "FOR THE TEST TO PASS."
350 PRINT
360 LET C=0
370 PRINT "SECTION 203.1: COMMA ADVANCES COLUMNAR POSITION TO NEXT"
380 PRINT "        PRINT-ZONE."
390 PRINT
400 PRINT "                    BEGIN TEST."
403 PRINT
405 PRINT "COMMA ADVANCED TO THE BEGINNING OF EACH OF THE ";Z9;
407 PRINT " PRINT ZONES:"
410 GOSUB 2000
420 LET T=Z-1
430 FOR I9=1 TO Z9-1
440 PRINT "A";
450 GOSUB 2100
460 NEXT I9
470 PRINT "B"
480 FOR I=1 TO Z9-1
490 PRINT "A",
500 NEXT I
510 PRINT "B"
512 PRINT
515 PRINT "PRINT-STATEMENT CONTAINING ONLY A COMMA ADVANCES TO NEXT ";
517 PRINT "PRINT-ZONE:"
520 GOSUB 2000
530 PRINT "C";
540 LET T=Z+Z-1
550 GOSUB 2100
560 PRINT "D"
570 PRINT "C",
580 PRINT ,
590 PRINT "D"
592 PRINT
595 PRINT "IF COLUMNAR POSITION IS THE LAST POSITION IN A ZONE, "
597 PRINT "A COMMA ADVANCES ONE SPACE TO THE NEXT ZONE:"
600 GOSUB 2000
610 LET T=Z-2
620 GOSUB 2100
630 PRINT "E F"
640 GOSUB 2100
650 PRINT "E","F"
652 PRINT
655 PRINT "IF COLUMNAR POSITION IS THE FIRST POSITION IN A ZONE,"
657 PRINT "A COMMA ADVANCES ONE FULL ZONE:"
660 GOSUB 2000
670 LET T=Z-1
680 GOSUB 2100
690 PRINT "G";
700 LET T=Z
710 GOSUB 2100
720 PRINT "H"
730 LET T=Z-1
740 GOSUB 2100
750 PRINT "G","H"
752 PRINT
755 PRINT "LEADING COMMAS IN A PRINT-STATEMENT SKIP PRINT-ZONES:"
760 GOSUB 2000
770 LET T=Z+Z
780 GOSUB 2100
790 PRINT "I"
800 PRINT ,,"I"
810 GOSUB 3000
820 PRINT "SECTION 203.2: INTERACTION OF TAB AND MARGIN."
830 PRINT
840 PRINT "                  BEGIN TEST."
850 LET C=0
860 PRINT
862 PRINT
865 PRINT "TABBING TO A POSITION < COLUMNAR POSITION FORCES A NEW LINE:"
870 GOSUB 2200
880 PRINT "    A"
890 PRINT "    B"
900 PRINT TAB(5);"A";TAB(5);"B"
902 PRINT
905 PRINT "TABBING TO A POSITION >= COLUMNAR POSITION DOES NOT"
909 PRINT "FORCE A NEW LINE:"
910 GOSUB 2000
920 PRINT "    CD"
930 PRINT TAB(5);"C";TAB(6);"D"
932 PRINT
935 PRINT "TABBING TO A POSITION, N > MARGIN, M, CAUSES TAB TO"
937 PRINT "N - M*INT((N-1)/M):"
940 GOSUB 2000
950 PRINT "  E"
960 PRINT TAB(M+M+M+3);"E"
970 GOSUB 3000
980 PRINT "SECTION 203.3: MARGIN OVERFLOW."
990 PRINT
1000 PRINT "                  BEGIN TEST."
1010 LET C=0
1012 PRINT
1015 PRINT "IF A PRINT-ITEM DOESN'T FIT IN REMAINDER OF CURRENT LINE,"
1017 PRINT "IT FORCES A NEW LINE BEFORE PRINTING:"
1020 GOSUB 2200
1030 LET T=M-2
1040 GOSUB 2100
1050 PRINT "A"
1060 PRINT "BC"
1065 GOSUB 2100
1070 PRINT "A";
1075 PRINT "BC"
1076 PRINT
1077 PRINT "FULL LENGTH OF MARGIN IS USED BEFORE FORCING NEW LINE:"
1080 GOSUB 2000
1090 GOSUB 2100
1100 PRINT "DE"
1105 PRINT "F"
1110 GOSUB 2100
1112 PRINT "D";"E";
1117 PRINT "F"
1118 PRINT
1119 PRINT "FILL RIGHTMOST POSITION OF LAST ZONE:"
1120 GOSUB 2000
1130 LET T=M-1
1140 GOSUB 2100
1150 PRINT "G"
1160 FOR I1=1 TO Z9-1
1170 PRINT ,
1180 NEXT I1
1190 LET T=Z8-1
1200 GOSUB 2100
1210 PRINT "G"
1212 PRINT
1215 PRINT "IF COLUMNAR POSITION IS IN LAST ZONE, A COMMA FORCES ";
1218 PRINT "A NEW LINE:"
1220 GOSUB 2200
1230 PRINT "H"
1240 PRINT "I"
1250 PRINT "H";
1260 FOR I1=1 TO Z9-2
1270 PRINT ,
1280 NEXT I1
1290 PRINT ,,"I"
1300 GOSUB 3000
1980 PRINT "END PROGRAM 203"
1990 STOP
2000 REM SUBROUTINE TO HEAD LINE-PAIRS
2010 LET C=C+1
2040 PRINT
2050 PRINT "THE TWO LINES FOLLOWING THE COLUMN NUMBERS SHOULD BE"
2060 PRINT "IDENTICAL, CASE #";C
2070 GOSUB 2300
2080 RETURN
2100 REM SUBROUTINE TO PRINT T SPACES
2110 FOR I=1 TO T
2120 PRINT " ";
2130 NEXT I
2140 RETURN
2200 REM SUBROUTINE TO HEAD PAIRS OF SETS OF LINES
2210 LET C=C+1
2240 PRINT
2250 PRINT "THE FIRST TWO LINES (1 & 2) FOLLOWING THE COLUMN NUMBERS"
2260 PRINT "SHOULD BE IDENTICAL TO THE NEXT TWO (3 & 4), CASE #";C
2270 GOSUB 2300
2280 RETURN
2300 REM SUBROUTINE TO PRINT COLUMN NUMBERS
2310 PRINT "000000000111111111122222222223333333333";
2320 IF M<60 THEN 2420
2330 PRINT "44444444445555555555";
2340 IF M<72 THEN 2420
2350 PRINT "666666666677";
2353 IF M<80 THEN 2420
2355 PRINT "77777777";
2360 IF M<100 THEN 2420
2370 PRINT "88888888889999999999";
2380 IF M<120 THEN 2420
2390 PRINT "00000000001111111111";
2400 IF M<132 THEN 2420
2410 PRINT "222222222233";
2420 PRINT
2430 LET A$="0123456789"
2440 PRINT "123456789";A$;A$;A$;
2450 IF M<60 THEN 2550
2460 PRINT A$;A$;
2470 IF M<72 THEN 2550
2480 PRINT A$;"01";
2483 IF M<80 THEN 2550
2485 PRINT "23456789";
2490 IF M<100 THEN 2550
2500 PRINT A$;A$;
2510 IF M<120 THEN 2550
2520 PRINT A$;A$;
2530 IF M<132 THEN 2550
2540 PRINT A$;"01";
2550 PRINT
2560 RETURN
3000 REM SUBROUTINE TO END SECTION
3010 PRINT
3020 PRINT "IF ALL THE ABOVE PAIRS ARE IDENTICAL, THEN "
3030 PRINT "***  TEST PASSED  ***"
3040 PRINT
3050 PRINT "                  END TEST."
3060 PRINT
3070 PRINT
3080 RETURN
5000 END
