.\" @(#)ywho.man,v 1.3 2000/12/17 17:01:14 kim Exp
.TH YWHO 1V "15 December 1990"
.SH NAME
ywho, yusers, yuptime \- who, users, uptime on clients in a sun-RPC network.
.SH SYNOPSIS
.B ywho, yusers, yuptime 
[-a][-t <timeout>]
<host>|-g <netgroup>
.SH DESCRIPTION
.I ywho
is another version of rwho, but it is faster than rwho and requires
no /usr/spool/rwho/rwhod.*. Note that rwho wastes system resources, but
ywho doesn't. It utilizes SUN RPC and XDR protocol.
.br
.sp
.nf
Host           User     tty      login at       idle  from host     
phaeton        Nobody logged on.
white          danb     console  Feb 27 16:06      3 
kafka          dave     console  Feb 24 09:39     49 
camus          ananth   console  Feb 24 20:22        
hyperion       luk      ttyp0    Feb 27 12:01   1:19  jacobi        
.fi
.br
.sp
When invoked with a hostname or netgroup argument, 
.I ywho 
will only perform a who on
that host or all the hosts in that netgroup, 
otherwise it will look for a list of hosts in $HOME/.yhosts.
If that file is not found, ywho will try to find the system default
yhosts file.
.br
.sp
The system ywho file is a list of hosts separated by white-space or 
commas. A `#' character signifies the beginning of a comment.
.sp
.br
A line of the form
.I timeout=<number>
specifies the number of seconds to timeout when waiting for a host 
to respond.
.sp
.br
Netgroups instead of hosts can be specified as:
.I netgroup=<netgroup>.
.br
.sp
If
.I ywho 
is invoked as
.I yusers,
then a more compact form of the information is presented in the form
of 
.I rusers(1).
.br
.sp
.nf
kafka         : dave
camus         : ananth
sibelius      : tlfine
jacobi        : luk
love          : phw phw phw
tcgould       : schinder metzger swb xputer cohen dsingh fielding
                fielding metzger mary chiang berggren leary danae
                beers scann beers
.fi
.br
.sp
If
.I ywho 
is invoked as
.I yuptime,
the uptime information for the hosts is presented, like
.I ruptime(1).
.br
.sp
.nf
phaeton         up   41+00:08,   1  user, load 0.19, 0.27, 0.04
hyperion        up   11+02:31,  12 users, load 0.43, 0.41, 0.30
eos             up   40+23:56,   1  user, load 0.00, 0.00, 0.00
tesla           up       8:29,   6 users, load 0.07, 0.25, 0.33
svax            up    1+06:20,  26 users, load 0.52, 1.38, 1.65
.fi
.br
.sp
.br
.sp
.SH OPTIONS
.TP 8
.I -g <netgroup>
Add all the hosts from the specified netgroup to the list of hosts
to be displayed.
.TP 8
.I -a
Show all users and hosts in 
.I ywho 
mode. By default only the hosts that have users that have been active
during the past hour are shown.
.TP 8
.I -t <timeout>
Change the default timeout value.
.SH AUTHORS 
James P. Lewis, York University, 1988
.br
Christos S. Zoulas, Cornell University, 1990-1993
.SH SEE ALSO
netgroup(5), yp(5)
.SH NOTE
When a host is down, it retries until timeout. It only works if your
server and clients are configured with SUN RPC.
