/*
 *  ReadList()  - opens a lolodex file and reads the data
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who                 why
 *  11/12/94    muquit@semcor.com   first cut
 */

#include "xhead.h"
#include "xymrolo.h"
#include <math.h>
#include "errcds.h"
#include "defines.h"



#define MaxStrSize 100000

int ReadList (fname)
char
    *fname;
{
    static char
        *filename = (char *) NULL;

    int
        rc;

    FILE
        *fp;
    
    char
        *name,
        *company,
        *address,
        *address2,
        *number1,
        *number2,
        *number3,
        *email,
        *text;

    char
        *s;
    
    int
        c;

    char
        Magick[20];
    char
        VersionStr[20];


#ifdef DEBUG
    (void) fprintf(stderr,
        "Global Temp filename: %s\n", GtempFilename);
#endif

    GrolodexModified = False;
    GwroteToTempfile = False;
    *VersionStr = '\0';
    *Magick = '\0';

    /*
    ** check if file is accessible
    */
    
    if (filename != (char *) NULL)
    {
        (void) free ((char *) filename);
        filename = (char *) NULL;
    }

    filename = mystrdup(fname);

    if (filename == (char *) NULL)
        Error ("Memory Allocation Failed!", (char *) NULL);

    rc = IsFileReadable (filename);

    switch (rc)
    {
        case 1:
        {
            /* OK */
            rolofile = filename;
            rc = 0;
            break;
        }

        case -1:    /* file does not exist */
        {
            rolofile = filename;
            return (rc);
            break;
        }
     
        case -4:    /* file is a directory */
        {
            rolofile = GtempFilename;
            GwroteToTempfile = True;
            return (rc);
            break;
        }

        case -2:    /* not a regular file */
        {
            rolofile = GtempFilename;
            GwroteToTempfile = True;
            return (rc);
            break;
        }

        case -3:    /* not readable ..try to make readable */
        {
            int
                rc2;

            rolofile = filename;
            rc2 = chmod (rolofile, S_IRUSR | S_IWUSR );
            if (rc2 < 0)    /* failed..probably owned by someone else */
            {
                rolofile = GtempFilename;
                GwroteToTempfile = True;
                return (rc);
            }
            rc = 0;
            break;
        }
    }


    if (rolofile == (char *) NULL)
    {
        Warning ("Memory Allocation Failed!", (char *) NULL);
        return (MALLOC_FAILED);
    }

    fp = fopen(rolofile, "r");

    if (fp == (FILE *) NULL)
    {
        Warning("Could not Open Card File:", rolofile);
        return (OPEN_FAILED);
    }
    

    /*
    ** check for magick code id it's a valid ymrolodex file
    */

    fgets(Magick, 19, fp);

    if (feof(fp))
    {
        (void) fprintf (stderr, "Unexpected EOF: %s\n", rolofile);
        (void) fclose ((FILE *) fp);
        return(UNEXPECTED_EOF);
    }

    if (strncmp(Magick, ROLODEX_MAGICK, (int)strlen(ROLODEX_MAGICK)) == 0)
    {
#ifdef DEBUG
        (void) fprintf (stderr, "Valid YRolodex file!\n");
#endif
    }
    else
    {
#ifdef DEBUG
        (void) fprintf (stderr,
            "Invalid YRolodex file..!\n");
#endif
        (void) fclose((FILE *)fp);
        /*
        ** Now we have to be careful here..even the file is not a valid
        ** Yrolo file..if the used add card/s this file will be used..so
        ** if it's an important file..data will be lost
        */
        rolofile = GtempFilename;
        GwroteToTempfile = True;
        return(INVALID_ROLODEX_FILE);
    }

    /*
    ** read the Version string
    */

    fgets(VersionStr, 19, fp);

    if (feof(fp))
    {
        (void) fprintf (stderr, "Unexpected EOF: %s\n", rolofile);
        (void) fclose ((FILE *) fp);
        return(UNEXPECTED_EOF);
    }
/*
** we will use the version number in fuure if anything changes in the
** data structure
*/

/*
    if (strncmp(VersionStr, VersionString, (int) strlen(VersionString)) == 0)
    {
        (void) strcpy (GversionString, VersionStr);
        (void) fprintf(stderr,
            "Version: %s\n", VersionStr);
    }
    else
    {
        (void) fprintf(stderr,
            "No Version string in the database!!!\n");

            return(NO_VERSION_STRING);
    }
*/

    /*
    ** free RoloList structure
    */

    if (RoloList != (RoloRec *) NULL)
    {
#ifdef DEBUG2
        (void) fprintf (stderr, "Freeing RoloList..\n");
#endif
        DestroyRoloRecords (&RoloList);
    }


    /*
    ** allocate space for name
    */

    name = (char *) malloc(sizeof(char)*200);
    company = (char *) malloc(sizeof(char)*200);
    address = (char *) malloc(sizeof(char)*2048);
    address2 = (char *) malloc(sizeof(char)*2048);
    number1 = (char *) malloc(sizeof(char)*100);
    number2 = (char *) malloc(sizeof(char)*100);
    number3 = (char *) malloc(sizeof(char)*100);
    email = (char *) malloc(sizeof(char)*200);
    text = (char *) malloc(sizeof(char)*MaxStrSize);

    if ((name == (char *) NULL) ||
        (company == (char *) NULL) ||
        (address == (char *) NULL) ||
        (address2 == (char *) NULL) ||
        (number1 == (char *) NULL) ||
        (number2 == (char *) NULL) ||
        (number3 == (char *) NULL) ||
        (email == (char *) NULL) ||
        (text == (char *) NULL))
    {
        Warning("Memory Allocation Failed!", "ReadList()");
        (void) fclose ((FILE *) fp);
        return(MALLOC_FAILED);
    }


    while (!feof(fp))
    {
        fgets(name, MaxStrSize, fp);

        if (feof(fp))
            break;

        s = index (name, '\f');

        if (s == (char *) NULL)
        {

            fgets (company, MaxStrSize, fp);
            s = index(company, '\f');

            if (s == (char *) NULL)
            {
                fgets (address, MaxStrSize, fp);
                s = index (address, '\f');
            }

            if (s == (char *) NULL)
            {
                fgets (address2, MaxStrSize, fp);
                s = index (address2, '\f');
            }

            if (s == (char *) NULL)
            {
                fgets (number1, MaxStrSize, fp);
                s = index(number1, '\f');
            }

            if (s == (char *) NULL)
            {
                fgets(number2, MaxStrSize, fp);
                s = index(number2, '\f');
            }

            if (s == (char *) NULL)
            {
                fgets(number3, MaxStrSize, fp);
                s = index(number3, '\f');
            }

            if (s == (char *) NULL)
            {
                fgets(email, MaxStrSize, fp);
                s = index (email, '\f');
            }

        }

        if (s != (char *) NULL)
        {
            ungetc(12, fp);
            *s = '\0';
        }

        s = text;

        while (True)
        {
            c = fgetc(fp);
            if (c < 1 || c == 12)
            {
                *s = '\0';
                break;
            }

            *s = (char) c;
            s++;
        }

        while (c != 12 && !feof(fp))
            c = fgetc(fp);

        MakeNewRolo (name, company, address, address2,
            number1, number2, number3, email, text, 0);

        for (c=fgetc(fp); c == '\n'; c = fgetc(fp));

        if (c != -1)
            ungetc((char) c, fp);
    }
    (void) fclose ((FILE *) fp);

    PutListOnScreen();
    ClearFields();

    return (rc);
}
