/*
 *  IsFileReadable()    -   checks if file is readable or not
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *      1   - legitimage file
 *      -1  - can not stat
 *      -4  - a directory
 *      -2  - not a regular file
 *      -3  - not readable
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  07/26/94    muquit  first cut
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

int IsFileReadable(file)
char
    *file;
{
    struct stat
        s_buf;

    /*
    ** if file can't be accessed (via stat()) return.
    */

    if (stat(file, &s_buf) == -1)
        return -1;
    else if ((s_buf.st_mode & S_IFMT) == S_IFDIR)   /* a directory */
        return -4;
    else if (!(s_buf.st_mode & S_IFREG))            /* not a regular file */
        return (-2);
    else if (access(file, R_OK) == -1)              /* not readable */
        return (-3);

    /*
    ** legitimate file
    */

    return 1;
}

#ifdef TEST
void main(argc, argv)
int
    argc;
char
    **argv;
{
    int
        rc2,
        rc;

    rc = IsFileReadable(argv[1]);

    switch (rc)
    {
        case 1:
        {
            (void) fprintf(stderr,"File is readable..\n");
            break;
        }
        case -1:
        {
            (void) fprintf(stderr,"Stat failed..file does not exist!\n");
            break;
        }

        case -4:
        {
            (void) fprintf(stderr,"File is a directory!\n");
            break;
        }

        case -3:
        {
            (void) fprintf(stderr,"File is not readable..changing mode..!\n");
            rc2 = chmod (argv[1], S_IRUSR | S_IWUSR);

            if (rc2 < 0)
                (void) fprintf(stderr,"Failed to change mode!\n");
            break;
        }

        default:
        {
            (void) fprintf(stderr,"Unknown error type!\n");
            break;
        }
    }
}
#endif /* TEST */
