/*
 *  GetSearchItems()    - extracts the matched list items from the name
 *                        list
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   24-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

void GetSearchItems (s)
char
    *s;
{
    RoloRec
        *rr;

    int
        n,
        i;

    unsigned int
        found = False;

    XmString
        *xmtable = (XmString *) NULL;

    char
        buf[100];

    memset (buf, 0, 100);

#ifdef DEBUG
    (void) fprintf (stderr,"string: %s\n",s);
#endif

    n = 0;
    for (rr=RoloList; rr != (RoloRec *) NULL; rr=rr->next)
    {
        if (rr->on == 1)
            n++;
    }

    if (n > 0)
        xmtable = (XmString *) calloc(n, sizeof(XmString));

    for (rr=RoloList, i=0; rr != (RoloRec *) NULL; rr=rr->next)
    {
        if (rr->on == 1)
        {
            found = True;
            (void) sprintf (buf, "%-30s", rr->name);
            buf[30] = '\0';

            xmtable[i] = XmStringCreateSimple (buf);
            i++;
        }
    }

    if (found == True)
    {
        XtManageChild (GsearchOutputdW);
        XtUnmapWidget (GsearchListW);
        XmListDeleteAllItems (GsearchListW);
        XmListAddItems (GsearchListW, xmtable,n, 0);
        XtMapWidget (GsearchListW);
        /*SetBusyCursorState (w_special[MAINWINDOW_W], True);*/
        SetCautionCursorState (w_special[MAINWINDOW_W], True);


        for (i=0; i < n; i++)
            XmStringFree (xmtable[i]);
        free (xmtable);

        (void) sprintf (buf, "Found %d matches!", n);
        WriteStatus(0,rolomessageTextW, buf);
    }
    else
    {
        (void) sprintf (buf, "No match found for the string: \"%s\"", s);
        WriteStatus(1,rolomessageTextW, buf);
    }
}
