/*
 *  CreateMessageDialog()   - create a message dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Output Parameters:
 *      type    identifier  description
 *      None
 *
 *  Return Values:
 *      value       description
 *      loc_message widget created
 *      
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      This function only creates the message widget.  It does not
 *      manage it nor set up any callbacks.  Both managment and callback
 *      setup must be done by the user in the calling function.
 *
 *  Development History:
 *      when            who     why
 *      06-Aug-1992     um      function creation
 */

#include "xhead.h"
#include "xymrolo.h"

Widget CreateMessageDialog (w, title, type, ok, cancel, help)
Widget
    w;
char
    *title;
int
    type;
int
    ok,
    cancel,
    help;
{

    Widget      loc_message,    /* message widget created */
                w_ok,           /* handle to ok button */
                w_cancel,       /* handle to cancel button */
                w_help;         /* handle to help button */
    Arg         wargs[10];      /* args for XtSetValues */
    int         i;              /* lcv */

    /*
    ** Set up message dialog box.
    */

    loc_message = (Widget) NULL;

    i = 0;
    XtSetArg (wargs[i], XmNtitle, title); i++;
    XtSetArg (wargs[i], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL);
    i++;
    XtSetArg (wargs[i], XmNdialogType, type); i++;

    switch ( (int) type)
    {
        case (int) XmDIALOG_ERROR:
            loc_message = XmCreateErrorDialog (w, "DError", 
                wargs, i);
            break;
        case (int) XmDIALOG_INFORMATION:
            loc_message = XmCreateInformationDialog (w, "Info", 
                wargs, i);
            break;
        case (int) XmDIALOG_QUESTION:
            loc_message = XmCreateQuestionDialog (w, "Question", 
                wargs, i);
            break;
        case (int) XmDIALOG_WARNING:
            loc_message = XmCreateWarningDialog (w, "Warning", 
                wargs, i);
            break;
        case (int) XmDIALOG_WORKING:
            loc_message = XmCreateWorkingDialog (w, "Working", 
                wargs, i);
            break;
    } /* end switch */
    
    /*
    ** Umanage appropriate buttons.
    */

    if (ok)
    {
        w_ok = XmMessageBoxGetChild (loc_message, XmDIALOG_OK_BUTTON);
        XtUnmanageChild (w_ok);
    } /* endif ok */
    if (cancel)
    {
        w_cancel = XmMessageBoxGetChild (loc_message, XmDIALOG_CANCEL_BUTTON);
        XtUnmanageChild (w_cancel);
    } /* endif cancel */
    if (help)
    {
        w_help = XmMessageBoxGetChild (loc_message, XmDIALOG_HELP_BUTTON);
        XtUnmanageChild (w_help);
    } /* endif help */

    /*
    ** Return the created widget.
    */

    return (loc_message);
    
} /* end CreateMessageDialog */
