/*
 *  CreateFields()  - create rolodex field widgets etc
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   02-Jan-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"


void CreateFields (parent) /* parent is a form here */
Widget
    parent;
{
    register int
        n;

    Arg
        args[15];
        
    Widget
        vsbW,
        hsbW,
        formW,

        nameLabW,

        companyLabW,

        addressLabW,

        hphoneLabW,
        
        wphoneLabW,

        faxLabW,

        emailLabW,

        remarksLabW;


    Pixel
        scb_bg;

    formW = XtVaCreateWidget ("Fieldform",
        xmFormWidgetClass, parent,
        NULL);  

    /*
    ** Name Label
    */

    nameLabW = XtVaCreateManagedWidget ("Name",
        xmLabelGadgetClass, formW,
        XmNtopAttachment, XmATTACH_FORM,
        XmNleftAttachment,      XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        XmNtopOffset, 5,
        NULL);

    XtAddCallback (nameLabW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_NAME_HELP);

    /*
    ** Name Text
    */

     GVnametextW = XtVaCreateManagedWidget ("FieldText",
        xmTextFieldWidgetClass, formW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_FORM,
        XmNeditable, False,
        XmNcursorPositionVisible, False,
        XmNtopOffset, 5,
        NULL);

    XtAddCallback (GVnametextW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_NAME_HELP);

    /*
    ** Company Label
    */

    companyLabW = XtVaCreateManagedWidget ("Company",
        xmLabelGadgetClass, formW,
        XmNleftAttachment,      XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVnametextW,
        NULL);

    XtAddCallback (companyLabW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_COMPANY_HELP);
    /*
    ** create Company Text
    */

    GVcompanyTextW = XtVaCreateManagedWidget ("FieldText",
        xmTextFieldWidgetClass, formW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVnametextW,
        XmNeditable, False,
        XmNcursorPositionVisible, False,
        NULL);
    XtAddCallback (GVcompanyTextW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_COMPANY_HELP);

    /*
    ** address Label
    */

    addressLabW = XtVaCreateManagedWidget ("Address",
        xmLabelGadgetClass, formW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVcompanyTextW,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    XtAddCallback (addressLabW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_ADDRESS_HELP);

    /*
    ** address Text
    */

    GVaddressTextW = XtVaCreateManagedWidget ("FieldText",
        /*xmTextFieldWidgetClass, formW,*/
        xmTextWidgetClass, formW,
        XmNeditMode, XmMULTI_LINE_EDIT,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVcompanyTextW,
        XmNeditable, False,
        XmNcursorPositionVisible, False,
        XmNrows, (short)2,
        NULL);

    XtAddCallback (GVaddressTextW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_ADDRESS_HELP);
    /*
    ** home phone label
    */

    hphoneLabW = XtVaCreateManagedWidget ("Phone1",
        xmLabelGadgetClass, formW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVaddressTextW,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    XtAddCallback (hphoneLabW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_PH1_HELP);

    /*
    ** home phone Text
    */

    GVphone1TextW = XtVaCreateManagedWidget ("FieldText",
        xmTextFieldWidgetClass, formW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVaddressTextW,
        XmNeditable, False,
        XmNcursorPositionVisible, False,
        NULL);

    XtAddCallback (GVphone1TextW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_PH1_HELP);

    /*
    ** Work Phone Lab
    */

    wphoneLabW = XtVaCreateManagedWidget ("Phone2",
        xmLabelGadgetClass, formW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVphone1TextW,
        XmNalignment,   XmALIGNMENT_END,
        NULL);
    XtAddCallback (wphoneLabW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_PH2_HELP);


    /*
    ** Work phone Text
    */

    GVphone2TextW = XtVaCreateManagedWidget ("FieldText",
        xmTextFieldWidgetClass, formW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVphone1TextW,
        XmNeditable, False,
        XmNcursorPositionVisible, False,
        NULL);

    XtAddCallback (GVphone2TextW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_PH2_HELP);
    /*
    ** Fax Label
    */

    faxLabW = XtVaCreateManagedWidget ("Fax",
        xmLabelGadgetClass, formW,
        XmNleftAttachment, XmATTACH_FORM,    
        XmNrightAttachment, XmATTACH_POSITION, 
        XmNrightPosition, 18,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVphone2TextW,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    XtAddCallback (faxLabW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_FAX_HELP);

    /*
    ** Fax Text
    */

    GVfaxTextW = XtVaCreateManagedWidget ("FieldText",
        xmTextFieldWidgetClass, formW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,   
        XmNtopWidget, GVphone2TextW,
        XmNeditable, False,
        XmNcursorPositionVisible, False,
        NULL);

    XtAddCallback (GVfaxTextW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_FAX_HELP);

    /*
    ** E-mail Label
    */
    emailLabW = XtVaCreateManagedWidget ("Email",
        xmLabelGadgetClass, formW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVfaxTextW,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    XtAddCallback (emailLabW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_EMAIL_HELP);

    /*
    ** Email Text
    */
    GVemailTextW = XtVaCreateManagedWidget ("MemailText",
        xmTextFieldWidgetClass, formW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVfaxTextW,
        XmNeditable, False,
        XmNcursorPositionVisible, False,
        NULL);

    XtAddCallback (GVemailTextW, XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_EMAIL_HELP);

    /*
    ** Remarks Label
    */

    remarksLabW = XtVaCreateManagedWidget ("Remarks",
        xmLabelGadgetClass, formW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GVemailTextW,
        XmNtopOffset, (int) 20,
        NULL);

    XtAddCallback (remarksLabW , XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_REMARKS_HELP);

    /*
    ** Comment Text
    */
    n = 0;
    XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT);  n++;
    XtSetArg (args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, formW); n++;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNeditable, False); n++;
    XtSetArg (args[n], XmNcursorPositionVisible, False);    n++;
    XtSetArg (args[n], XmNhighlightThickness, 0);       n++;

    GVcommentTextW = XmCreateScrolledText (parent, "FCommentext",
        args, n);

    XtAddCallback (GVcommentTextW , XmNhelpCallback,
        HelpCB, (XtPointer) VIEW_SCREEN_REMARKS_HELP);
    /*
    ** set the scroll bar colors
    */
      
    scb_bg = (Pixel) AllocateNamedColor(XtDisplay(w_special[TOPLEVEL_W]),
        scb_bgcolor);

    if (scb_bg > 256)   /* Parse error */
    {
        /*
        ** set the color as same as the bg of the toplevel W   
        */
        XtVaGetValues(w_special[TOPLEVEL_W],
            XmNbackground, &scb_bg,
            NULL);
    }        
    XtVaGetValues(XtParent(GVcommentTextW),
        XmNverticalScrollBar, &vsbW,
        XmNhorizontalScrollBar, &hsbW,
        NULL);

    SetScrollbarColors(vsbW, hsbW, scb_bg);

    XtManageChild (formW);
    XtManageChild (GVcommentTextW);

    
}
