/*
 *  AskUser()   - Ask yes/no question, goes to a simulated loop untill
 *                  it gets an answer
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      Adapted from Dan's book..page 153 vol 6
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  07/12/94    muquit  first cut
 */

#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"


int AskUser(parent, message)
Widget
    parent;

char
    *message;

{
    Widget
        overwritedW;

    XmString
        yes,
        no,
        text;
    
    static int  
        answer;
    
    Arg
        args[5];
    
    int
        n;

    answer = 0;

    XBell(XtDisplay(w_special[TOPLEVEL_W]),99);

    n = 0;
    XtSetArg (args[n], XmNtitle, "Confirm");    n++;

    overwritedW = XmCreateQuestionDialog(parent, "Confirm",
        args, n);

    yes = XmStringCreateSimple("Yes");
    no = XmStringCreateSimple("No");

    XtVaSetValues(overwritedW,
        XmNdialogStyle,        XmDIALOG_PRIMARY_APPLICATION_MODAL,
        XmNokLabelString,      yes,
        XmNcancelLabelString,  no,
        NULL);
    
    XtAddCallback (overwritedW, XmNokCallback, (XtCallbackProc) Response,
        &answer);
    
    XtAddCallback (overwritedW, XmNcancelCallback, (XtCallbackProc) Response,
        &answer);

    XtUnmanageChild (XmMessageBoxGetChild(overwritedW,
        XmDIALOG_HELP_BUTTON));

    text = XmStringCreateSimple(message);

    XtVaSetValues (overwritedW,
        XmNmessageString,      text,
        NULL);

    XmStringFree (text);
    XmStringFree (yes);
    XmStringFree (no);
        
    XtManageChild (overwritedW);
    XtPopup (XtParent(overwritedW), XtGrabNone);

    /*
    ** simulate main loop until user provides an answer.  Whenever an
    ** answer is received, "answer" changes from callback routine.
    ** If we do not simulate main loop, control will be handed over to
    ** main main loop and we won't have chance to take action after
    ** getting the answer
    */

    while (answer == 0 ||
        XtAppPending(XtWidgetToApplicationContext(overwritedW)))

    XtAppProcessEvent(XtWidgetToApplicationContext(overwritedW),
        XtIMAll);

    XtPopdown(XtParent(overwritedW));
    return (answer);
}

void Response (widget,ans, cbs)
Widget
    widget;

XtPointer
    ans;

XmAnyCallbackStruct 
    *cbs;
{
    int
        *answer;

    answer = (int *) ans;

    switch (cbs->reason)
    {
        case XmCR_OK:
            *answer = YES;
            break;

        case XmCR_CANCEL:
            *answer = NO;
            break;
    }
}
