

#include "yodl2html-post.h"

void 
tocentry (STRINGTAB tab)
{
  int
    i, new_toclevel;

  if (!pass)			/* first pass: update */
    {				/* table of conents file */
      if (tab.nstr < 6)
	error ("incomplete tocentry tag");

      new_toclevel = toclevel (tab.str[3]);
      if (cur_toclevel < new_toclevel)
	{
	  output (tocf, "<dl><p>\n");
	}
      else if (cur_toclevel != 0 && (cur_toclevel > new_toclevel))
	{
	  i = cur_toclevel;
	  while (i > new_toclevel)
	    {
	      output (tocf, "</dl><p>\n");
	      i--;
	    }
	}
      output (tocf, "<dt>");
      if (doctype == type_article)
	{
	  switch (new_toclevel)
	    {
	    case TOC_SECTION:
	      output (tocf, "<h2>");
	      break;
	    case TOC_SUBSECT:
	      output (tocf, "<h3>");
	      break;
	    }
	}
      else
	{
	  switch (new_toclevel)
	    {
	    case TOC_CHAPTER:
	      output (tocf, "<h2>");
	      break;
	    case TOC_SECTION:
	      output (tocf, "<h3>");
	      break;
	    }
	}
      output (tocf, "<a href=\"%s#l%d\">", curbase, ++lastlabelnr);
      for (i = 5; i < tab.nstr; i++)
	{
	  if ((i == tab.nstr - 1) && (strcmp (tab.str[i], " ") == 0))
	    continue;

	  fprintf (tocf, "%s", tab.str[i]);
	}
      output (tocf, "</a>");
      if (doctype == type_article)
	{
	  switch (new_toclevel)
	    {
	    case TOC_SECTION:
	      output (tocf, "</h2>");
	      break;
	    case TOC_SUBSECT:
	      output (tocf, "</h3>");
	      break;
	    }
	}
      else
	{
	  switch (new_toclevel)
	    {
	    case TOC_CHAPTER:
	      output (tocf, "</h2>");
	      break;
	    case TOC_SECTION:
	      output (tocf, "</h3>");
	      break;
	    }
	}
      output (tocf, "\n");
      cur_toclevel = new_toclevel;
    }
  else
    /* second pass: paste */
    {				/* internal label in output */
      output (outf, "<a name=\"l%d\"></a>\n",
	      ++lastlabelnr);
    }
}
