
#include "yodl2html-post.h"

void 
label (STRINGTAB t)
{
  int
    i;
  char
   *labname = 0, *cp;

  if (t.nstr < 4)
    error ("incomplete label tag");

  for (i = 3; i < t.nstr; i++)	/* make full label of substrings */
    labname = str_concat (labname, t.str[i]);

  for (cp = labname; *cp;)	/* remove spaces, if any */
    if (isspace (*cp))
      strcpy (cp, cp + 1);
    else
      cp++;

  if (!pass)			/* first pass: enter label */
    {
      for (i = 0; i < nlab; i++)	/* check for duplicates */
	if (!strcmp (lab[i].label, labname))
	  {
	    warning ("label %s already defined, ignored", labname);
	    return;
	  }

      /* enter label in table */
      lab = (LABEL *) xrealloc (lab, (nlab + 1) * sizeof (LABEL));
      lab[nlab].label = xstrdup (labname);
      lab[nlab].value = xstrdup (lastnum);
      lab[nlab].fname = xstrdup (curbase);

      nlab++;
    }
  else				/* second pass: set anchor */
    output (outf, "<a name=\"%s\"></a>", labname);

  free (labname);
}
