
#include "lib.h"

char
  out_of_memory[] = "memory allocation failed";


void *
xrealloc (void *mem, int newsz)
{
  if (!newsz)
    {
      if (mem)
	free (mem);
      return (0);
    }

  if (!mem)
    mem = (void*) malloc (newsz);
  else
    mem = (void*) realloc (mem, newsz);

  if (!mem)
    error (out_of_memory);

  return (mem);
}
