/*-
 * Copyright (c) 2003, 2005 Allan Saddi <allan@saddi.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY ALLAN SADDI AND HIS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL ALLAN SADDI OR HIS CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: common.c 1816 2005-09-02 00:14:04Z asaddi $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if HAVE_INTTYPES_H
# include <inttypes.h>
#else
# if HAVE_STDINT_H
#  include <stdint.h>
# endif
#endif

#ifdef HAVE_LIBGEN_H
#include <libgen.h>
#endif /* HAVE_LIBGEN_H */

#include "common.h"

#ifndef lint
static const char rcsid[] =
	"$Id: common.c 1816 2005-09-02 00:14:04Z asaddi $";
#endif /* !lint */

const char *prog;
uint8_t *HashBuffer;

void
yaficError (const char *what)
{
  fprintf (stderr, "%s: %s: %s\n", prog, what, strerror (errno));
  exit (1);
}

void
yaficWarning (const char *what)
{
  fprintf (stderr, "%s: %s: %s\n", prog, what, strerror (errno));
}

void *
mymalloc (size_t size)
{
  void *buf;

  if (!(buf = malloc (size)))
    yaficError ("malloc()");
  return buf;
}

char *
mystrdup (const char *str)
{
  char *newStr;

  if (!(newStr = strdup (str)))
    yaficError ("strdup()");
  return newStr;
}

char *
mydirname (const char *path)
{
  char *tmp, *tmp2, *res;

  /* Just in case dirname() actually overwrites path. */
  tmp = mystrdup (path);
  if (!(tmp2 = dirname (tmp)))
    yaficError ("dirname");
  /* Just in case dirname() returns static storage. */
  res = mystrdup (tmp2);
  free (tmp);
  /* Caller is responsible for freeing result. */
  return res;
}
