dnl APS_CHECK_STAT_SIZEOF(TYPE [, CROSS-SIZE])
AC_DEFUN(APS_CHECK_STAT_SIZEOF,
[changequote(<<, >>)dnl
dnl The name to #define.
define(<<APS_TYPE_NAME>>, translit(sizeof_stat_$1, [a-z *], [A-Z_P]))dnl
dnl The cache variable name.
define(<<APS_CV_NAME>>, translit(ac_cv_sizeof_$1, [ *], [_p]))dnl
changequote([, ])dnl
AC_MSG_CHECKING(size of struct stat's $1)
AC_CACHE_VAL(APS_CV_NAME,
[AC_TRY_RUN([#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
main()
{
  struct stat sb;
  FILE *f=fopen("conftestval", "w");
  if (!f) exit(1);
  fprintf(f, "%d\n", sizeof(sb.$1));
  exit(0);
}], APS_CV_NAME=`cat conftestval`, APS_CV_NAME=0, ifelse([$2], , , APS_CV_NAME=$2))
])dnl
AC_MSG_RESULT($APS_CV_NAME)
AC_DEFINE_UNQUOTED(APS_TYPE_NAME, $APS_CV_NAME, [Define to the size of struct stat's $1])
undefine([APS_TYPE_NAME])dnl
undefine([APS_CV_NAME])dnl
])

AC_DEFUN([APS_SEARCH_BDB_185_HEADER],
[AC_CACHE_CHECK([for Berkeley DB 1.xx header], [aps_cv_bdb_header],
[aps_cv_bdb_header="not found"
for aps_header in db.h db1/db.h db_185.h db4/db_185.h db3/db_185.h db2/db_185.h; do
  AC_EGREP_CPP([(dbopen|db185_open)], [#include <$aps_header>],
	       [aps_cv_bdb_header=$aps_header
break])
done
])])

AC_DEFUN([APS_SEARCH_BDB_185_LIB],
[AC_REQUIRE([APS_SEARCH_BDB_185_HEADER])dnl
AC_CACHE_CHECK([for Berkeley DB 1.xx library], [aps_cv_bdb_lib],
[aps_cv_bdb_save_LIBS=$LIBS
aps_cv_bdb_lib=no
AC_TRY_LINK([#include <$aps_cv_bdb_header>], [dbopen (0, 0, 0, DB_HASH, 0);],
	    [aps_cv_bdb_lib="none required"])
if test "$aps_cv_bdb_lib" = "no"; then
  for aps_lib in db db1 db4 db3 db2; do
    LIBS="-l$aps_lib $aps_cv_bdb_save_LIBS"
    AC_TRY_LINK([#include <$aps_cv_bdb_header>],
		[dbopen (0, 0, 0, DB_HASH, 0);],
		[aps_cv_bdb_lib="-l$aps_lib"
break])
  done
fi
LIBS=$aps_cv_bdb_save_LIBS])
if test "$aps_cv_bdb_lib" != "no"; then
  test "$aps_cv_bdb_lib" = "none required" || LIBS="$aps_cv_bdb_lib $LIBS"
fi
])

AC_DEFUN([APS_FUNC_EVP_DIGESTINIT_VOID],
[AC_CACHE_CHECK([whether EVP_DigestInit returns void],
		[aps_cv_func_evp_digestinit_void],
[AC_RUN_IFELSE([AC_LANG_PROGRAM([AC_INCLUDES_DEFAULT
#include <openssl/evp.h>
#ifndef __cplusplus
int EVP_DigestInit ();
#endif
],
		   [[EVP_MD_CTX ctx;
exit (EVP_DigestInit (&ctx, EVP_md_null ()) == 0);]])],
		   [aps_cv_func_evp_digestinit_void=no],
		   [aps_cv_func_evp_digestinit_void=yes],
		   [aps_cv_func_evp_digestinit_void=yes])])
if test "$aps_cv_func_evp_digestinit_void" = "yes"; then
  AC_DEFINE(EVP_DIGESTINIT_VOID, 1,
	    [Define to 1 if the `EVP_DigestInit' function and friends return
	     void instead of `int'.])
fi
])