
#define RIFF_MAGIC 0x46464952
#define WAVE_MAGIC 0x45564157
#define FMT_MAGIC 0x20746D66
#define DATA_MAGIC 0x61746164
#define INFO_MAGIC 0x4F464E49

#define RIFF_PCM 1
#define RIFF_MS_ADPCM 2
#define RIFF_ALAW 6
#define RIFF_MULAW 7
#define RIFF_CL_ADPCM 512
#define RIFF_IMA_ADPCM 17
/* this is not a standard, i took the compression from Jack Jansen, 
 * see directory adpcm2pcm
 */
#define RIFF_IDVI_ADPCM 1024

typedef struct {
   long riff;
   ulong length;
   long wave;
} RiffHeader;

typedef struct {
   long fmt;
   ulong chunk_length;
   short format;
   short modus;
   ulong freq;
   ulong bpsec;
   short bpspl;
   short res;
} FmtHeader;

bool is_riff(int fd);
int riff_open(Audio_File *af,int mode);
int riff_read(Audio_File af,char *buffer,int size);
int riff_write(Audio_File af,char *buffer,int size);
int riff_seek(Audio_File af,int pos,int mode);
int riff_close(Audio_File af);

