/* 
 * xwave - an interactive audio player, recorder, editor 
 * for the XWindow System
 * 
 * Copyright (C) 1996 Kai Kollmorgen
 * (kkollmor@informatik.uni-rostock.de)
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <stdio.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>          /* Shell Definitions */

#include <X11/Xaw/Command.h>    /* Athena Command Widget */
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
 
#include "types.h"
#include "xwave.h"
#include "xwave_widget.h"
#include "misc.h"

static void about_popup (Widget w);
static void popdown_CB(Widget w, XtPointer client_data, XtPointer call_data);


void about_call(Widget w, XtPointer client_data, XtPointer call_data)
{
	about_popup(XtParent(w));
}

void help_call(Widget w, XtPointer client_data, XtPointer call_data)
{
	about_popup(XtParent(w));
}

void popdown_CB(Widget w, XtPointer client_data, XtPointer call_data)
{
   XtPopdown((Widget) client_data);
}

void about_popup (Widget w)
{
   Widget popup,form,label,button;
   Dimension width_l,width_b;
   char message[MAX_NAMELENGTH];
   
   popup=XtVaCreatePopupShell("ab_shell",transientShellWidgetClass,w,NULL);

   form  = MW ("aboutform",formWidgetClass,popup,NULL);

   sprintf(message,"xwave version %s\n",VERSION);
   strcat( message,"(c) 1996 kkollmor@informatik.uni-rostock.de\n\n");
   label = MW ("aboutlabel1",labelWidgetClass,form,
		XtNlabel,message,
		XtNborderWidth,0,
		NULL);

   button = MW ("ab_ok_btn",commandWidgetClass,form,
    		XtNfromVert,label,
    		XtNtop,XawChainTop,XtNbottom,XawChainTop,
    		XtNleft,XawChainLeft,XtNright,XawChainLeft,NULL);

   XtAddCallback(button,XtNcallback,popdown_CB,(XtPointer) popup);
   XtVaGetValues(label,XtNwidth, &width_l, NULL);
   XtVaGetValues(button,XtNwidth, &width_b, NULL);
   XtVaSetValues(button,XtNhorizDistance, (width_l/2)-(width_b/2), NULL);

   popup_centered(popup);
}

