/*
 * gtk2_options.c
 *
 * this file contains the options dialog for the GTK2 control
 *
 * Copyright (C) 2003,04 Karl H. Beckers, Frankfurt
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "../config.h" //autoconf output

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Intrinsic.h>
#ifdef HAVE_LIBZ
#include <zlib.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "job.h"
#include "capture.h"
#include "app_data.h"
#include "util.h"
//#include "codecs.h"
#include "gtk2_support.h"

#define GLADE_HOOKUP_OBJECT(component, widget, name) \
    g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component, widget, name) \
    g_object_set_data (G_OBJECT (component), name, widget)

#define OPS_FILE        ".xvidcap.scf"


static Job *sJob;
extern tCodecs;
extern const char * const tCodecNames[];
extern const char * const tCodec2ffmpeg[];


// need to define this here, because we're calling it from
// an event here
extern GtkWidget *window1;

static GtkWidget *dialog1;
static GtkWidget *pref_quality;
static GtkWidget *pref_compress;
static GtkWidget *pref_frames_per_sec;
static GtkWidget *pref_filename;
static GtkWidget *pref_max_frames;
static GtkWidget *pref_max_time;
static GtkWidget *pref_continue;
static GtkWidget *pref_codec;
static GtkWidget *pref_use_shm;
static GtkWidget *pref_capture_mouse;
static GtkWidget *radio_black;
static GtkWidget *hbox5;
#ifdef HAVE_FFMPEG_AUDIO
static GtkWidget *pref_audio;
static GtkWidget *pref_audio_device;
static GtkWidget *pref_audio_rate;
static GtkWidget *pref_audio_bits;
static GtkWidget *pref_audio_channels;
#endif // HAVE_FFMPEG_AUDIO

extern GtkWidget *previous, *next, *filename, *MI_continue;
extern GtkTooltips *tooltips;

// first callbacks here ...
//
//

void doOk () {
#include "codecs.h"
    
    char *str;
    int val_int;
    float val_float;
    char *home;
    char file[PATH_MAX+1];
    FILE *fp;
    Job *job = (Job *) sJob ;
    
    val_int = gtk_adjustment_get_value (GTK_ADJUSTMENT (GTK_RANGE (pref_quality)->adjustment));
    job_set_quality (val_int);
    
    val_int = gtk_adjustment_get_value (GTK_ADJUSTMENT (GTK_RANGE (pref_compress)->adjustment));
    job_set_compression (val_int);
    
    // FIXME: Check if we need fps as float value
    val_int = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (pref_frames_per_sec));
    val_float = (float) val_int;
    //g_print("converted int to float: %e\n", val_float);
    job_set_fps (val_float);
    
    str = (String) gtk_entry_get_text ( GTK_ENTRY (pref_filename) );
    //printf("file_str: %s\n", str);
    if (str) {
        job_set_file (str);
    }
    
    val_int = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (pref_max_frames));
    job->max_frames = val_int;
    
    //FIXME: Check if we really need max_time as float value
    val_int = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (pref_max_time));
    val_float = (float) val_int;
    job->max_time = val_float;
    
    if (gtk_entry_get_text (GTK_ENTRY (pref_codec))!=NULL) {
        int i, a = -1;
        Boolean found = FALSE;
        
        for (i = 0; i < NUMCODECS; i ++) {
            if (strcmp (tCodecNames[i], gtk_entry_get_text (GTK_ENTRY (pref_codec))) == 0) a = i;
        }
        if (a < CODEC_MPEG1) {
            a = CODEC_MPEG1;
            fprintf (stderr, "Unsupported Codec selected, resetting to MPEG1!\n");
        }
        job->targetCodec = a;
        //g_print("codec: %s\n", tCodecNames[a]);
    }
    
#ifdef HAVE_SHMAT
        if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (pref_use_shm))) {
            job->flags |= FLG_USE_SHM;
            job_set_capture ();
            //g_print("true - use shm: %i\n", (job->flags & FLG_USE_SHM));
        } else {
            job->flags &= ~FLG_USE_SHM;
            job_set_capture ();
            //g_print("false - use shm: %i\n", (job->flags & FLG_USE_SHM));
        }
#endif

        if ( gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (pref_capture_mouse))) {
            if ( gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radio_black))) {
                job->mouseWanted = 2;
            } else {
                job->mouseWanted = 1;
            }
        } else {
            job->mouseWanted = 0;
        }
        
#ifdef HAVE_FFMPEG_AUDIO
        if ( gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (pref_audio))) {
            job->flags |= FLG_AUDIO_WANTED;
        } else {
            job->flags &= ~FLG_AUDIO_WANTED;
        }
        
        str = (char*) gtk_entry_get_text ( GTK_ENTRY (pref_audio_device) );
        //printf("audio device: %s\n", str);
        if (str) {
            job->snd_device = strdup(str);
        }
        val_int = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (pref_audio_rate));
        job->snd_rate = val_int;
        val_int = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (pref_audio_bits));
        job->snd_smplsize = val_int;
        val_int = gtk_adjustment_get_value (GTK_ADJUSTMENT (GTK_RANGE (pref_audio_channels)->adjustment));
        job->snd_channels = val_int;
#endif // HAVE_FFMPEG_AUDIO

        if ( gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (pref_continue))) {
            job->flags |= FLG_AUTO_CONTINUE;
        } else {
            job->flags &= ~FLG_AUTO_CONTINUE;
        }
/*        // unset autocontinue unless we capture to movie and file is mutable
        if ( job->flags & FLG_AUTO_CONTINUE && ( (! is_filename_mutable(job->file)) ||
                (! job->flags & FLG_MULTI_IMAGE) ) ) {
            job->flags &= ~FLG_AUTO_CONTINUE;
            fprintf(stderr, "Output not a video file or no counter in filename\nDisabling autocontinue!\n");
        } */

    /* previous and next buttons have different meanings for on-the-fly encoding
     * and individual frame capture ... this sets the tooltips accordingly */
    if (( job->flags & FLG_MULTI_IMAGE ) == 0 ) {
        gtk_tooltips_set_tip (tooltips, previous, "Move cursor back one frame",
                "Move cursor back one frame");
        gtk_tooltips_set_tip (tooltips, next, "Move cursor to next frame",
                "Move cursor to next frame");
        gtk_tooltips_set_tip (tooltips, filename, "Reset frame counter and filename",
                "Reset frame counter and filename");
        if (job->pic_no > job->step ) gtk_widget_set_sensitive(previous, TRUE);
        else gtk_widget_set_sensitive(previous, FALSE);
    } else {
        if ( is_filename_mutable(job->file) ) {
            gtk_widget_set_sensitive(next, TRUE);
            if (job->movie_no > 0 ) gtk_widget_set_sensitive(previous, TRUE);
            else gtk_widget_set_sensitive(previous, FALSE);
        } else {
            gtk_widget_set_sensitive(next, FALSE);
            gtk_widget_set_sensitive(previous, FALSE);
        }
        gtk_tooltips_set_tip (tooltips, previous, "Move cursor to previous movie",
                "Move cursor to previous movie");
        gtk_tooltips_set_tip (tooltips, next, "Move cursor to next movie",
                "Move cursor to next movie");
        gtk_tooltips_set_tip (tooltips, filename, "Reset movie counter to zero",
                "Reset movie counter to zero");
    }

    // unset autocontinue unless we capture to movie and file is mutable
    if ( job->flags & FLG_AUTO_CONTINUE && ( (! is_filename_mutable(job->file)) ||
                (job->flags & FLG_MULTI_IMAGE) == 0) ) {
        job->flags &= ~FLG_AUTO_CONTINUE;
        printf("Output not a video file or no counter in filename\nDisabling autocontinue!\n");
    } 
    if ( job->flags & FLG_MULTI_IMAGE ) {
        if ( job->flags & FLG_AUTO_CONTINUE ) {
            gtk_widget_set_sensitive(GTK_WIDGET(MI_continue), TRUE);
            gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(MI_continue), TRUE);
        } else {
            if ( is_filename_mutable(job->file)) {
                gtk_widget_set_sensitive(GTK_WIDGET(MI_continue), TRUE);
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(MI_continue), FALSE);
            } else {
                gtk_widget_set_sensitive(GTK_WIDGET(MI_continue), FALSE);
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(MI_continue), FALSE);
            }
        }
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(MI_continue), FALSE);
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(MI_continue), FALSE);
    }
    
}


void
on_dialog1_response (GtkDialog *dialog, gint response_id, gpointer user_data) {
    //printf("response id : %i \n", response_id);
    switch (response_id) {
        case GTK_RESPONSE_OK:
            doOk ();
            GtkChangeLabel (sJob->pic_no);
            break;
        case GTK_RESPONSE_CANCEL:
            
            break;
        default:
            break;
    }
}


gboolean
on_dialog1_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data) {
    return FALSE;
}

void
on_dialog1_close (GtkDialog *dialog, gpointer user_data) {
    // empty as yet ...
}

void
on_dialog1_destroy (GtkButton *button, gpointer user_data) {
    // empty as yet ...
}

void
on_pref_capture_mouse_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    if ( gtk_toggle_button_get_active ( togglebutton ) ) {
        gtk_widget_set_sensitive ( hbox5, TRUE );
    } else {
        gtk_widget_set_sensitive ( hbox5, FALSE );
    }
    
}


#ifdef HAVE_FFMPEG_AUDIO
void
on_pref_audio_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    if ( gtk_toggle_button_get_active ( togglebutton ) ) {
        gtk_widget_set_sensitive ( pref_audio_rate, TRUE );
        gtk_widget_set_sensitive ( pref_audio_bits, TRUE );
        gtk_widget_set_sensitive ( pref_audio_channels, TRUE );
    } else {
        gtk_widget_set_sensitive ( pref_audio_rate, FALSE );
        gtk_widget_set_sensitive ( pref_audio_bits, FALSE );
        gtk_widget_set_sensitive ( pref_audio_channels, FALSE );
    }
    
}
#endif // HAVE_FFMPEG_AUDIO


// now the widget ...
//
//

GtkWidget*
create_dialog1 (Job *mJob) {
#include "codecs.h"

    GtkWidget *dialog_vbox1;
    GtkWidget *table1;
    GtkWidget *combo1;
    GtkWidget *pref_label;
    GtkObject *pref_frames_per_sec_adj;
    GtkObject *pref_max_frames_adj;
    GtkObject *pref_max_time_adj;
    GtkWidget *label6;
    GtkWidget *label7;
    GtkWidget *label8;
    GtkWidget *label9;
    GtkWidget *label10;
    GtkWidget *label11;
    GtkWidget *label12;
    GtkWidget *label13;
    GtkWidget *label14;
    GtkWidget *dialog_action_area1;
    GtkWidget *pref_ok;
    GtkWidget *alignment1;
    GtkWidget *hbox2;
    GtkWidget *image8;
    GtkWidget *label1;
    GtkWidget *alignment2;
    GtkWidget *hbox3;
    GtkWidget *image9;
    GtkWidget *label2;
    GtkWidget *pref_cancel;
    GtkWidget *alignment3;
    GtkWidget *hbox4;
    GtkWidget *image10;
    GtkWidget *label3;
    GtkTooltips *tooltips;

    GtkWidget *radio_white;
    GSList *mouse_color_group = NULL;
    
#ifdef HAVE_FFMPEG_AUDIO
    GtkWidget *frame1;
    GtkWidget *table2;
    GtkWidget *label15;
    GtkObject *pref_audio_rate_adj;
    GtkObject *pref_audio_bits_adj;
#endif // HAVE_FFMPEG_AUDIO
    
    GList *glist = NULL;
    int x;

    tooltips = gtk_tooltips_new ();
    
    dialog1 = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (dialog1), _ ("Preferences"));
    gtk_window_set_modal (GTK_WINDOW (dialog1), TRUE);
    
    dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
    gtk_widget_show (dialog_vbox1);
    
    table1 = gtk_table_new (10, 2, FALSE);
    gtk_widget_show (table1);
    gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
    
    //combobox for MPEG codecs
    combo1 = gtk_combo_new ();
    for (x = 1; x < NUMCODECS; x++) {
        glist = g_list_append (glist, (char*) tCodecNames[x]);
    }
    gtk_combo_set_popdown_strings (GTK_COMBO (combo1), glist);
    gtk_combo_set_value_in_list (GTK_COMBO (combo1), TRUE, FALSE);
    g_object_set_data (G_OBJECT (GTK_COMBO (combo1)->popwin),
    "GladeParentKey", combo1);
    
    pref_codec = GTK_COMBO (combo1)->entry;
    gtk_widget_show (pref_codec);
    gtk_tooltips_set_tip (tooltips, pref_codec, _ ("chose codecs to use with ffmpeg on-line encoding"), NULL);
    gtk_entry_set_text (GTK_ENTRY (pref_codec), _ (tCodecNames[(mJob->targetCodec)]));
    gtk_entry_set_editable (GTK_ENTRY (pref_codec), FALSE);
    
    gtk_widget_show (combo1);
    gtk_table_attach (GTK_TABLE (table1), combo1, 0, 1, 6, 7,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    
    // header label
    pref_label = gtk_label_new (_ ("Modify runtime preferences:"));
    gtk_widget_show (pref_label);
    gtk_table_attach (GTK_TABLE (table1), pref_label, 0, 1, 0, 1,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (pref_label), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (pref_label), 0.04, 0.5);
    gtk_misc_set_padding (GTK_MISC (pref_label), 0, 5);
    
    //frames per second
    pref_frames_per_sec_adj = gtk_adjustment_new (job_fps (), 1, 100, 1, 10, 10);
    pref_frames_per_sec = gtk_spin_button_new (GTK_ADJUSTMENT (pref_frames_per_sec_adj), 1, 0);
    gtk_widget_show (pref_frames_per_sec);
    gtk_table_attach (GTK_TABLE (table1), pref_frames_per_sec, 0, 1, 1, 2,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 0, 2);
    gtk_tooltips_set_tip (tooltips, pref_frames_per_sec, _ ("Frames per second"), NULL);
    
    //filename
    pref_filename = gtk_entry_new ();
    gtk_widget_show (pref_filename);
    gtk_table_attach (GTK_TABLE (table1), pref_filename, 0, 1, 2, 3,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 0, 1);
    gtk_tooltips_set_tip (tooltips, pref_filename, _ ("Filename or Filename pattern"), NULL);
    gtk_entry_set_text (GTK_ENTRY (pref_filename), _ (job_file ()));
    
    //max frames ........
    pref_max_frames_adj = gtk_adjustment_new (mJob->max_frames, 0, 1e+06, 1, 10, 10);
    pref_max_frames = gtk_spin_button_new (GTK_ADJUSTMENT (pref_max_frames_adj), 1, 0);
    gtk_widget_show (pref_max_frames);
    gtk_table_attach (GTK_TABLE (table1), pref_max_frames, 0, 1, 3, 4,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 0, 2);
    gtk_tooltips_set_tip (tooltips, pref_max_frames, _ ("Maximum number of frames to encode (overrides max. time) 0 = no limit"), NULL);
    
    //max time
    pref_max_time_adj = gtk_adjustment_new (mJob->max_time, 0, 1e+06, 1, 10, 10);
    pref_max_time = gtk_spin_button_new (GTK_ADJUSTMENT (pref_max_time_adj), 1, 0);
    gtk_widget_show (pref_max_time);
    gtk_table_attach (GTK_TABLE (table1), pref_max_time, 0, 1, 4, 5,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 0, 1);
    gtk_tooltips_set_tip (tooltips, pref_max_time, _ ("Maximum time to record, 0 = no limit"), NULL);

    //autocontinue capture
    pref_continue = gtk_check_button_new_with_mnemonic (_ ("Auto_continue"));
    gtk_widget_show (pref_continue);
    gtk_tooltips_set_tip (tooltips, pref_continue, _ ("toggle autocontinue on/off"), NULL);
    gtk_table_attach (GTK_TABLE (table1), pref_continue, 0, 1, 5, 6,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 1, 3);
    gtk_tooltips_set_tip (tooltips, pref_continue, 
        _ ("If checked and the filename is defined as a pattern recording sessions which exceed maximum time or frames automatically continue in extra files"), 
        NULL);
    if ((mJob->flags & FLG_AUTO_CONTINUE) != 0) {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_continue), TRUE);
    } else {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_continue), FALSE);
    }
    
    //quality
    pref_quality = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new ((gdouble) mJob->quality, (gdouble) 1, (gdouble) 100,
    (gdouble) 1, (gdouble) 10, 0)));
    gtk_scale_set_digits (GTK_SCALE (pref_quality), 0);
    gtk_widget_show (pref_quality);
    gtk_table_attach (GTK_TABLE (table1), pref_quality, 0, 1, 7, 8,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (GTK_FILL), 0, 0);
    
    //compress
    pref_compress = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new ((gdouble) mJob->compress, (gdouble) 0, (gdouble) 9,
    (gdouble) 1, (gdouble) 5, 0)));
    gtk_scale_set_digits (GTK_SCALE (pref_compress), 0);
    gtk_widget_show (pref_compress);
    gtk_table_attach (GTK_TABLE (table1), pref_compress, 0, 1, 8, 9,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (GTK_FILL), 0, 1);
    
    //use shm
    pref_use_shm = gtk_check_button_new_with_mnemonic (_ (" Use _Shared Memory"));
    gtk_widget_show (pref_use_shm);
    gtk_table_attach (GTK_TABLE (table1), pref_use_shm, 0, 1, 9, 10,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 1, 3);
    gtk_tooltips_set_tip (tooltips, pref_use_shm, _ ("toggle use of shared memory"), NULL);
    if ( mJob->flags & FLG_USE_SHM ) {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_use_shm), TRUE);
    } else {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_use_shm), FALSE);
    }
    
    label6 = gtk_label_new ("");
    gtk_widget_show (label6);
    gtk_table_attach (GTK_TABLE (table1), label6, 1, 2, 0, 1,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_widget_set_sensitive (label6, FALSE);
    gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);
    
    label7 = gtk_label_new (_ ("Frames per Second (FPS)"));
    gtk_widget_show (label7);
    gtk_table_attach (GTK_TABLE (table1), label7, 1, 2, 1, 2,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC (label7), 6, 0);
    
    label8 = gtk_label_new (_ ("Filename"));
    gtk_widget_show (label8);
    gtk_table_attach (GTK_TABLE (table1), label8, 1, 2, 2, 3,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (label8), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC (label8), 6, 0);
    
    label9 = gtk_label_new (_ ("Max. number of Frames"));
    gtk_widget_show (label9);
    gtk_table_attach (GTK_TABLE (table1), label9, 1, 2, 3, 4,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC (label9), 6, 0);
    
    label10 = gtk_label_new (_ ("Max. time to record"));
    gtk_widget_show (label10);
    gtk_table_attach (GTK_TABLE (table1), label10, 1, 2, 4, 5,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (label10), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label10), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC (label10), 6, 0);

/*    gtk_table_attach (GTK_TABLE (table1), label6, 1, 2, 5, 6,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_widget_set_sensitive (label6, FALSE);
    gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);
*/    
    label11 = gtk_label_new (_ ("Image Quality"));
    gtk_widget_show (label11);
    gtk_table_attach (GTK_TABLE (table1), label11, 1, 2, 7, 8,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (label11), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label11), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC (label11), 6, 0);
    
    label12 = gtk_label_new (_ ("Compression"));
    gtk_widget_show (label12);
    gtk_table_attach (GTK_TABLE (table1), label12, 1, 2, 8, 9,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (label12), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label12), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC (label12), 6, 0);
    
    label13 = gtk_label_new (_ ("Video Codec"));
    gtk_widget_show (label13);
    gtk_table_attach (GTK_TABLE (table1), label13, 1, 2, 6, 7,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (label13), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label13), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC (label13), 6, 0);
    
    label14 = gtk_label_new ("");
    gtk_widget_show (label14);
    gtk_table_attach (GTK_TABLE (table1), label14, 1, 2, 9, 10,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (label14), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (label14), 0, 0.5);
    
    //capture mouse
    pref_capture_mouse = gtk_check_button_new_with_mnemonic (_ ("Capture _Mouse Pointer"));
    gtk_widget_show (pref_capture_mouse);
    gtk_tooltips_set_tip (tooltips, pref_capture_mouse, _ ("toggle mouse pointer capture"), NULL);
    gtk_table_attach (GTK_TABLE (table1), pref_capture_mouse, 0, 1, 10, 11,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 1, 3);
    if (mJob->mouseWanted > 0) {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_capture_mouse), TRUE);
    } else {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_capture_mouse), FALSE);
    }
    
    hbox5 = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox5);
    gtk_table_attach (GTK_TABLE (table1), hbox5, 1, 2, 10, 11,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (GTK_FILL), 0, 0);
    
    radio_black = gtk_radio_button_new_with_mnemonic (NULL, _ ("black"));
    gtk_widget_show (radio_black);
    gtk_tooltips_set_tip (tooltips, radio_black, _ ("capture black mouse pointer"), NULL);
    gtk_box_pack_start (GTK_BOX (hbox5), radio_black, FALSE, FALSE, 2);
    gtk_radio_button_set_group (GTK_RADIO_BUTTON (radio_black), mouse_color_group);
    mouse_color_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_black));
    
    radio_white = gtk_radio_button_new_with_mnemonic (NULL, _ ("white"));
    gtk_widget_show (radio_white);
    gtk_tooltips_set_tip (tooltips, radio_white, _ ("capture white mouse pointer"), NULL);
    gtk_box_pack_start (GTK_BOX (hbox5), radio_white, TRUE, FALSE, 2);
    gtk_radio_button_set_group (GTK_RADIO_BUTTON (radio_white), mouse_color_group);
    mouse_color_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio_white));
    //printf("mouse_wanted: %i\n", mJob->mouseWanted);
    if (mJob->mouseWanted == 1) {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio_white), TRUE);
    } else if (mJob->mouseWanted == 2) {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio_black), TRUE);
    } else {
        gtk_widget_set_sensitive (hbox5, FALSE);
    }
    
#ifdef HAVE_FFMPEG_AUDIO
// audio capture
    frame1 = gtk_frame_new (NULL);
    gtk_widget_show (frame1);
    gtk_table_attach (GTK_TABLE (table1), frame1, 0, 2, 11, 12,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame1), 3);
    
    table2 = gtk_table_new (4, 2, FALSE);
    gtk_widget_show (table2);
    gtk_container_add (GTK_CONTAINER (frame1), table2);
    
    pref_audio = gtk_check_button_new_with_mnemonic (_ ("Enable\n_Audio"));
    gtk_widget_show (pref_audio);
    gtk_table_attach (GTK_TABLE (table2), pref_audio, 0, 1, 0, 1,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (0), 4, 0);
    gtk_tooltips_set_tip (tooltips, pref_audio, _ ("Toggle Audio Capture on/off"), NULL);
    if (mJob->flags & FLG_AUDIO_WANTED) {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_audio), TRUE);
    } else {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_audio), FALSE);
    }
    
    pref_audio_device = gtk_entry_new ();
    gtk_widget_show (pref_audio_device);
    gtk_table_attach (GTK_TABLE (table2), pref_audio_device, 1, 2, 0, 1,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 4, 1);
    gtk_tooltips_set_tip (tooltips, pref_audio_device, _ ("Audio input"), NULL);
    gtk_entry_set_text (GTK_ENTRY (pref_audio_device), _ (mJob->snd_device));
    
    pref_audio_rate_adj = gtk_adjustment_new (mJob->snd_rate, 10000, 512000, 50, 1000, 10);
    pref_audio_rate = gtk_spin_button_new (GTK_ADJUSTMENT (pref_audio_rate_adj), 50, 0);
    gtk_widget_show (pref_audio_rate);
    gtk_table_attach (GTK_TABLE (table2), pref_audio_rate, 1, 2, 1, 2,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 4, 0);
    gtk_tooltips_set_tip (tooltips, pref_audio_rate, _ ("Set Sample Rate"), NULL);
    
    pref_audio_bits_adj = gtk_adjustment_new (mJob->snd_smplsize, 10000, 512000, 50, 1000, 10);
    pref_audio_bits = gtk_spin_button_new (GTK_ADJUSTMENT (pref_audio_bits_adj), 50, 0);
    gtk_widget_show (pref_audio_bits);
    gtk_table_attach (GTK_TABLE (table2), pref_audio_bits, 1, 2, 2, 3,
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
    (GtkAttachOptions) (0), 4, 0);
    gtk_tooltips_set_tip (tooltips, pref_audio_bits, _ ("Set Bit Rate"), NULL);
    
    pref_audio_channels = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (mJob->snd_channels, 1, 5, 1, 1, 0)));
    gtk_widget_show (pref_audio_channels);
    gtk_table_attach (GTK_TABLE (table2), pref_audio_channels, 1, 2, 3, 4,
    (GtkAttachOptions) (GTK_FILL),
    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 4, 0);
    gtk_scale_set_digits (GTK_SCALE (pref_audio_channels), 0);
    gtk_tooltips_set_tip (tooltips, pref_audio_channels, _ ("Set Number of Audio Channels to capture"), NULL);
    
    label15 = gtk_label_new (_ ("Audio Capture"));
    gtk_widget_show (label15);
    gtk_frame_set_label_widget (GTK_FRAME (frame1), label15);
    gtk_label_set_justify (GTK_LABEL (label15), GTK_JUSTIFY_LEFT);
#endif // HAVE_FFMPEG_AUDIO


//action area
    dialog_action_area1 = GTK_DIALOG (dialog1)->action_area;
    gtk_widget_show (dialog_action_area1);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
    
    pref_ok = gtk_button_new ();
    gtk_widget_show (pref_ok);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), pref_ok, GTK_RESPONSE_OK);
    GTK_WIDGET_SET_FLAGS (pref_ok, GTK_CAN_DEFAULT);
    gtk_tooltips_set_tip (tooltips, pref_ok, _ ("accept settings"), NULL);
    
    alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_widget_show (alignment1);
    gtk_container_add (GTK_CONTAINER (pref_ok), alignment1);
    
    hbox2 = gtk_hbox_new (FALSE, 2);
    gtk_widget_show (hbox2);
    gtk_container_add (GTK_CONTAINER (alignment1), hbox2);
    
    image8 = gtk_image_new_from_stock ("gtk-apply", GTK_ICON_SIZE_BUTTON);
    gtk_widget_show (image8);
    gtk_box_pack_start (GTK_BOX (hbox2), image8, FALSE, FALSE, 0);
    
    label1 = gtk_label_new_with_mnemonic (_ ("_OK"));
    gtk_widget_show (label1);
    gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);
    gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
    
    pref_cancel = gtk_button_new ();
    gtk_widget_show (pref_cancel);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), pref_cancel, GTK_RESPONSE_CANCEL);
    GTK_WIDGET_SET_FLAGS (pref_cancel, GTK_CAN_DEFAULT);
    gtk_tooltips_set_tip (tooltips, pref_cancel, _ ("exit settings dialog without any changes"), NULL);
    
    alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_widget_show (alignment3);
    gtk_container_add (GTK_CONTAINER (pref_cancel), alignment3);
    
    hbox4 = gtk_hbox_new (FALSE, 2);
    gtk_widget_show (hbox4);
    gtk_container_add (GTK_CONTAINER (alignment3), hbox4);
    
    image10 = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
    gtk_widget_show (image10);
    gtk_box_pack_start (GTK_BOX (hbox4), image10, FALSE, FALSE, 0);
    
    label3 = gtk_label_new_with_mnemonic (_ ("Cancel"));
    gtk_widget_show (label3);
    gtk_box_pack_start (GTK_BOX (hbox4), label3, FALSE, FALSE, 0);
    gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
    
    g_signal_connect ((gpointer) dialog1, "delete_event",
    G_CALLBACK (on_dialog1_delete_event),
    NULL);
    g_signal_connect ((gpointer) dialog1, "destroy",
    G_CALLBACK (on_dialog1_destroy),
    NULL);
    g_signal_connect ((gpointer) dialog1, "close",
    G_CALLBACK (on_dialog1_close),
    NULL);
    g_signal_connect ((gpointer) dialog1, "response",
    G_CALLBACK (on_dialog1_response),
    NULL);
    //make sure the dialog gets destroyed, too, when there's a response
    g_signal_connect_swapped (GTK_OBJECT (dialog1), "response",
    G_CALLBACK (gtk_widget_destroy),
    GTK_OBJECT (dialog1));
    g_signal_connect ((gpointer) pref_capture_mouse, "toggled",
    G_CALLBACK (on_pref_capture_mouse_toggled),
    NULL);
#ifdef HAVE_FFMPEG_AUDIO
    g_signal_connect ((gpointer) pref_audio, "toggled",
    G_CALLBACK (on_pref_audio_toggled),
    NULL);
#endif // HAVE_FFMPEG_AUDIO


/* Store pointers to all widgets, for use by lookup_widget(). */
GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog1, "dialog1");
GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog_vbox1, "dialog_vbox1");
GLADE_HOOKUP_OBJECT (dialog1, table1, "table1");
GLADE_HOOKUP_OBJECT (dialog1, combo1, "combo1");
GLADE_HOOKUP_OBJECT (dialog1, pref_codec, "pref_codec");
GLADE_HOOKUP_OBJECT (dialog1, pref_label, "pref_label");
GLADE_HOOKUP_OBJECT (dialog1, pref_frames_per_sec, "pref_frames_per_sec");
GLADE_HOOKUP_OBJECT (dialog1, pref_filename, "pref_filename");
GLADE_HOOKUP_OBJECT (dialog1, pref_max_frames, "pref_max_frames");
GLADE_HOOKUP_OBJECT (dialog1, pref_max_time, "pref_max_time");
GLADE_HOOKUP_OBJECT (dialog1, pref_quality, "pref_quality");
GLADE_HOOKUP_OBJECT (dialog1, pref_compress, "pref_compress");
GLADE_HOOKUP_OBJECT (dialog1, pref_use_shm, "pref_use_shm");
GLADE_HOOKUP_OBJECT (dialog1, label6, "label6");
GLADE_HOOKUP_OBJECT (dialog1, label7, "label7");
GLADE_HOOKUP_OBJECT (dialog1, label8, "label8");
GLADE_HOOKUP_OBJECT (dialog1, label9, "label9");
GLADE_HOOKUP_OBJECT (dialog1, label10, "label10");
GLADE_HOOKUP_OBJECT (dialog1, label11, "label11");
GLADE_HOOKUP_OBJECT (dialog1, label12, "label12");
GLADE_HOOKUP_OBJECT (dialog1, label13, "label13");
GLADE_HOOKUP_OBJECT (dialog1, label14, "label14");
GLADE_HOOKUP_OBJECT_NO_REF (dialog1, dialog_action_area1, "dialog_action_area1");
GLADE_HOOKUP_OBJECT (dialog1, pref_ok, "pref_ok");
GLADE_HOOKUP_OBJECT (dialog1, alignment1, "alignment1");
GLADE_HOOKUP_OBJECT (dialog1, hbox2, "hbox2");
GLADE_HOOKUP_OBJECT (dialog1, image8, "image8");
GLADE_HOOKUP_OBJECT (dialog1, label1, "label1");
GLADE_HOOKUP_OBJECT (dialog1, pref_cancel, "pref_cancel");
GLADE_HOOKUP_OBJECT (dialog1, alignment3, "alignment3");
GLADE_HOOKUP_OBJECT (dialog1, hbox4, "hbox4");
GLADE_HOOKUP_OBJECT (dialog1, image10, "image10");
GLADE_HOOKUP_OBJECT (dialog1, label3, "label3");
GLADE_HOOKUP_OBJECT (dialog1, pref_capture_mouse, "pref_capture_mouse");
GLADE_HOOKUP_OBJECT (dialog1, hbox5, "hbox5");
GLADE_HOOKUP_OBJECT (dialog1, radio_black, "radio_black");
GLADE_HOOKUP_OBJECT (dialog1, radio_white, "radio_white");
#ifdef HAVE_FFMPEG_AUDIO
GLADE_HOOKUP_OBJECT (dialog1, frame1, "frame1");
GLADE_HOOKUP_OBJECT (dialog1, table2, "table2");
GLADE_HOOKUP_OBJECT (dialog1, pref_audio, "pref_audio");
GLADE_HOOKUP_OBJECT (dialog1, pref_audio_rate, "pref_audio_rate");
GLADE_HOOKUP_OBJECT (dialog1, pref_audio_bits, "pref_audio_bits");
GLADE_HOOKUP_OBJECT (dialog1, pref_audio_channels, "pref_audio_channels");
GLADE_HOOKUP_OBJECT (dialog1, label15, "label15");
GLADE_HOOKUP_OBJECT (dialog1, pref_audio_device, "pref_audio_device");
#endif // HAVE_FFMPEG_AUDIO
GLADE_HOOKUP_OBJECT_NO_REF (dialog1, tooltips, "tooltips");
    
{
    sJob = mJob;
}

return dialog1;
}

