/*  xtraceroute - graphically show traceroute information.
 *  Copyright (C) 1996-1998  Bjrn Augustsson 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __xt_h__
#define __xt_h__

#include "config.h"

#include <stdio.h>

#ifdef ENABLE_NLS
# include <locale.h>
#    include <libintl.h>
#    define _(String) gettext (String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop (String)
#    else
#        define N_(String) (String)
#    endif
#else
/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (String)
#    define dgettext(Domain,Message) (Message)
#    define dcgettext(Domain,Message,Type) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif

#include <stdlib.h>
#include <string.h>
#include <math.h>       /* for cos(), sin(), and sqrt() */

#include <GL/gl.h>
#include <GL/glu.h>

#include <gtk/gtk.h>
#include <gtkgl/gtkglarea.h>

#include <tiffio.h>    /* for .tiff image loading. */

#include "tweaks.h"

#ifndef M_PI
#define M_PI 3.141592654
#endif

/* radian <-> degree conversion factors. */

#define torad 0.017453
#define todeg 57.295780

#define MAX_SITES  30
#define SITE_MARKER_SIZE  0.03
#define EARTH_SIZE 1.0
#define PHYSICAL_EARTH_RADIUS 6378137  /* Earths radius, in meters. (From RFC1876) */
#define MAXSELECT 100
#define PHYSICAL_EARTH_CIRC (2.0 * M_PI * PHYSICAL_EARTH_RADIUS)

/**
 *  This is a replacement for isspace(), since it doesn't work
 *  as expected in some locales.
 */

#define is_whitespace(c) (c == '\t' || c == ' ' || c == '\n')

/* Displaylist */

#define WORLD 1

/* For makeearth() */

#define NORMAL_MODE 0
#define SELECT_MODE 1

#define SPINNER_OFF 0
#define SPINNER_ON  1

#define W 450           /* Default window size */
#define H 640           /* Ought to be enough for everyone. */

char currentloc[100];

typedef struct
{
    GLdouble lat;
    GLdouble lon;
    char ip[18];
    char name[50];
    char info[50];
} dbentry;

typedef struct
{
    GLdouble lat;
    GLdouble lon;
    char suffix[4];
    char name[50];
} countrycode;

typedef struct
{
    dbentry *entries;
    int n_entries;
} database;

typedef struct
{
  short draw;           /* Plot this site if draw. */
  GLdouble lat;
  GLdouble lon;
  int accuracy;         /* How certain is the position? */
  char name[50];
  char info[50];
  char ip[18];
  int time;             /* In milliseconds. */
  int selected;
} site;

site sites[MAX_SITES];

typedef struct
{
  int depth;
  int height;
  int width;
  uint32 *bits;
} texture;

enum
{
  ACC_NONE, ACC_SUFFIX, ACC_INCLUDED, ACC_NDG_NET, ACC_NDG_HOST,
  ACC_RFC_1712, ACC_RFC_1876, ACC_LOCAL_SITE, ACC_LOCAL_USER    
};

enum
{
  LATITUDE, LONGITUDE
};


database *ndg_hosts;
database *ndg_nets;
database *local_site_hosts;
database *local_site_nets;
database *local_user_hosts;
database *local_user_nets;
database *local_user_generic;
database *internal;


/*   Eduoard
enum
{
  USER, SITE, GLOBAL
};

enum
{
  HOSTS, NETS, GENERIC
};

database* DBs[3][3];
*/

GtkWidget *glarea;

texture *readTexture(char *);
database *readNetDB(char *);
database *readHostDB(char *);
database *readGenDB(char *);
database *init_internal_db(void);
int writeHostDB(database *, char *);
int writeNetDB(database *, char *);
int writeGenDB(database *, char *);
void addToHostDB(database *, dbentry *);
void addToNetDB(database *, dbentry *);
void addToGenDB(database *, dbentry *);
void calltrace(int);
void set_sphere_lod(int);
void set_render_mode(int);
void makeearth(void);
gint new_trace(GtkWidget *, gpointer *);
void tell_user(char *);
void spinner_start(void);
void spinner_stop(void);
unsigned long distance(int);
gint info_window(gint);
void infowin_change_site(gint);
void partialtorus(GLfloat, GLfloat);
GtkWidget* spinner_new(void);
void init_gl(GtkWidget *, gpointer);
char*  locNumToStr(double, int);
double locStrToNum(char *, int);
GLdouble tox(GLdouble, GLdouble);
GLdouble toy(GLdouble, GLdouble);
GLdouble toz(GLdouble, GLdouble);
GLdouble tolat(GLdouble, GLdouble, GLdouble);
GLdouble tolon(GLdouble, GLdouble, GLdouble);
void redraw(GtkWidget *, GdkEvent *);
void resolve_by_id(int);
void resolve(site *);
int isin(const char[],const char[]);
void getsuff(const char[], char[]);
gint addHost(GtkWidget *);
gint addNet(GtkWidget *);
gint addGen(GtkWidget *);

#endif                  /* __xt_h__ */
