package com.jclark.xsl.sax;

import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.FileDescriptor;
import java.io.File;

public class FileDescriptorDestination extends GenericDestination {
  private final FileDescriptor fd;

  public FileDescriptorDestination(FileDescriptor fd) {
    this.fd = fd;
  }

  public OutputStream getOutputStream(String contentType, String encoding) {
    setEncoding(encoding);
    return new FileOutputStream(fd);
  }

  public boolean keepOpen() {
    return true;
  }

  public Destination resolve(String uri) {
    if (File.separatorChar != '/')
      uri = uri.replace('/', File.separatorChar);
    return new FileDestination(uri);
  }
}
