/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/slinkspin.c,v 1.13 2004/02/26 06:34:56 justins Exp $ */
/*

   xscorch - slinkspin.c      Copyright(c) 2000-2003 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorched label widgets


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, version 2 of the License ONLY.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>

#include <slinkspin.h>

#include <gdk/gdkkeysyms.h>



static GtkSpinButtonClass *parent_class;



enum _ScLinkSpinSignals {
   MODIFIED_SIGNAL,
   LAST_SIGNAL
};
static guint _sc_link_spin_signals[LAST_SIGNAL] = { 0 };
static guint _sc_link_spinf_signals[LAST_SIGNAL] = { 0 };



static void _sc_link_spin_set(GtkEditable *ed) {

   ScLinkSpin *spin = SC_LINK_SPIN(ed);
   
   #if GTK12_ENABLED
      if(GTK_EDITABLE_CLASS(parent_class)->changed != NULL) {
         GTK_EDITABLE_CLASS(parent_class)->changed(ed);
      }
   #endif /* GTK 1.2? */

   if(spin->value != NULL) {
      *spin->value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ed));
   }
   #if GTK12_ENABLED
      gtk_signal_emit(GTK_OBJECT(spin), _sc_link_spin_signals[MODIFIED_SIGNAL]);
   #else /* GTK 2.0 */
      g_signal_emit(GTK_OBJECT(spin), _sc_link_spin_signals[MODIFIED_SIGNAL], 0);
   #endif /* GTK version? */

}



static void _sc_link_spin_class_init(ScLinkSpinClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;

   parent_class = gtk_type_class(gtk_spin_button_get_type());

   #if GTK12_ENABLED
      _sc_link_spin_signals[MODIFIED_SIGNAL] =
         gtk_signal_new("modified",
                        GTK_RUN_LAST,
                        GTK_CLASS_TYPE(object_class),
                        GTK_SIGNAL_OFFSET(ScLinkSpinClass, modified),
                        gtk_marshal_NONE__NONE,
                        GTK_TYPE_NONE, 0);

      /* This call is no longer necessary in 2.0 */
      gtk_object_class_add_signals(object_class, _sc_link_spin_signals, LAST_SIGNAL);
   #else /* GTK 2.0 */
      _sc_link_spin_signals[MODIFIED_SIGNAL] =
         g_signal_new("modified",                     /* Signal name */
                      G_TYPE_FROM_CLASS(object_class),/* Type of object the signal applies to */
                      G_SIGNAL_RUN_LAST,              /* Signal flags; run this signal last */
                      offsetof(ScLinkSpinClass, modified),
                                                      /* Offset to signal handler in class */
                      NULL,                           /* Signal accumulator function */
                      NULL,                           /* Signal accumulator data */
                      g_cclosure_marshal_VOID__VOID,  /* Marshal function for this signal */
                      G_TYPE_NONE,                    /* Return type for the marshaller */
                      0                               /* Number of extra parametres to pass */
                     );
   #endif /* GTK version? */

   klass->modified = NULL;

}



static void _sc_link_spin_init_obj(ScLinkSpin *spin) {

   spin->value = NULL;
   #if GTK12_ENABLED
      gtk_signal_connect(GTK_OBJECT(spin), "changed", GTK_SIGNAL_FUNC(_sc_link_spin_set), NULL);
   #else /* GTK 2.0 */
      g_signal_connect(G_OBJECT(spin), "changed", (GCallback)_sc_link_spin_set, NULL);
   #endif /* GTK version? */

}



GType sc_link_spin_get_type(void) {

   static GType sc_link_spin_type = 0;

   if(sc_link_spin_type == 0) {
      #if GTK12_ENABLED
         static const GtkTypeInfo sc_link_spin_info = {
            (char *)"ScLinkSpin",
            sizeof(ScLinkSpin),
            sizeof(ScLinkSpinClass),
            (GtkClassInitFunc)_sc_link_spin_class_init,
            (GtkObjectInitFunc)_sc_link_spin_init_obj,
            NULL,
            NULL,
            (GtkClassInitFunc)NULL
         };
         sc_link_spin_type = gtk_type_unique(gtk_spin_button_get_type(), &sc_link_spin_info);
      #else /* GTK 2.0 */
         static const GTypeInfo sc_link_spin_info = {
            sizeof(ScLinkSpinClass),         /* Size of the class object */
            NULL,                            /* Base initializer */
            NULL,                            /* Base finalizer */
            (GClassInitFunc)_sc_link_spin_class_init,
                                             /* Class initializer */
            NULL,                            /* Class finalizer */
            NULL,                            /* Class data pointer */
            sizeof(ScLinkSpin),              /* Size of an instance object */
            0,                               /* Number of preallocs */
            (GInstanceInitFunc)_sc_link_spin_init_obj,
                                             /* Instance initializer */
            NULL                             /* Value table */
         };
         sc_link_spin_type = g_type_register_static(gtk_spin_button_get_type(), "ScLinkSpin",
                                                    &sc_link_spin_info, 0);
      #endif /* GTK version? */
   }

   return(sc_link_spin_type);

}



GtkWidget *sc_link_spin_new(int *value, int min, int max, int step) {

   GtkAdjustment *spinadjust;
   ScLinkSpin *spin;

   spin = g_object_new(sc_link_spin_get_type(), NULL);
   g_return_val_if_fail(spin != NULL, NULL);

   spinadjust = (GtkAdjustment *)gtk_adjustment_new(*value, min, max, step, step, step);
   gtk_spin_button_configure(GTK_SPIN_BUTTON(spin), spinadjust, 1, 0);
   gtk_widget_set_size_request(GTK_WIDGET(spin), 80, -1);
   gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(spin), TRUE);
   spin->value = value;

   return(GTK_WIDGET(spin));

}



static void _sc_link_spinf_set(GtkEditable *ed) {

   ScLinkSpinF *spin = SC_LINK_SPINF(ed);

   #if GTK12_ENABLED
      if(GTK_EDITABLE_CLASS(parent_class)->changed != NULL) {
         GTK_EDITABLE_CLASS(parent_class)->changed(ed);
      }
   #endif /* GTK 1.2? */

   if(spin->value != NULL) {
      *spin->value = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin));
   }
   #if GTK12_ENABLED
      gtk_signal_emit(GTK_OBJECT(spin), _sc_link_spinf_signals[MODIFIED_SIGNAL]);
   #else /* GTK 2.0 */
      g_signal_emit(GTK_OBJECT(spin), _sc_link_spinf_signals[MODIFIED_SIGNAL], 0);
   #endif /* GTK version? */

}



static void _sc_link_spinf_class_init(ScLinkSpinFClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;

   parent_class = gtk_type_class(gtk_spin_button_get_type());

   #if GTK12_ENABLED
      _sc_link_spinf_signals[MODIFIED_SIGNAL] =
         gtk_signal_new("modified",
                        GTK_RUN_LAST,
                        GTK_CLASS_TYPE(object_class),
                        GTK_SIGNAL_OFFSET(ScLinkSpinFClass, modified),
                        gtk_marshal_NONE__NONE,
                        GTK_TYPE_NONE, 0);

      /* This call is no longer necessary in 2.0 */
      gtk_object_class_add_signals(object_class, _sc_link_spinf_signals, LAST_SIGNAL);
   #else /* GTK 2.0 */
      _sc_link_spinf_signals[MODIFIED_SIGNAL] =
         g_signal_new("modified",                     /* Signal name */
                      G_TYPE_FROM_CLASS(object_class),/* Type of object the signal applies to */
                      G_SIGNAL_RUN_LAST,              /* Signal flags; run this signal last */
                      offsetof(ScLinkSpinFClass, modified),
                                                      /* Offset to signal handler in class */
                      NULL,                           /* Signal accumulator function */
                      NULL,                           /* Signal accumulator data */
                      g_cclosure_marshal_VOID__VOID,  /* Marshal function for this signal */
                      G_TYPE_NONE,                    /* Return type for the marshaller */
                      0                               /* Number of extra parametres to pass */
                     );
   #endif /* GTK version? */

   klass->modified = NULL;

}



static void _sc_link_spinf_init_obj(ScLinkSpinF *spin) {

   spin->value = NULL;
   #if GTK12_ENABLED
      gtk_signal_connect(GTK_OBJECT(spin), "changed", GTK_SIGNAL_FUNC(_sc_link_spinf_set), NULL);
   #else /* GTK 2.0 */
      g_signal_connect(G_OBJECT(spin), "changed", (GCallback)_sc_link_spinf_set, NULL);
   #endif /* GTK version? */

}



GType sc_link_spinf_get_type(void) {

   static GType sc_link_spinf_type = 0;

   if(sc_link_spinf_type == 0) {
      #if GTK12_ENABLED
         static const GtkTypeInfo sc_link_spinf_info = {
            (char *)"ScLinkSpinF",
            sizeof(ScLinkSpinF),
            sizeof(ScLinkSpinFClass),
            (GtkClassInitFunc)_sc_link_spinf_class_init,
            (GtkObjectInitFunc)_sc_link_spinf_init_obj,
            NULL,
            NULL,
            (GtkClassInitFunc)NULL
         };
         sc_link_spinf_type = gtk_type_unique(gtk_spin_button_get_type(), &sc_link_spinf_info);
      #else /* GTK 2.0 */
         static const GTypeInfo sc_link_spinf_info = {
            sizeof(ScLinkSpinFClass),        /* Size of the class object */
            NULL,                            /* Base initializer */
            NULL,                            /* Base finalizer */
            (GClassInitFunc)_sc_link_spinf_class_init,
                                             /* Class initializer */
            NULL,                            /* Class finalizer */
            NULL,                            /* Class data pointer */
            sizeof(ScLinkSpinF),             /* Size of an instance object */
            0,                               /* Number of preallocs */
            (GInstanceInitFunc)_sc_link_spinf_init_obj,
                                             /* Instance initializer */
            NULL                             /* Value table */
         };
         sc_link_spinf_type = g_type_register_static(gtk_spin_button_get_type(), "ScLinkSpinF",
                                                     &sc_link_spinf_info, 0);
      #endif /* GTK version? */
   }

   return(sc_link_spinf_type);

}



GtkWidget *sc_link_spinf_new(double *value, double min, double max, double step) {

   GtkAdjustment *spinadjust;
   ScLinkSpinF *spin;

   spin = g_object_new(sc_link_spinf_get_type(), NULL);
   g_return_val_if_fail(spin != NULL, NULL);

   spinadjust = (GtkAdjustment *)gtk_adjustment_new(*value, min, max, step, step, step);
   gtk_spin_button_configure(GTK_SPIN_BUTTON(spin), spinadjust, 1, 3);
   gtk_widget_set_size_request(GTK_WIDGET(spin), 80, -1);
   gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(spin), FALSE);
   spin->value = value;

   return(GTK_WIDGET(spin));

}
