// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: tthing.h,v 3.3 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_TTHING_H

class Tthing;

#else	// XSC_TTHING_H
#define	XSC_TTHING_H

#include "thing.h"

class Tthing : virtual public Thing {
protected:
    float theta;
    float dtheta;

public:
    Tthing(void);
    virtual ~Tthing(void);

    float get_theta(void) const;
    void set_theta(const float);

    float get_dtheta(void) const;
    void set_dtheta(const float);

    virtual void set_xpoints(void);
    virtual void turn(void);
};


inline float
Tthing::get_theta(void) const
{
    return theta;
} // Tthing::get_theta


inline void
Tthing::set_theta(const float ntheta)
{
    theta = ntheta;
} // Tthing::get_theta


inline float
Tthing::get_dtheta(void) const
{
    return dtheta;
} // Tthing::get_theta


inline void
Tthing::set_dtheta(const float ndtheta)
{
    dtheta = ndtheta;
} // Tthing::get_theta

#endif	// XSC_TTHING_H
