// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: tthing.C,v 3.4 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "trig.h"
#include "util.h"

#include "tthing.h"

using namespace Trig;


Tthing::Tthing(void)
{
    //fprintf(stderr, "Tthing::Tthing()\n");
    theta = dtheta = 0.0;
} // Tthing::Tthing


Tthing::~Tthing(void)
{
    //fprintf(stderr, "Tthing::~Tthing()\n");
} // Tthing::~Tthing


void
Tthing::turn(void)
{
    theta = normalize(theta + dtheta);
} // Tthing::turn


void
Tthing::set_xpoints(void)
{
    const float sine = xsin(theta);
    const float cosine = xcos(theta);

    for (int i = 0; i < num_points; i++) {
	const float tx = size * points[i].x;
	const float ty = size * points[i].y;

	xpoints[i].x = (int)((tx * cosine) + (ty * sine) + x);
	xpoints[i].y = (int)(-(tx * sine) + (ty * cosine) + y);
    }
} // Tthing::set_xpoints
