// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: trig.h,v 3.5 2005/01/02 19:11:17 mark Exp $

#ifndef	XSC_TRIG_H
#define	XSC_TRIG_H

namespace Trig {
    const float PI = 3.14159265358979323846;

    const float SQRT2 = 1.41421356237309504880;
    const float SQRT3 = 1.73205080756887729352;

    const float SIN00 = 0.0;
    const float SIN15 = 0.25881904510252076233;
    const float SIN30 = 0.5;
    const float SIN45 = (0.5 / SQRT2);
    const float SIN60 = (SQRT3 / 2.0);
    const float SIN75 = 0.99976741423148606665;
    const float SIN90 = 1.0;

    const float COS00 = SIN90;
    const float COS15 = SIN75;
    const float COS30 = SIN60;
    const float COS45 = SIN45;
    const float COS60 = SIN30;
    const float COS75 = SIN15;
    const float COS90 = SIN00;

    void init(void);
    float xsin(const float);
    float xcos(const float);
    float xatan2(const float, const float);
    float wedge(const float, const float);

    float rad2deg(const float);
    float deg2rad(const float);
    float normalize(const float);
} // namespace Trig


inline float
Trig::rad2deg(const float rad)
{
    return rad * (180.0 / PI);
} // Trig::rad2deg


inline float
Trig::deg2rad(const float deg)
{
    return deg * (PI / 180.0);
} // Trig::deg2rad


inline float
Trig::normalize(const float degree)
{
    float normed = degree;

    while (normed < 0.0) {
	normed += 360.0;
    }

    while (normed >= 360.0) {
	normed -= 360.0;
    }

    return normed;
} // Trig::normalize

#endif	// XSC_TRIG_H
