// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: timing.h,v 3.9 2005/01/02 19:11:17 mark Exp $

#ifndef	XSC_TIME_H
#define	XSC_TIME_H

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif	// HAVE_CONFIG_H

#if	TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else	// TIME_WITH_SYS_TIME
#if	HAVE_SYS_TIME_H
#include <sys/time.h>
#else	// HAVE_SYS_TIME_H
#include <time.h>
#endif	// HAVE_SYS_TIME_H
#endif	// TIME_WITH_SYS_TIME_H

#include "stamp.h"

namespace XSCTime {
    void now(Stamp *const);
    void sleep(const long);
} // namespace XSCTime


inline void
XSCTime::now(Stamp *const s)
{
    struct timeval tv;

    gettimeofday(&tv, 0);
    s->set(tv.tv_sec, tv.tv_usec);
} // XSCTime::now


inline void
XSCTime::sleep(const long delta)
{
    usleep((unsigned int)delta);
} // XSCTime::sleep

#endif	// XSC_TIME_H
