// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: thing.C,v 3.4 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "util.h"
#include "xsc.h"

#include "thing.h"


Thing::Thing(void)
{
    //fprintf(stderr, "Thing::Thing()\n");
    x = y = 0.0;
    gc = fetch_gc(GC_BLUE);
    xpoints = NULL;
    points = NULL;
    num_points = 0;
    window = game_window;
} // Thing::Thing


Thing::~Thing(void)
{
    //fprintf(stderr, "Thing::~Thing()\n");
    delete[] xpoints;
} // Thing::~Thing


void
Thing::set_size(const float new_size)
{
    size = new_size;
    scale = wwidth / size;
    diag = hypot(size / 2.0, size / 2.0);
} // Thing::set_size


void
Thing::set_scale(const float new_scale)
{
    scale = new_scale;
    size = wwidth / scale;
    diag = hypot(size / 2.0, size / 2.0);
} // Thing::set_scale


void
Thing::set_points(const coords *new_points, const int new_num_points)
{
    if (new_num_points > num_points) {
	delete[] xpoints;
	xpoints = new XPoint[new_num_points];
    }

    points = new_points;
    num_points = new_num_points;
} // Thing::set_points


XPoint *
Thing::get_xpoints(void) const
{
    return xpoints;
} // Thing::get_xpoints


void
Thing::set_xpoints(void)
{
    for (int i = 0; i < num_points; i++) {
	xpoints[i].x = (int)((size * points[i].x) + x);
	xpoints[i].y = (int)((size * points[i].y) + y);
    }
} // Thing::set_xpoints


void
Thing::paint_points(const bool ink) const
{
    GC thisgc = ink ? gc : fetch_gc(GC_BLACK);

    for (int i = 1; i < num_points; i += 2) {
	XDrawLine(display, window, thisgc,
		xpoints[i - 1].x, xpoints[i - 1].y,
		xpoints[i].x, xpoints[i].y);
    }
} // Thing::paint_points


void
Thing::render(const bool ink)
{
    if (ink) {
	set_xpoints();
    }
    paint_points(ink);
} // Thing::render


void
Thing::resize(const int nwidth, const int nheight)
{
    x *= (float)nwidth / wwidth;
    y *= (float)nheight / gwheight;

    size = nwidth / scale;
    diag = hypot(size / 2.0, size / 2.0);
} // Thing::resize
