// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: stats.C,v 3.6 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "util.h"
#include "xsc.h"

#include "ship.h"	// ship data points

#include "stats.h"


Stats::Stats(void)
{
    //fprintf(stderr, "Stats::Stats()\n");
    reset();
    last_score = ULONG_MAX;	// ensure we get displayed first time

    set_window(stats_window);
    text_score.set_window(window);
    text_state.set_window(window);

    set_scale(6.0);
    text_score.set_scale(scale);
    text_state.set_scale(scale);

    set_gc(fetch_gc(GC_BRIGHT_GREY));
    text_score.set_gc(gc);
    text_state.set_gc(fetch_gc(GC_BLUE));

    set_theta(0.0);
} // Stats::Stats


Stats::~Stats(void)
{
    //fprintf(stderr, "Stats::~Stats()\n");
} // Stats::~Stats


void
Stats::reset(void)
{
    score = 0;
    lives = 2;
    state = STATE_NORMAL;
} // Stats::reset


void
Stats::render(const bool ink)
{
    static char scorestr[20 + 1];	// 64 bits worth + terminator
    static char livesstr[20 + 1];	// 64 bits worth + terminator
    static unsigned int scorelen;
    static unsigned int liveslen;
    const float charwidth = text_score.get_size() / 6.0;

    if (ink) {
	XDrawLine(display, window, fetch_gc(GC_DULL_GREY),
		0, mwheight - gwheight - 1,
		wwidth, mwheight - gwheight - 1);

	sprintf(scorestr, "%u", score);
	scorelen = strlen(scorestr);
	last_score = score;

	sprintf(livesstr, "%d", lives);
	liveslen = strlen(livesstr);
	last_lives = lives;

	switch (state) {
	    case STATE_NORMAL:
		text_state.set_message("");
		break;
	    case STATE_PAUSED:
		text_state.set_message("PAUSED");
		break;
	    case STATE_OVER:
		text_state.set_message("GAME OVER");
		break;
	    default:
		break;
	}
	last_state = state;
    }

    // display the score

    y = (mwheight - gwheight) / 2.0;

    text_score.set_position(charwidth, y);
    text_score.set_message(scorestr);
    text_score.render(ink);

    // display the state of the game

    text_state.set_position(-1.0, y);
    text_state.render(ink);

    if (lives >= 0 || !ink) {
	// display the number of lives remaining

	x = wwidth - (charwidth * (liveslen + 1.5));

	text_score.set_position(x, y);
	text_score.set_message(livesstr);
	text_score.render(ink);

	x += charwidth * (liveslen + 0.5);

	// use a picture of the ship as an indicator

	GC save_gc = gc;
	set_gc(fetch_gc(GC_BLUE));
	set_scale(30.0);
	set_theta(90.0);
	y -= size / 20.0;
	set_points(ship_points, NUM_SHIP_POINTS);
	set_xpoints();
	paint_points(ink);

	// restore
	set_gc(save_gc);
	set_scale(10.0);
	set_theta(0.0);
    }
} // Stats::render


void
Stats::resize(const int nwidth, const int nheight)
{
    Thing::resize(nwidth, nheight);
    text_score.resize(nwidth, nheight);
    text_state.resize(nwidth, nheight);
} // Stats::resize
