// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: king.C,v 3.11 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "trig.h"
#include "util.h"
#include "xsc.h"

#include "king.h"

using namespace Trig;


namespace {

const coords king_points[] = {
    {  0.38, -0.15 }, {  0.50,  0.05 },
    {  0.50,  0.05 }, { -0.12,  0.12 },
    { -0.12,  0.12 }, { -0.32,  0.50 },
    { -0.32,  0.50 }, {  0.05,  0.45 },
    {  0.05,  0.45 }, {  0.20,  0.25 },
    {  0.20,  0.25 }, { -0.50,  0.37 },
    { -0.50,  0.37 }, { -0.30,  0.00 },
    { -0.30,  0.00 }, { -0.50, -0.37 },
    { -0.50, -0.37 }, {  0.20, -0.25 },
    {  0.20, -0.25 }, {  0.05, -0.45 },
    {  0.05, -0.45 }, { -0.32, -0.50 },
    { -0.32, -0.50 }, { -0.12, -0.12 },
    { -0.12, -0.12 }, {  0.50, -0.05 },
    {  0.50, -0.05 }, {  0.38,  0.15 },
};

} // namespace


King::King(void)
{
    //fprintf(stderr, "King::King()\n");
    set_scale(18.0);
    points = king_points;
    num_points = sizeof(king_points) / sizeof(coords);
    xpoints = new XPoint[num_points];
    fireball = new Fireball;
    theta = 180.0;
    x = wwidth2;
    y = gwheight2;
    gc = fetch_gc(GC_BLUE);
    living = true;
} // King::King


King::~King(void)
{
    //fprintf(stderr, "King::~King()\n");
    delete fireball;
} // King::~King


void
King::render(const bool ink)
{
    if (alive()) {
	if (ink) {
	    set_xpoints();
	}
	paint_points(ink);
    }
    fireball->render(ink);
} // King::render


void
King::turn(Castle *castle, Ship *ship)
{
    if (alive() && ship->alive()) {
	dtheta = (wedge(theta, ship->get_angle()) * 4.0) / args.fps;
	Tthing::turn();

	if (castle->opening(theta) && castle->opening(theta + 14) &&
		castle->opening(theta - 14)) {
	    fireball->launch(this);
	}
    }

    fireball->move(ship);
} // King::turn


void
King::resize(const int nwidth, const int nheight)
{
    Tthing::resize(nwidth, nheight);
    fireball->resize(nwidth, nheight);
} // King::resize


bool
King::hit(Castle *castle, Laser *laser, Minefield *minefield, Stats *stats)
{
    if (alive() && laser->get_radius() < diag) {
	stats->lives++;
	castle->explode(stats);
	minefield->snuff();
	living = false;
	return true;
    }
    return false;
} // King::hit


void
King::pause(const bool pause_state) const
{
    fireball->pause(pause_state);
} // King::pause
