/*
 * Copyright (c) 1997, 2000, Mark Buser.
 * Copyright  2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/server.c,v 1.15 2004/12/20 18:43:24 danny Exp $
 */
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <Xm/XmAll.h>

#include "opttick.h"
#include "server.h"
#include "status.h"

/* Globals */
static SERVER_STRUCT **serv_data;
static int serv_num = 0;
static int serv_cur;
static int serv_cur_type;

static char *proxy_serv;
static int proxy_port;

/*
** Proxy management
*/
void setProxy (char *where, char *port)
{
	if (proxy_serv)
		XtFree(proxy_serv);

	if (where)
		proxy_serv = XtNewString (where);
	else
		proxy_serv = NULL;
	proxy_port = strtol (port, NULL, 10);
}

void getProxy (char **where, int *port)
{
	*where = proxy_serv;
	*port = proxy_port;
}

/*
** Quote server management
*/

/* How many servers in database */
int numServer()
{
	return (serv_num);
}

/* Which server are we using */
void setCurServer (int which)
{
	if (which == NEWS)
		serv_cur = serv_num;
	else
		serv_cur = which;
}

int getCurServer ()
{
	return (serv_cur);
}

/* Which server type are we using */
void setCurServerType (int which)
{
	if (which >= 0 && which < serv_data[serv_cur]->num_types)
		serv_cur_type = which;
}

char *getServerTitle (int which)
{
	if (which >=0 && which < serv_num)
		return (serv_data[which]->title);
	else
		return (NULL);
}

/* How many servers in database */
int numCurServerType()
{
	return (serv_data[serv_cur]->num_types);
}

/* How many server types are available for this server ? */
int numServerTypes(int srv)
{
	return serv_data[srv]->num_types;
}

char *getServerType (int serv, int type)
{
	if (serv < 0 || serv_num <= serv)
		return NULL;
	if (serv_data[serv] == NULL)
		return NULL;
	if (serv_data[serv]->types == 0)
		return NULL;
	if (serv_data[serv]->types[type] == 0)
		return NULL;
	if (serv_data[serv]->types[type]->values == 0)
		return NULL;
	return serv_data[serv]->types[type]->values[DETAIL_TITLE];
}

/* Get a server characteristic */
char *getServer (int what)
{
	if (what >= 0 && what < DETAIL_NUM_QUERY_VALUES )
		return (serv_data[serv_cur]->types[serv_cur_type]->values[what]);
	else
		return (NULL);
}

int ServerSetProperty(int server, int tp, int what, char *value)
{
	if (server < 0 || serv_num <= server)
		return -1;	/* Failure */
	if (serv_data[server]->types == NULL)
		return -1;
	if (serv_data[serv_cur]->types[tp] == NULL)
		return -1;

	if (serv_data[server]->types[tp]->values[what])
		free(serv_data[server]->types[tp]->values[what]);
	serv_data[server]->types[tp]->values[what] =
		strdup(value);
	return 0;		/* Success */
}

char *ServerGetProperty(int server, int tp, int what)
{
	if (server < 0 || serv_num <= server)
		return NULL;	/* Failure */
	if (serv_data[server]->types == NULL)
		return NULL;
	if (serv_data[serv_cur]->types[tp] == NULL)
		return NULL;

	return serv_data[server]->types[tp]->values[what];
}


#define SERV_TYPES (serv_data[serv_num-1]->types)
#define SERV_NUM_TYPES (serv_data[serv_num-1]->num_types)
#define SERV_CUR_TYPE (serv_data[serv_num-1]->types[SERV_NUM_TYPES-1])

/* Read all there is to know of servers from X resources */
int readServerDatabase( Widget Toplevel, char *appname)
{
	XrmDatabase	db = XtScreenDatabase(XtScreenOfObject(Toplevel));
	XrmQuark      class[6], name[6];
	XrmValue      value;
	XrmRepresentation type;

	/* Don't constrain these arrays and toupper seg faults in Linux
	static binary (but not the dynamic mind you) gcc 2.7.2 libc 5.2.18 */

	/* xpropnames must match order in server.h and names in Xquote.ad */
	/* News properties */
	char npropnames[4][6] = { "title", "url", "start", "end" };

	/* Server properties */
	char spropnames[2][6] = { "title", "type" };
	/*
	 * Keep qpropnames in sync with the definitions in server.h and the
	 * allocation in resource.h; see the comments in resource.h.
	 */
	char qpropnames[DETAIL_NUM_QUERY_VALUES][7] = {
		"title",	/* DETAIL_TITLE */
		"url",		/* DETAIL_URL */
		"price",	/* DETAIL_PRICE */
		"change",	/* DETAIL_CHANGE */
		"volume",	/* DETAIL_VOLUME */
		"dailyl",	/* DETAIL_DAILYL */
		"dailyh",	/* DETAIL_DAILYH */
		"exdiv",	/* DETAIL_EXDIV */
		"52l",		/* DETAIL_L52 */
		"52h",		/* DETAIL_H52 */
		"pe",		/* DETAIL_PE */
		"div",		/* DETAIL_DIV */
		"yield",	/* DETAIL_YIELD */
		"date",		/* DETAIL_DATE */
		"time",		/* DETAIL_TIME */
		"name",		/* DETAIL_NAME */
		"wsrvr",	/* DETAIL_WEBSERVER */
		"ticktp",	/* DETAIL_TICKER_TYPE */
		"symbol",	/* DETAIL_SYMBOL */
		"ltrig",	/* DETAIL_TRIGGER_LOW */
		"htrig"		/* DETAIL_TRIGGER_HIGH */
	};

	char *servers, *nextserver;
	char *types, *typeend, *nexttype, *nextend;
	int field;

	class[0] = XrmStringToQuark("Xquote");
	class[1] = XrmStringToQuark("ServerList");
	class[2] = NULLQUARK;

	name[0] = XrmStringToQuark(appname);
	name[1] = XrmStringToQuark("serverList");
	name[2] = NULLQUARK;

	/*
	** Data server(s)
	*/

	/* Get the list of servers */
	XrmQGetResource ( db, name, class, &type, &value);
	servers = XtNewString (value.addr);

	/* Set up for resource fetch */
	class[1] = XrmStringToQuark("Server");
	name[1] = XrmStringToQuark("server");
	/* when fetching query strings, these are the end */
	class[5] = NULLQUARK;
	name[5] = NULLQUARK;

	nextserver = strtok( servers, ",");
	while (nextserver) {
		/* Add new server structure */
		serv_num++;
		serv_data = (SERVER_STRUCT **) XtRealloc ( (char *)serv_data, serv_num *
				sizeof(SERVER_STRUCT *) );
		serv_data[serv_num-1] = (SERVER_STRUCT *) XtCalloc(1, sizeof(SERVER_STRUCT));

		name[2] = XrmStringToQuark (nextserver);
		nextserver[0] = toupper ( nextserver[0] );
		class[2] = XrmStringToQuark (nextserver);
		class[4] = NULLQUARK;
		name[4] = NULLQUARK;
#ifdef	VERBOSE
		fprintf(stderr, "Server [%s] is %d\n", nextserver, serv_num-1);
#endif

		/* Option menu title */
		field = 0;
		spropnames[field][0] = toupper ( spropnames[field][0] );
		class[3] = XrmStringToQuark (spropnames[field]);
		spropnames[field][0] = tolower ( spropnames[field][0] );
		name[3] = XrmStringToQuark (spropnames[field]);
		XrmQGetResource (db, name, class, &type, &value);

		if (value.addr == 0) {
			/*
			* This is one of the places where we get a NULL pointer if
			* e.g. the name of the stock exchange isn't in Xquotes
			* internal list, or if the definitions for the stock exchange
			* aren't completely consistent.
			*/
			fprintf(stderr, "Having trouble with server [%s]\n", nextserver);
#ifdef DEBUG
			fprintf(stderr, "\tSPROPNAMES[field %d] = '%s'\n", field,
					spropnames[field] ? spropnames[field] : "(null)");
			fprintf(stderr, "\tNAME [%s]\tCLASS [%s]\n", name, class);
#endif
			nextserver = strtok (NULL, ",");
			continue;
		}
#ifdef DEBUG
		else {
			fprintf(stderr, "No trouble with server [%s]\n", nextserver);
			fprintf(stderr, "\tSERV_DATA[%d] = '%s'\n", serv_num - 1, value.addr);
		}
#endif

		serv_data[serv_num-1]->title = XtNewString (value.addr);
		serv_data[serv_num-1]->num_types = 0;
		serv_data[serv_num-1]->types = (QUERY_STRUCT **)NULL;

		/* How many types */
		field = 1;
		spropnames[field][0] = toupper ( spropnames[field][0] );
		class[3] = XrmStringToQuark (spropnames[field]);
		spropnames[field][0] = tolower ( spropnames[field][0] );
		name[3] = XrmStringToQuark (spropnames[field]);
		XrmQGetResource (db, name, class, &type, &value);

		if (value.addr == 0) {
			/*
			* This is one of the places where we get a NULL pointer if
			* e.g. the name of the stock exchange isn't in Xquotes
			* internal list, or if the definitions for the stock exchange
			* aren't completely consistent.
			*/
			fprintf(stderr, "Having trouble with server [%s]\n", nextserver);
#ifdef DEBUG
			fprintf(stderr, "\tSERV_DATA[%d] = '%s'\n", serv_num - 1,
					serv_data[serv_num-1]->title);
			fprintf(stderr, "\tSPROPNAMES[field %d] = '%s'\n", field,
					spropnames[field] ? spropnames[field] : "(null)");
			fprintf(stderr, "\tNAME [%s]\tCLASS [%s]\n", name, class);
#endif
			nextserver = strtok (NULL, ",");
			continue;
		}
#ifdef DEBUG
		else {
			fprintf(stderr, "No trouble with server [%s]\n", nextserver);
			fprintf(stderr, "\tSERV_DATA[%d] = '%s'\n", serv_num - 1,
					serv_data[serv_num-1]->title);
			fprintf(stderr, "\tSPROPNAMES[field %d] = '%s'\n", field,
					spropnames[field] ? spropnames[field] : "(null)");
			fprintf(stderr, "\tNAME [%s]\tCLASS [%s]\n", name, class);
		}
#endif

		types = XtNewString (value.addr);
		typeend = types + strlen(types);

		/* First type */
		nexttype = types;
		nextend = strchr (nexttype, ',');
		if (nextend)
			*nextend = '\0';

		while (nexttype) {
			name[3] = XrmStringToQuark (nexttype);
			nexttype[0] = toupper ( nexttype[0] );
			class[3] = XrmStringToQuark (nexttype);
			serv_data[serv_num-1]->num_types++;

#ifdef	VERBOSE
			fprintf(stderr, "\tType [%s] is %d\n",
					nexttype, serv_data[serv_num-1]->num_types - 1);
#endif
			/* Add new type to server */
			SERV_TYPES = (QUERY_STRUCT **) XtRealloc ( (char *)SERV_TYPES,
				SERV_NUM_TYPES * sizeof(QUERY_STRUCT *) );
			SERV_CUR_TYPE = (QUERY_STRUCT *) XtCalloc ( 1, sizeof (QUERY_STRUCT));

			/* Fill in server fields */
			for (field = 0; field < DETAIL_NUM_QUERY_VALUES; field++) {
				qpropnames[field][0] = toupper ( qpropnames[field][0] );
				class[4] = XrmStringToQuark (qpropnames[field]);
				qpropnames[field][0] = tolower ( qpropnames[field][0] );
				name[4] = XrmStringToQuark (qpropnames[field]);
				XrmQGetResource (db, name, class, &type, &value);

				serv_data[serv_num-1]->types[SERV_NUM_TYPES-1]->values[field] =
					XtNewString (value.addr);
			}

			nexttype = nextend +1; 
			if (nexttype <= types || nexttype >= typeend)
				break;

			nextend = strchr (nexttype, ',');
			if (nextend)
				*nextend = '\0';
			else
				nextend = nexttype + strlen(nexttype);
		}

		XtFree (types);
		nextserver = strtok (NULL, ",");
	}
	XtFree (servers);

	/* 
	** News server 
	*/
	/* Add new server structure. NOTE didn't increase serv_num,  */
	/* News is present in server list, but not counted as one.   */
	serv_data = (SERVER_STRUCT **) XtRealloc ( (char *)serv_data, (serv_num+1) *
			sizeof(SERVER_STRUCT *) );
	serv_data[serv_num] = (SERVER_STRUCT *) XtCalloc (1, sizeof(SERVER_STRUCT));
	serv_data[serv_num]->title = NULL;
	serv_data[serv_num]->num_types = 1;
	serv_data[serv_num]->types = (QUERY_STRUCT **)NULL;

	/* Only one type for news server */
	serv_num++;  /* Make macros below work */
	SERV_TYPES = (QUERY_STRUCT **) XtCalloc (1, sizeof(QUERY_STRUCT *) );
	SERV_CUR_TYPE = (QUERY_STRUCT *) XtCalloc (1, sizeof (QUERY_STRUCT));
	serv_num--;  /* Make macros above work */

	class[2] = XrmStringToQuark("News");
	class[4] = NULLQUARK;
	name[2] = XrmStringToQuark("news");
	name[4] = NULLQUARK;

	for (field=DETAIL_TITLE; field<=DETAIL_PRICE; field++) {
		npropnames[field][0] = toupper ( npropnames[field][0] );
		class[3] = XrmStringToQuark( npropnames[field] );
		npropnames[field][0] = tolower ( npropnames[field][0] );
		name[3] = XrmStringToQuark( npropnames[field] );

		XrmQGetResource (db, name, class, &type, &value);
		if (field == 0) /* Set server title as well */
			serv_data[serv_num]->title = XtNewString (value.addr);
		serv_data[serv_num]->types[0]->values[field] = XtNewString (value.addr);
	}

	return (serv_num);
}

/* ARGSUSED */
void serverCB (Widget w, XtPointer menu_pos, XtPointer call_data)
{
	int server = (int)menu_pos;

	if (serv_cur != server && tickGetNum()) {
		strcpy (errmsg,
				"Network server changed with ticker symbols present.\n"
				"Unless server type names and order are identical\n"
				"you must remove and add the ticker symbols again.");
		write_status (errmsg, WARN);
	}

	setCurServer(server);
	tickMakeTypeMenu();
}
