/*

    xpuyopuyo - ptheme-gtk.c        Copyright(c) 2000 Justin David Smith
    justins(at)chaos2.org           http://chaos2.org./

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>


#include <xpuyopuyo.h>
#include <pdialog-gtk.h>
#include <psnprintf.h>
#include <pfile.h>



static bool p_pixmap_try_load_to(pwindow_gtk *w, GdkPixmap **image, GdkBitmap **mask, const char *themename, const char *imgname) {
/* p_pixmap_try_load_to */

   char mergedname[P_IO_BUFFER];
   char filename[P_IO_BUFFER];
   GdkPixmap *oldimage;
   GdkBitmap *oldmask;

   oldimage = *image;
   oldmask = *mask;
   *image = NULL;
   *mask = NULL;
   
   p_merge_path_base(mergedname, themename, imgname, P_IO_BUFFER);
   p_local_theme_file_name(filename, mergedname, P_IO_BUFFER);
   *image = gdk_pixmap_colormap_create_from_xpm(
               NULL, 
               gtk_widget_get_colormap(w->da), 
               mask,
               NULL,
               filename
            );

   if(*image == NULL) {
      p_merge_path_base(filename, P_GLOBAL_THEME_DIR, mergedname, P_IO_BUFFER);
      *image = gdk_pixmap_colormap_create_from_xpm(
                  NULL, 
                  gtk_widget_get_colormap(w->da), 
                  mask,
                  NULL,
                  filename
               );
   }
   
   if(oldimage != NULL) gdk_pixmap_unref(oldimage);
   if(oldmask != NULL)  gdk_bitmap_unref(oldmask);
   return(*image != NULL);

}



void p_pixmap_load(pwindow *w_, int imageindex, const char *themename, const char *imgname) {
/* p_pixmap_load */

   pwindow_gtk *w = (pwindow_gtk *)w_;

   if(!p_pixmap_try_load_to(w, &P_IMAGEW(w, imageindex), &P_IMAGE_MASKW(w, imageindex), themename, imgname)) {
      if(!p_pixmap_try_load_to(w, &P_IMAGEW(w, imageindex), &P_IMAGE_MASKW(w, imageindex), P_DEFAULT_THEME, imgname)) {
         fprintf(stderr, "Oops.  Image \"%s\" not found, aborting\n", imgname);
         exit(1);
      }
   }

}



bool p_pixmap_load_to(pwindow *w_, GdkPixmap **image, GdkBitmap **mask, const char *themename, const char *imgname) {
/* p_pixmap_load_to */

   pwindow_gtk *w = (pwindow_gtk *)w_;

   if(!p_pixmap_try_load_to(w, image, mask, themename, imgname)) {
      if(!p_pixmap_try_load_to(w, image, mask, P_DEFAULT_THEME, imgname)) {
         return(false);
      }
   }
   return(true);

}



void p_window_init_theme(pwindow *wp) {

   pwindow_gtk *w = (pwindow_gtk *)wp;
   int i;

   for(i = 0; i < P_NUM_IMAGES; i++) {
      P_IMAGEW(w, i) = NULL;
      P_IMAGE_MASKW(w, i) = NULL;
   }

}



void p_window_load_theme(pwindow* wp, const char *themename) {

   p_pixmap_load(wp, P_IMAGE_UNJOINED(0), themename, "img_0.xpm");
   p_pixmap_load(wp, P_IMAGE_UNJOINED(1), themename, "img_1.xpm");
   p_pixmap_load(wp, P_IMAGE_UNJOINED(2), themename, "img_2.xpm");
   p_pixmap_load(wp, P_IMAGE_UNJOINED(3), themename, "img_3.xpm");
   p_pixmap_load(wp, P_IMAGE_UNJOINED(4), themename, "img_4.xpm");
   p_pixmap_load(wp, P_IMAGE_UNJOINED(5), themename, "img_5.xpm");
      
   p_pixmap_load(wp, P_IMAGE_JOINED(0), themename, "img_0j.xpm");
   p_pixmap_load(wp, P_IMAGE_JOINED(1), themename, "img_1j.xpm");
   p_pixmap_load(wp, P_IMAGE_JOINED(2), themename, "img_2j.xpm");
   p_pixmap_load(wp, P_IMAGE_JOINED(3), themename, "img_3j.xpm");
   p_pixmap_load(wp, P_IMAGE_JOINED(4), themename, "img_4j.xpm");
   p_pixmap_load(wp, P_IMAGE_JOINED(5), themename, "img_5j.xpm");
   
   p_pixmap_load(wp, P_IMAGE_CLEAR_BLUE, themename, "img_clear.xpm");
   p_pixmap_load(wp, P_IMAGE_CLEAR_RED, themename, "img_clearb.xpm");

   p_pixmap_load(wp, P_IMAGE_ROCK(0), themename, "img_rock.xpm");
   p_pixmap_load(wp, P_IMAGE_ROCK(1), themename, "img_rockbig.xpm");
   p_pixmap_load(wp, P_IMAGE_ROCK(2), themename, "img_rockdemon.xpm");
   p_pixmap_load(wp, P_IMAGE_ROCK(3), themename, "img_ind.xpm");

   p_pixmap_load(wp, P_IMAGE_EXPLOSION, themename, "img_expl.xpm");

   p_pixmap_load(wp, P_IMAGE_BORDER_TOP, themename, "img_tile_top.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_TOPLEFT, themename, "img_tile_lefttop.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_TOPRIGHT,themename, "img_tile_righttop.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_TOPRIGHT,themename, "img_tile_righttop.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_LEFT, themename, "img_tile_left.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_RIGHT,themename, "img_tile_right.xpm");
   
   p_pixmap_load(wp, P_IMAGE_BORDER_BOTTOMLEFT, themename, "img_tile_leftbottom.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_BOTTOMRIGHT,themename, "img_tile_rightbottom.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_BOTTOM(0),  themename, "img_tile_bottom1.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_BOTTOM(1),  themename, "img_tile_bottom2.xpm");
   p_pixmap_load(wp, P_IMAGE_BORDER_BOTTOM(2),  themename, "img_tile_bottom3.xpm");

   p_pixmap_load(wp, P_IMAGE_GAME_TITLE,  themename, "img_title.xpm");

   p_pixmap_load(wp, P_IMAGE_GAME_OVER,   themename, "img_gameover.xpm");

   p_pixmap_load(wp, P_IMAGE_PAUSED,      themename, "img_paused.xpm");

   p_pixmap_load(wp, P_IMAGE_NUMBER(0), themename, "img_num0.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(1), themename, "img_num1.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(2), themename, "img_num2.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(3), themename, "img_num3.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(4), themename, "img_num4.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(5), themename, "img_num5.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(6), themename, "img_num6.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(7), themename, "img_num7.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(8), themename, "img_num8.xpm");
   p_pixmap_load(wp, P_IMAGE_NUMBER(9), themename, "img_num9.xpm");
   
   return;

}



#define P_THEME_GTK_NUM_COLS        16



static void p_process_directory(pwindow_gtk *w, GtkWidget *clist, char *strings[], const char *dirname) {

   DIR *d;
   gchar *txt;
   const char *basename;
   char fullname[P_GTK_STRING_BUFFER];
   struct dirent *de;
   struct stat s;
   GdkPixmap *image;
   GdkBitmap *mask;
   int found;
   int j;
   
   d = opendir(dirname);
   if(d != NULL) {
      while((de = readdir(d)) != NULL) {
         basename = de->d_name;
         p_snprintf(fullname, P_GTK_STRING_BUFFER, "%s/%s", dirname, basename);
         if(basename[0] != '.' && stat(fullname, &s) == 0) {
            j = 0;
            found = 0;
            while(!found && gtk_clist_get_text(GTK_CLIST(clist), j, 0, &txt)) {
               if(!strcmp(txt, basename)) found = 1;
               j++;
            }
            if(!found && S_ISDIR(s.st_mode)) {
               j = 0;
               p_strncpy(strings[j], basename, P_GTK_STRING_BUFFER); j++;
               p_strncpy(strings[j], "", P_GTK_STRING_BUFFER); j++;
               p_strncpy(strings[j], "", P_GTK_STRING_BUFFER); j++;
               p_strncpy(strings[j], "", P_GTK_STRING_BUFFER); j++;
               p_strncpy(strings[j], "", P_GTK_STRING_BUFFER); j++;
               j = gtk_clist_append(GTK_CLIST(clist), strings);

               image = mask = NULL;
               if(p_pixmap_load_to((pwindow *)w, &image, &mask, basename, "img_0.xpm")) {
                  gtk_clist_set_pixmap(GTK_CLIST(clist), j, 1, image, mask);
                  gtk_clist_set_column_width(GTK_CLIST(clist), 1, pixmap_width(image));
                  gdk_pixmap_unref(image);
                  gdk_bitmap_unref(mask);
               }

               image = mask = NULL;
               if(p_pixmap_load_to((pwindow *)w, &image, &mask, basename, "img_1.xpm")) {
                  gtk_clist_set_pixmap(GTK_CLIST(clist), j, 2, image, mask);
                  gtk_clist_set_column_width(GTK_CLIST(clist), 2, pixmap_width(image));
                  gdk_pixmap_unref(image);
                  gdk_bitmap_unref(mask);
               }

               image = mask = NULL;
               if(p_pixmap_load_to((pwindow *)w, &image, &mask, basename, "img_2.xpm")) {
                  gtk_clist_set_pixmap(GTK_CLIST(clist), j, 3, image, mask);
                  gtk_clist_set_column_width(GTK_CLIST(clist), 3, pixmap_width(image));
                  gdk_pixmap_unref(image);
                  gdk_bitmap_unref(mask);
               }

               image = mask = NULL;
               if(p_pixmap_load_to((pwindow *)w, &image, &mask, basename, "img_rock.xpm")) {
                  gtk_clist_set_pixmap(GTK_CLIST(clist), j, 4, image, mask);
                  gtk_clist_set_column_width(GTK_CLIST(clist), 4, pixmap_width(image));
                  gdk_pixmap_unref(image);
                  gdk_bitmap_unref(mask);
               }

               gtk_clist_set_row_height(GTK_CLIST(clist), pixmap_height(image));
               if(!strcmp(w->c->theme, basename)) gtk_clist_select_row(GTK_CLIST(clist), j, 0);
            }
         }
      }
      closedir(d);
   }
   return;

}



static void p_theme_select_row(GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer data) {

   char *buf = data;
   gchar *txt;
   
   if(gtk_clist_get_text(clist, row, 0, &txt)) {
      p_strncpy(buf, txt, P_GTK_STRING_BUFFER);
   }

}



void p_theme_apply(p_dialog_window *dw) {

   char *theme = dw->data;      
   pwindow_gtk *w = (pwindow_gtk *)dw->w;
   p_strncpy(w->c->theme, theme, P_THEME_NAME_SIZE);
   p_window_load_theme((pwindow *)w, w->c->theme);
   w->c->needredraw = true;
   return;

}



void p_theme_select(pwindow_gtk *w) {

   char *strings[P_GTK_STRING_BUFFER];
   char buf[P_GTK_STRING_BUFFER];
   p_dialog_window dw;
   GtkWidget *scroll;
   GtkWidget *clist;
   int i, j;

   p_strncpy(buf, w->c->theme, P_GTK_STRING_BUFFER);
   
   p_dialog_window_new(&dw, w, "Select New Theme", NULL, P_DIALOG_OK | P_DIALOG_CANCEL | P_DIALOG_APPLY | P_DIALOG_NONMODAL);
   p_dialog_window_set_apply(&dw, p_theme_apply);
   p_dialog_window_set_data(&dw, buf);

   scroll = gtk_scrolled_window_new(NULL, NULL);
   gtk_box_pack_start(GTK_BOX(dw.container), scroll, FALSE, FALSE, 0);

   for(i = 0; i < P_THEME_GTK_NUM_COLS; i++) {
      strings[i] = (gchar *)malloc(P_GTK_STRING_BUFFER);
      *(strings[i] + P_GTK_STRING_BUFFER - 1) = '\0';
   }
   j = 0;
   p_strncpy(strings[j++], "Name", P_GTK_STRING_BUFFER - 1);
   p_strncpy(strings[j++], "", P_GTK_STRING_BUFFER - 1);
   p_strncpy(strings[j++], "", P_GTK_STRING_BUFFER - 1);
   p_strncpy(strings[j++], "", P_GTK_STRING_BUFFER - 1);
   p_strncpy(strings[j++], "", P_GTK_STRING_BUFFER - 1);
   clist = gtk_clist_new_with_titles(j, strings);
   
   gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_SINGLE);
   gtk_clist_column_titles_passive(GTK_CLIST(clist));
   gtk_clist_set_column_width(GTK_CLIST(clist), 0, 120);
   gtk_widget_set_usize(scroll, 265, 300);
      
   gtk_clist_set_shadow_type(GTK_CLIST(clist), GTK_SHADOW_OUT);
   gtk_container_add(GTK_CONTAINER(scroll), clist);

   p_local_theme_file_name(buf, "", P_GTK_STRING_BUFFER);
   p_process_directory(w, clist, strings, buf);
   p_process_directory(w, clist, strings, P_GLOBAL_THEME_DIR);
   for(i = 0; i < P_THEME_GTK_NUM_COLS; i++) free(strings[i]);
   
   gtk_signal_connect(GTK_OBJECT(clist), "select-row", GTK_SIGNAL_FUNC(p_theme_select_row), buf);

   p_dialog_window_run(&dw);

}
