/*

    xpuyopuyo - phigh-gtk.c         Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org           http://chaos2.org/

    High score display code


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <xpuyopuyo.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <phigh-gtk.h>
#include <pdialog-gtk.h>
#include <psnprintf.h>



#define P_HIGH_GTK_NUM_COLS      16



void p_high_score_window(pwindow_gtk *w) {

   p_dialog_window dw;
   gchar *strings[P_HIGH_GTK_NUM_COLS];
   GtkWidget *clist;
   GtkWidget *scroll;
   int i;
   int j;
   
   p_dialog_window_new(&dw, w, "High Scores", NULL, P_DIALOG_CLOSE | P_DIALOG_NONMODAL);

   scroll = gtk_scrolled_window_new(NULL, NULL);
   gtk_box_pack_start(GTK_BOX(dw.container), scroll, FALSE, FALSE, 0);

   for(i = 0; i < P_HIGH_GTK_NUM_COLS; i++) {
      strings[i] = (gchar *)malloc(P_GTK_STRING_BUFFER);
      *(strings[i] + P_GTK_STRING_BUFFER - 1) = '\0';
   }
   j = 0;
   p_strncpy(strings[j++], "Rank", P_GTK_STRING_BUFFER - 1);
   p_strncpy(strings[j++], "Name", P_GTK_STRING_BUFFER - 1);
   p_strncpy(strings[j++], "Score", P_GTK_STRING_BUFFER - 1);
   clist = gtk_clist_new_with_titles(j, strings);
   
   gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_SINGLE);
   gtk_clist_column_titles_passive(GTK_CLIST(clist));
   gtk_clist_set_column_width(GTK_CLIST(clist), 0, 50);
   gtk_clist_set_column_width(GTK_CLIST(clist), 1, 150);
   gtk_clist_set_column_width(GTK_CLIST(clist), 2, 70);
   gtk_widget_set_usize(scroll, 330, 300);
      
   gtk_clist_set_shadow_type(GTK_CLIST(clist), GTK_SHADOW_OUT);
   gtk_container_add(GTK_CONTAINER(scroll), clist);

   for(i = 0; i < P_HIGH_SCORE_COUNT; i++) {
      j = 0;
      p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%5d", i + 1); j++;
      p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%s",  w->c->high[i].name); j++;
      p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%5d",  w->c->high[i].score); j++;
      gtk_clist_append(GTK_CLIST(clist), strings);
      gtk_clist_set_selectable(GTK_CLIST(clist), i, FALSE);
   }
   for(i = 0; i < P_HIGH_GTK_NUM_COLS; i++) free(strings[i]);

   p_dialog_window_run(&dw);
   return;
   
}
